/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.paywriteback;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.PushPayBillVerifyHelper;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class IntBillPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject interestBill) {
        this.addForwardValid(interestBill);
        super.doSaveValidateExecute(param, interestBill);
        this.addDefineOpValid(param, interestBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.writeBackBizDeal(param, sourceBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.writeBackBizDeal(param, sourceBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject interestBill) {
        super.doDeleteExecute(param, interestBill);
        this.reserveWriteBackBizDeal(param, interestBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject interestBill) {
        super.doChargebackExecute(param, interestBill);
        this.reserveWriteBackBizDeal(param, interestBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject interestBill) {
        super.doRenoteExecute(param, interestBill);
        this.reserveWriteBackBizDeal(param, interestBill);
    }

    private void writeBackBizDeal(PayBillWriteBackParam param, DynamicObject interestBill) {
        String payBillNo = null;
        Long payBillId = null;
        DynamicObject latestPayBill = this.getLatestPayBill(interestBill, null);
        if (latestPayBill == null) {
            payBillNo = param.getPayBill().getPayBillNo();
            payBillId = param.getPayBill().getPayBillId();
        } else {
            payBillNo = latestPayBill.getString("billno");
            payBillId = latestPayBill.getLong("id");
        }
        interestBill.set("payeebillno", (Object)payBillNo);
        DynamicObject paybill = TmcDataServiceHelper.newDynamicObject((String)"cas_paybill");
        paybill.set("id", (Object)payBillId);
        interestBill.set("paybill", (Object)paybill);
        BigDecimal dbAllPayAmt = this.getSourceBillLockPayAmount(interestBill, null);
        interestBill.set("lockpayamt", (Object)dbAllPayAmt);
        this.DBTxBizUpdate(interestBill);
    }

    private void reserveWriteBackBizDeal(PayBillWriteBackParam param, DynamicObject interestBill) {
        if (interestBill == null) {
            return;
        }
        Set payBillIds = this.getCachePayBillIds(param);
        payBillIds.add(param.getPayBill().getPayBillId());
        BigDecimal dbAllPayAmt = this.batchGetSourceBillLockPayAmount(interestBill, payBillIds);
        interestBill.set("lockpayamt", (Object)dbAllPayAmt);
        if (!PayBillWriteBackOperateEnum.isDelete((String)param.getOperate())) {
            payBillIds.remove(param.getPayBill().getPayBillId());
        }
        DynamicObject latestPayBill = this.getLatestPayBill(interestBill, payBillIds);
        String payBillNo = "";
        DynamicObject paybill = null;
        if (EmptyUtil.isNoEmpty((DynamicObject)latestPayBill)) {
            payBillNo = latestPayBill.getString("billno");
            paybill = TmcDataServiceHelper.newDynamicObject((String)"cas_paybill");
            paybill.set("id", (Object)latestPayBill.getLong("id"));
        }
        interestBill.set("payeebillno", (Object)payBillNo);
        interestBill.set("paybill", (Object)paybill);
        this.DBTxBizUpdate(interestBill);
    }

    private void addForwardValid(DynamicObject bill) {
        String error = PushPayBillVerifyHelper.verifyInterestBill((DynamicObject)bill, (boolean)Boolean.TRUE, (boolean)Boolean.FALSE);
        if (EmptyUtil.isNoEmpty((String)error)) {
            throw new KDBizException(error);
        }
    }

    private void addDefineOpValid(PayBillWriteBackParam param, DynamicObject interestBill) {
        if (!InterestbillctgEnum.isPayprinandinte((String)interestBill.getString("instbillctg"))) {
            return;
        }
        QFilter repayLoanEntryQfiler = new QFilter("loans.e_loanbill", "=", (Object)interestBill.getLong("sourcebillid")).and(new QFilter("loans.e_combineinst", "=", (Object)Boolean.TRUE)).and(new QFilter("id", "=", (Object)interestBill.getLong("repaymentid")));
        DynamicObject repayInfo = QueryServiceHelper.queryOne((String)"cfm_repaymentbill", (String)"billno", (QFilter[])repayLoanEntryQfiler.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)repayInfo)) {
            PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue((String)param.getOperate());
            String operateName = operateEnum != null ? operateEnum.getName() : param.getOperate();
            String error = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: \u8be5\u4e0a\u6e38\u7684\u4ed8\u606f\u5355:[%2$s]\u5bf9\u5e94\u8fd8\u6b3e\u5355[%3$s]\u4e2d\u7684\u63d0\u6b3e\u5355[%4$s]\u5206\u5f55\u5df2\u7ecf\u52fe\u9009\u5408\u5e76\u5229\u606f,\u4e0d\u80fd\u518d\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"InterestBillPayBillWriteBackService_01", (String)"tmc-cfm-mservice", (Object[])new Object[0]), operateName, interestBill.getString("billno"), repayInfo.getString("billno"), interestBill.getString("loanbillno"));
            throw new KDBizException(error);
        }
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        String selectProps = "id,isrelcash,isinit,eassrcid,billno,billstatus,confirmstatus,actualinstamt,currency.id,bizdate,payeebillno,paybill,lockpayamt,combineinst,repaymentid,loanbillno,instbillctg,sourcebillid";
        Object[] interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)selectProps, (QFilter[])new QFilter("id", "=", (Object)payBillInfo.getSourceBillId()).toArray());
        return EmptyUtil.isNoEmpty((Object[])interestBills) ? interestBills[0] : null;
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getLong("currency.id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("actualinstamt");
    }

    protected boolean beforePayBillWriteBack(List<PayBillWriteBackParam> writeBackParams) {
        super.beforePayBillWriteBack(writeBackParams);
        this.checkMergePayBillValid(writeBackParams);
        return true;
    }

    private void checkMergePayBillValid(List<PayBillWriteBackParam> writeBackParams) {
        DynamicObjectCollection interestBills;
        Map<String, List<DynamicObject>> map;
        if (!PayBillWriteBackOperateEnum.isValidate((String)writeBackParams.get(0).getOperate())) {
            return;
        }
        List billIds = writeBackParams.stream().map(p -> p.getPayBill().getSourceBillId()).collect(Collectors.toList());
        if (billIds.size() > 1 && (map = (interestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"billno,textcreditor,org.id,instbankacct.id,currency.id,datasource", (QFilter[])new QFilter("id", "in", billIds).toArray())).stream().collect(Collectors.groupingBy(this::getKey))).size() > 1) {
            String billnos = interestBills.stream().map(d -> d.getString("billno")).collect(Collectors.joining(", "));
            boolean isBond = DataSourceEnum.isBond((String)((DynamicObject)interestBills.get(0)).getString("datasource"));
            if (isBond) {
                throw new KDBizException(CfmCommonResourceEnum.Push2PayValidator_10.loadKDString(new Object[]{billnos}));
            }
            throw new KDBizException(CfmCommonResourceEnum.Push2PayValidator_9.loadKDString(new Object[]{billnos}));
        }
    }

    private String getKey(DynamicObject interestBill) {
        boolean isBond = DataSourceEnum.isBond((String)interestBill.getString("datasource"));
        if (isBond) {
            return String.format("%d_%d_%d", interestBill.getLong("org.id"), interestBill.getLong("instbankacct.id"), interestBill.getLong("currency.id"));
        }
        return String.format("%d_%s_%d_%d", interestBill.getLong("org.id"), interestBill.getString("textcreditor"), interestBill.getLong("instbankacct.id"), interestBill.getLong("currency.id"));
    }
}

