/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.recwriteback;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;

public class LoanBillRecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SELECT_PROP = "id,billno,currency.id,receivedate,drawamount,payedintamount,payeebillno,recvbill.id";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("payeebillno", (Object)param.getRecBill().getRecBillNo());
        sourceBill.set("recvbill", (Object)param.getRecBill().getRecBillId());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doReceiveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doReceiveExecute(param, sourceBill);
        RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
        if (recBill.getPayeeDate() == null) {
            DynamicObject receiveBill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"payeedate", (QFilter[])new QFilter("id", "=", (Object)recBill.getRecBillId()).toArray());
            recBill.setPayeeDate(receiveBill.getDate("payeedate"));
        }
        sourceBill.set("receivedate", (Object)recBill.getPayeeDate());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doCancelReceiveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doCancelReceiveExecute(param, sourceBill);
        sourceBill.set("receivedate", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("receivedate", null);
        sourceBill.set("payeebillno", null);
        sourceBill.set("recvbill", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        return TmcDataServiceHelper.loadSingle((Object)param.getRecBill().getSourceBillId(), (String)"cfm_loanbill", (String)SELECT_PROP);
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getLong("currency.id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("drawamount").subtract(sourceBill.getBigDecimal("payedintamount"));
    }
}

