/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositScOrgUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DepositScOrgUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                result.setLog("start upgrade depositBillPreInt creditorg");
                this.upgradePreIntBill();
                result.setLog("end upgrade depositBillPreInt creditorg");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
            }
        }
        return result;
    }

    private void upgradePreIntBill() {
        String querySql = "select fid, fclientorgid from t_cfm_preinterestbill where fid in (select fid from t_cfm_preinterestbill_e where fcreditorgid = 0 and fdatasource = 'cim')";
        DataSet depositBills = DB.queryDataSet((String)"upgradeDepositBill", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (depositBills.isEmpty()) {
            return;
        }
        ArrayList<Long> finOrgIds = new ArrayList<Long>(16);
        for (Row row : depositBills.copy()) {
            finOrgIds.add(row.getLong("fclientorgid"));
        }
        StringJoiner sj = new StringJoiner(",");
        finOrgIds.forEach(v -> sj.add(v.toString()));
        querySql = String.format("select fid,forgid from t_bd_finorginfo where fid in (%s)", sj.toString());
        DataSet finOrgInfos = DB.queryDataSet((String)"queryFinOrg", (DBRoute)DBRouteConst.SYS, (String)querySql);
        if (finOrgInfos.isEmpty()) {
            return;
        }
        HashMap<Long, Long> finOrgInfoMap = new HashMap<Long, Long>(16);
        for (Row row : finOrgInfos) {
            Long orgId = row.getLong("forgid");
            if (!EmptyUtil.isNoEmpty((Long)orgId)) continue;
            finOrgInfoMap.put(row.getLong("fid"), orgId);
        }
        if (finOrgInfoMap.size() == 0) {
            return;
        }
        String updateSql = "update t_cfm_preinterestbill_e set fcreditorgid = ? where fid = ? and fcreditorgid = 0 and fdatasource = 'cim'";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Row depositBill : depositBills) {
            Long scOrgId;
            Long finOrgInfoId = depositBill.getLong("fclientorgid");
            if (EmptyUtil.isEmpty((Long)finOrgInfoId) || EmptyUtil.isEmpty((Long)(scOrgId = (Long)finOrgInfoMap.get(finOrgInfoId)))) continue;
            Object[] params = new Object[]{scOrgId, depositBill.getLong("fid")};
            paramsList.add(params);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, paramsList);
        }
    }
}

