/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.ListUtils;

public class LockPayAmtUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(LockPayAmtUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.upgradeRepayLockPayAmt();
                this.upgradeIntLockPayAmt();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage());
                logger.error(result.getErrorInfo());
            }
        }
        return result;
    }

    private void upgradeRepayLockPayAmt() {
        logger.info("Start to update repaymentBill.");
        String querySql = "select fsourcebillid,factpayamount from t_cas_paymentbill where fsourcebilltype='cfm_repaymentbill' and fbillstatus not in ('G','F')";
        DataSet repayPayDs = DB.queryDataSet((String)"queryPayBillForRepay", (DBRoute)DBRoute.of((String)"fi"), (String)querySql);
        if (repayPayDs.isEmpty()) {
            return;
        }
        DataSet payResultDs = repayPayDs.groupBy(new String[]{"fsourcebillid"}).sum("factpayamount").finish();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(500);
        for (Row row : payResultDs) {
            paramList.add(new Object[]{row.getBigDecimal("factpayamount"), row.getLong("fsourcebillid")});
        }
        logger.info("Batch update repaymentBill size: {}", (Object)paramList.size());
        String sql = "update t_cfm_repaymentbill_e set flockpayamt = ? where fid= ? ";
        List batchList = ListUtils.splitList(paramList, (long)500L);
        for (int i = 0; i < batchList.size(); ++i) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, (List)((List)batchList.get(i)));
        }
        logger.info("Update repaymentBill successfully.");
    }

    private void upgradeIntLockPayAmt() {
        logger.info("Start to update intBill.");
        String querySql = "select fsourcebillid,factpayamount from t_cas_paymentbill where fsourcebilltype='cfm_interestbill' and fbillstatus not in ('G','F')";
        DataSet repayPayDs = DB.queryDataSet((String)"queryPayBillForInt", (DBRoute)DBRoute.of((String)"fi"), (String)querySql);
        if (repayPayDs.isEmpty()) {
            return;
        }
        DataSet payResultDs = repayPayDs.groupBy(new String[]{"fsourcebillid"}).sum("factpayamount").finish();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(500);
        for (Row row : payResultDs) {
            paramList.add(new Object[]{row.getBigDecimal("factpayamount"), row.getLong("fsourcebillid")});
        }
        logger.info("Batch update intBill size: {}", (Object)paramList.size());
        String sql = "update t_cfm_interestbill_e set flockpayamt = ? where fid= ? ";
        List batchList = ListUtils.splitList(paramList, (long)500L);
        for (int i = 0; i < batchList.size(); ++i) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, (List)((List)batchList.get(i)));
        }
        logger.info("Update intBill successfully.");
    }
}

