/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreIntBillUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            this.upgradeCreditOrg();
        }
        return result;
    }

    private void upgradeCreditOrg() {
        String querySql = "select tcpe.fid, tcpe.fcreditorgid,tcp.fsettlecenterid,tcp.fcreditortype,tcpe.fdatasource from t_cfm_preinterestbill_e tcpe left join t_cfm_preinterestbill tcp on tcpe .fid = tcp.fid where tcpe.fdatasource in ('ifm', 'cfm') and tcp.fcreditortype = 'settlecenter' and ((tcpe.fcreditorgid > 0 and tcpe.fcreditorgid = tcp.fcreditorid) or tcpe.fcreditorgid = 0 or tcpe.fcreditorgid is null);";
        DataSet preIntBills = DB.queryDataSet((String)"upgradeCreditOrg", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (preIntBills.isEmpty()) {
            return;
        }
        ArrayList<Long> finOrgIds = new ArrayList<Long>(16);
        for (Row row : preIntBills.copy()) {
            finOrgIds.add(row.getLong("fsettlecenterid"));
        }
        StringJoiner sj = new StringJoiner(",");
        finOrgIds.forEach(v -> sj.add(v.toString()));
        querySql = String.format("select fid,forgid from t_bd_finorginfo where fid in (%s)", sj.toString());
        DataSet finOrgInfos = DB.queryDataSet((String)"queryFinOrg", (DBRoute)DBRouteConst.SYS, (String)querySql);
        if (finOrgInfos.isEmpty()) {
            return;
        }
        HashMap<Long, Long> finOrgInfoMap = new HashMap<Long, Long>(16);
        for (Row row : finOrgInfos) {
            Long orgId = row.getLong("forgid");
            if (!EmptyUtil.isNoEmpty((Long)orgId)) continue;
            finOrgInfoMap.put(row.getLong("fid"), orgId);
        }
        if (finOrgInfoMap.size() == 0) {
            return;
        }
        String updateSql = "update t_cfm_preinterestbill_e set fcreditorgid = ? where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Row preIntBill : preIntBills) {
            Long scOrgId;
            Long finOrgInfoId = preIntBill.getLong("fsettlecenterid");
            if (EmptyUtil.isEmpty((Long)finOrgInfoId) || EmptyUtil.isEmpty((Long)(scOrgId = (Long)finOrgInfoMap.get(finOrgInfoId)))) continue;
            Object[] params = new Object[]{scOrgId, preIntBill.getLong("fid")};
            paramsList.add(params);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, paramsList);
        }
    }
}

