/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.bean;

import java.math.BigDecimal;
import java.util.Date;

public class RepayPlanInfo {
    private Date repayDate;
    private BigDecimal repayAmount;
    private BigDecimal repayedAmount;
    private BigDecimal unRepayAmount;
    private Integer status = 0;

    private RepayPlanInfo() {
    }

    public static RepayPlanInfo build(Date repayDate, BigDecimal repayAmount) {
        return RepayPlanInfo.build(repayDate, repayAmount, BigDecimal.ZERO);
    }

    public static RepayPlanInfo build(Date repayDate, BigDecimal repayAmount, BigDecimal unRepayAmount) {
        return new RepayPlanInfo().setRepayDate(repayDate).setRepayAmount(repayAmount).setUnRepayAmount(unRepayAmount).setRepayedAmount(repayAmount.subtract(unRepayAmount));
    }

    public boolean repayed() {
        return Integer.valueOf(1).equals(this.status);
    }

    public RepayPlanInfo updateRepayedAmount() {
        this.repayedAmount = this.repayAmount.subtract(this.unRepayAmount);
        return this;
    }

    public Date getRepayDate() {
        return this.repayDate;
    }

    public RepayPlanInfo setRepayDate(Date repayDate) {
        this.repayDate = repayDate;
        return this;
    }

    public BigDecimal getRepayAmount() {
        return this.repayAmount;
    }

    public RepayPlanInfo setRepayAmount(BigDecimal repayAmount) {
        this.repayAmount = repayAmount;
        return this;
    }

    public BigDecimal getUnRepayAmount() {
        return this.unRepayAmount;
    }

    public RepayPlanInfo setUnRepayAmount(BigDecimal unRepayAmount) {
        this.unRepayAmount = unRepayAmount;
        this.status = unRepayAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0;
        return this;
    }

    public BigDecimal getRepayedAmount() {
        return this.repayedAmount;
    }

    public RepayPlanInfo setRepayedAmount(BigDecimal repayedAmount) {
        this.repayedAmount = repayedAmount;
        return this;
    }

    public Integer getStatus() {
        return this.status;
    }

    public RepayPlanInfo setStatus(Integer status) {
        this.status = status;
        return this;
    }
}

