/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.enums.LoanTypeEnum;

public enum BatchIntViewInfoEnum {
    LOANINT("cfm_intbill_batch_b", "cfm_intbill_batch_loan", "cfm_interestbill_b", "2ATRAHETECVS", "loan", "loan", "cfm_loanbill_b_l", "cfm_loancontract_bl_l"),
    LOANPREINT("cfm_intbill_batch_pre_b", "cfm_intbill_batch_pre", "cfm_preinterestbill_b", "2ATRHPK5ZL2O", "preint", "loan", "cfm_loanbill_b_l", "cfm_loancontract_bl_l"),
    ENTRUSTINT("cfm_intbill_batch_e", "cfm_intbill_batch_loan", "cfm_interestbill_e", "2ATRFN3QLV/T", "loan", "entrust", "cfm_loanbill_e_l", "cfm_loancontract_ic_l"),
    ENTRUSTPREINT("cfm_intbill_batch_pre_e", "cfm_intbill_batch_pre", "cfm_preinterestbill_e", "2ATRIP51WZ36", "preint", "entrust", "cfm_loanbill_e_l", "cfm_loancontract_ic_l"),
    ECINT("cfm_intbill_batch_invest", "cfm_intbill_batch_loan", "cim_invest_interestbill", "2ATRGL2DUW0L", "loan", "ec", "cim_invest_loanbill", "cim_invest_contract"),
    ECPREINT("cfm_intbill_batch_pre_cim", "cfm_intbill_batch_pre", "cim_preinterestbill", "2EG35N3FECWB", "preint", "ec", "cim_invest_loanbill", "cim_invest_contract"),
    BONDINT("cfm_intbill_batch_bond", "cfm_intbill_batch_loan", "cfm_interestbill_bond", "47156aff000000ac", "loan", "bond", "cfm_loanbill_bond", "cfm_loancontract_bo"),
    BONDPREINT("cfm_intbill_batch_pre_d", "cfm_intbill_batch_pre", "cfm_preinterestbill_bond", "47156aff000000ac", "preint", "bond", "cfm_loanbill_bond", "cfm_loancontract_bo"),
    IFMLOANINT("ifm_intbill_batch_loan", "ifm_intbill_batch_loan", "ifm_interestbill", "47156aff000000ac", "loan", "ifm", "ifm_loanbill", "ifm_loancontractbill"),
    IFMLOANPREINT("ifm_intbill_batch_pre", "cfm_intbill_batch_pre", "", "47156aff000000ac", "preint", "ifm", "ifm_loanbill", "ifm_loancontractbill"),
    IFMCURRENTINT("ifm_intbill_batch_current", "ifm_intbill_batch_current", "ifm_currentintbill", "47156aff000000ac", "loan", "ifm", "ifm_intobject", ""),
    CIMDEPOSITINT("cim_depositprebatch", "cim_depositprebatch", "ifm_currentintbill", "47156aff000000ac", "preint", LoanTypeEnum.DEPOSIT.getValue(), "cim_deposit", ""),
    IFMDEPOSITINT("ifm_depositprebatch", "ifm_depositprebatch", "ifm_currentintbill", "47156aff000000ac", "preint", LoanTypeEnum.DEPOSIT.getValue(), "cim_deposit", ""),
    IFMBANKCURRENTINT("ifm_intbill_batch_bank", "ifm_intbill_batch_bank", "ifm_currentintbill", "47156aff000000ac", "loan", "ifm", "ifm_intobject", ""),
    IFMBANKLOANPREINT("ifm_accrual_batch_bank", "cfm_intbill_batch_pre", "", "47156aff000000ac", "preint", "ifm", "ifm_loanbill", "ifm_loancontractbill");

    private String formId;
    private String entityId;
    private String permissionId;
    private String operateType;
    private String loanType;
    private String loanBillFormId;
    private String contractFormId;
    private String intBillFormId;
    private static final Log logger;

    private BatchIntViewInfoEnum(String formId, String entityId, String intBillFormId, String permissionId, String operateType, String loanType, String loanBillFormId, String contractFormId) {
        this.formId = formId;
        this.entityId = entityId;
        this.intBillFormId = intBillFormId;
        this.permissionId = permissionId;
        this.loanType = loanType;
        this.operateType = operateType;
        this.loanBillFormId = loanBillFormId;
        this.contractFormId = contractFormId;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getPermissionId() {
        return this.permissionId;
    }

    public String getLoanType() {
        return this.loanType;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public String getLoanBillFormId() {
        return this.loanBillFormId;
    }

    public String getContractFormId() {
        return this.contractFormId;
    }

    public String getIntBillFormId() {
        return this.intBillFormId;
    }

    public static BatchIntViewInfoEnum getInfoEnumByFormId(String formId) {
        for (BatchIntViewInfoEnum batchIntViewInfo : BatchIntViewInfoEnum.values()) {
            if (!StringUtils.equals((CharSequence)batchIntViewInfo.getFormId(), (CharSequence)formId)) continue;
            return batchIntViewInfo;
        }
        if (StringUtils.equals((CharSequence)"cfm_intbill_batch_pre", (CharSequence)formId)) {
            return LOANPREINT;
        }
        return LOANINT;
    }

    public static BatchIntViewInfoEnum getInfoEnumByLoanIdAndOpType(String loanBillFormId, String operateType) {
        for (BatchIntViewInfoEnum batchIntViewInfo : BatchIntViewInfoEnum.values()) {
            if (!StringUtils.equals((CharSequence)batchIntViewInfo.getLoanBillFormId(), (CharSequence)loanBillFormId) || !StringUtils.equals((CharSequence)batchIntViewInfo.getOperateType(), (CharSequence)operateType)) continue;
            return batchIntViewInfo;
        }
        return null;
    }

    public static BatchIntViewInfoEnum getInfoEnum(String loanBillFormId, String operateType) {
        for (BatchIntViewInfoEnum batchIntViewInfo : BatchIntViewInfoEnum.values()) {
            if (!StringUtils.equals((CharSequence)batchIntViewInfo.getLoanBillFormId(), (CharSequence)loanBillFormId) || !StringUtils.equals((CharSequence)batchIntViewInfo.getOperateType(), (CharSequence)operateType)) continue;
            return batchIntViewInfo;
        }
        logger.info("loanBillFormId:{},operateType:{}", (Object)loanBillFormId, (Object)operateType);
        throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5904\u4e0d\u652f\u6301\u4ed8\u606f\u3002", (String)"BatchIntViewInfoEnum_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
    }

    public static BatchIntViewInfoEnum getBatchViewInfo(String loanType, String operateType) {
        for (BatchIntViewInfoEnum batchIntViewInfo : BatchIntViewInfoEnum.values()) {
            if (!StringUtils.equals((CharSequence)batchIntViewInfo.getLoanType(), (CharSequence)loanType) || !StringUtils.equals((CharSequence)batchIntViewInfo.getOperateType(), (CharSequence)operateType)) continue;
            return batchIntViewInfo;
        }
        return null;
    }

    static {
        logger = LogFactory.getLog(BatchIntViewInfoEnum.class);
    }
}

