/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;

public enum BizTypeEnum {
    LOAN("loan"),
    ENTRUST("entrust"),
    SL("sl"),
    EC("ec"),
    FINLEASE("finlease"),
    BOND("bond");

    private String value;

    private BizTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static List<String> getSameTypeComb(String bizType) {
        ArrayList<String> result = new ArrayList<String>(2);
        switch (bizType) {
            case "loan": 
            case "sl": {
                result.add(LOAN.getValue());
                result.add(SL.getValue());
                break;
            }
            case "entrust": 
            case "ec": {
                result.add(ENTRUST.getValue());
                result.add(EC.getValue());
                break;
            }
            case "bond": {
                result.add(BOND.getValue());
                break;
            }
            case "finlease": {
                result.add(FINLEASE.getValue());
            }
        }
        return result;
    }

    public static BizTypeEnum getByValue(String value) {
        for (BizTypeEnum bizTypeEnum : BizTypeEnum.values()) {
            if (!bizTypeEnum.getValue().equals(value)) continue;
            return bizTypeEnum;
        }
        return null;
    }

    public static boolean isLoan(String value) {
        return BizTypeEnum.LOAN.value.equals(value);
    }

    public static boolean isEntrust(String value) {
        return BizTypeEnum.ENTRUST.value.equals(value);
    }

    public static boolean isSL(String value) {
        return BizTypeEnum.SL.value.equals(value);
    }

    public static boolean isEC(String value) {
        return BizTypeEnum.EC.value.equals(value);
    }

    public static boolean isBond(String value) {
        return BizTypeEnum.BOND.value.equals(value);
    }

    public static boolean isFinLease(String value) {
        return StringUtils.equals((CharSequence)BizTypeEnum.FINLEASE.value, (CharSequence)value);
    }
}

