/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.enums;

import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;

public enum DataSourceEnum {
    CFM("cfm"),
    BOND("bond"),
    INVEST("invest"),
    IFM("ifm"),
    CIM("cim"),
    FL("fl");

    private String value;

    private DataSourceEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static String getName(String value) {
        switch (value) {
            case "cfm": {
                return ResManager.loadKDString((String)"\u878d\u8d44\u7ba1\u7406", (String)"DataSourceEnum_0", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            case "bond": {
                return ResManager.loadKDString((String)"\u503a\u5238", (String)"DataSourceEnum_1", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            case "invest": {
                return ResManager.loadKDString((String)"\u6295\u8d44\u7ba1\u7406", (String)"DataSourceEnum_2", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            case "ifm": {
                return ResManager.loadKDString((String)"\u5185\u90e8\u91d1\u878d\u7ba1\u7406", (String)"DataSourceEnum_3", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            case "cim": {
                return ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22", (String)"DataSourceEnum_4", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            case "fl": {
                return ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"DataSourceEnum_5", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static boolean isCfm(String value) {
        return DataSourceEnum.CFM.value.equals(value);
    }

    public static boolean isBond(String value) {
        return DataSourceEnum.BOND.value.equals(value);
    }

    public static boolean isInvest(String value) {
        return DataSourceEnum.INVEST.value.equals(value);
    }

    public static boolean isIfm(String value) {
        return DataSourceEnum.IFM.value.equals(value);
    }

    public static boolean isCim(String value) {
        return DataSourceEnum.CIM.value.equals(value);
    }

    public static boolean isFl(String value) {
        return DataSourceEnum.FL.value.equals(value);
    }

    public static DataSourceEnum ofValue(String value) {
        return Arrays.stream(DataSourceEnum.values()).filter(e -> e.getValue().equals(value)).findFirst().orElse(null);
    }
}

