/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreintTypeEnum;
import kd.tmc.cfm.common.enums.SlBankRoleEnum;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BatchIntBillHelper {
    public static Pair<String, String> getLoanBillViewInfo(BatchIntViewInfoEnum batchIntViewInfoEnum) {
        Pair loanBillViewInfo = Pair.of((Object)"", (Object)ResManager.loadKDString((String)"\u63d0\u6b3e\u5355\u53f7", (String)"BatchIntBillHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
        switch (batchIntViewInfoEnum.getLoanBillFormId()) {
            case "cfm_loanbill_b_l": {
                loanBillViewInfo = Pair.of((Object)"loan,sl", (Object)ResManager.loadKDString((String)"\u63d0\u6b3e\u5355\u53f7", (String)"BatchIntBillHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "cfm_loanbill_e_l": {
                loanBillViewInfo = Pair.of((Object)"entrust,ec", (Object)ResManager.loadKDString((String)"\u63d0\u6b3e\u5355\u53f7", (String)"BatchIntBillHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "cim_invest_loanbill": {
                loanBillViewInfo = Pair.of((Object)"entrust,ec", (Object)ResManager.loadKDString((String)"\u653e\u6b3e\u5355\u53f7", (String)"BatchIntBillHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "ifm_loanbill": {
                loanBillViewInfo = Pair.of((Object)"", (Object)ResManager.loadKDString((String)"\u653e\u6b3e\u5355\u53f7", (String)"BatchIntBillHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "cfm_loanbill_bond": {
                loanBillViewInfo = Pair.of((Object)"bond", (Object)ResManager.loadKDString((String)"\u53d1\u884c\u7f16\u53f7", (String)"BatchIntBillHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "cim_deposit": {
                loanBillViewInfo = Pair.of((Object)"deposit", (Object)ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u53f7", (String)"BatchIntBillHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
        }
        return loanBillViewInfo;
    }

    public static Pair<String, String> getContractViewInfo(BatchIntViewInfoEnum batchIntViewInfoEnum) {
        Pair contractViewInfo = Pair.of((Object)"", (Object)ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u7f16\u53f7", (String)"BatchIntBillHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]));
        switch (batchIntViewInfoEnum.getContractFormId()) {
            case "cfm_loancontract_bl_l": {
                contractViewInfo = Pair.of((Object)"loan,sl", (Object)ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u7f16\u53f7", (String)"BatchIntBillHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "cfm_loancontract_ic_l": 
            case "cim_invest_contract": {
                contractViewInfo = Pair.of((Object)"entrust,ec", (Object)ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u7f16\u53f7", (String)"BatchIntBillHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "ifm_loancontractbill": {
                contractViewInfo = Pair.of((Object)"", (Object)ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u7f16\u53f7", (String)"BatchIntBillHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
            case "cfm_loancontract_bo": {
                contractViewInfo = Pair.of((Object)"bond", (Object)ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c\u8ba1\u5212", (String)"BatchIntBillHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]));
                break;
            }
        }
        return contractViewInfo;
    }

    public static String getDatasource(BatchIntViewInfoEnum batchIntViewInfoEnum) {
        if (batchIntViewInfoEnum == null) {
            return DataSourceEnum.CFM.getValue();
        }
        LoanTypeEnum loanTypeEnum = LoanTypeEnum.ofValue(batchIntViewInfoEnum.getLoanType());
        if (loanTypeEnum == null) {
            return DataSourceEnum.CFM.getValue();
        }
        switch (loanTypeEnum) {
            case BOND: {
                return DataSourceEnum.BOND.getValue();
            }
            case IFM: {
                return DataSourceEnum.IFM.getValue();
            }
            case LINKLEND: {
                return DataSourceEnum.INVEST.getValue();
            }
            case DEPOSIT: {
                if (batchIntViewInfoEnum.getEntityId().equals("ifm_depositprebatch")) {
                    return DataSourceEnum.IFM.getValue();
                }
                return DataSourceEnum.CIM.getValue();
            }
        }
        return DataSourceEnum.CFM.getValue();
    }

    public static String getAddNewNavFormId(BatchIntViewInfoEnum batchIntViewInfoEnum) {
        String entityId;
        switch (entityId = batchIntViewInfoEnum.getEntityId()) {
            case "ifm_intbill_batch_current": {
                return "ifm_navigate_addnew";
            }
            case "ifm_intbill_batch_loan": 
            case "cfm_intbill_batch_loan": {
                return "cfm_navigate_addnew";
            }
            case "cim_depositprebatch": {
                return "cim_pre_navigate_addnew";
            }
            case "ifm_depositprebatch": {
                return "ifm_depositprebatch_add";
            }
        }
        return "cfm_navigate_pre_addnew";
    }

    public static String getIntBillFormId(String formId) {
        switch (formId) {
            case "ifm_preintbill_batch_c": {
                return "ifm_currentintbill_p";
            }
            case "ifm_preintbill_batch_l": {
                return "ifm_preinterestbill";
            }
            case "cim_depositprebatch": {
                return "cim_depositpreint";
            }
            case "ifm_depositprebatch": {
                return "ifm_depositpreint";
            }
            case "cfm_intbill_batch_loan": {
                return "cfm_interestbill";
            }
            case "cfm_intbill_batch_pre": {
                return "cfm_preinterestbill";
            }
        }
        return BatchIntViewInfoEnum.getInfoEnumByFormId(formId).getIntBillFormId();
    }

    public static String genIntComment(DynamicObject loanBill, BatchIntViewInfoEnum batchIntViewInfo, Date bizDate, BigDecimal amount, DynamicObject payCurrency) {
        String loanBillName = "";
        String billno = "";
        if (StringUtils.equals((CharSequence)batchIntViewInfo.getEntityId(), (CharSequence)"ifm_intbill_batch_loan")) {
            loanBillName = (String)BatchIntBillHelper.getContractViewInfo(batchIntViewInfo).getRight();
            billno = loanBill.getDynamicObject("loancontractbill").getString("number");
        } else {
            loanBillName = (String)BatchIntBillHelper.getLoanBillViewInfo(batchIntViewInfo).getRight();
            billno = loanBill.getString("billno");
        }
        String intDirection = ResManager.loadKDString((String)"\u4ed8\u606f", (String)"BatchIntBillHelper_6", (String)"tmc-cfm-common", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"ec", (CharSequence)batchIntViewInfo.getLoanType())) {
            intDirection = ResManager.loadKDString((String)"\u6536\u606f", (String)"BatchIntBillHelper_7", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        String currency = loanBill.getDynamicObject("currency").getString("name");
        if (EmptyUtil.isNoEmpty((DynamicObject)payCurrency)) {
            currency = payCurrency.getString("name");
        }
        return String.format(ResManager.loadKDString((String)"%1$s%2$s\uff0c%3$s\uff0c%4$s%5$s%6$s\u3002", (String)"BatchIntBillHelper_8", (String)"tmc-cfm-common", (Object[])new Object[0]), loanBillName, billno, DateUtils.formatString((Date)bizDate, (String)"yyyyMMdd"), intDirection, currency, amount);
    }

    public static String genCommentTemplate(BatchIntViewInfoEnum batchIntViewInfo) {
        String operateType = batchIntViewInfo.getOperateType();
        if (StringUtils.equals((CharSequence)operateType, (CharSequence)"preint")) {
            return "";
        }
        String loanType = batchIntViewInfo.getLoanType();
        if (StringUtils.equals((CharSequence)loanType, (CharSequence)"ec")) {
            return ResManager.loadKDString((String)"\u653e\u6b3e\u5355\u53f7+\u3010\u653e\u6b3e\u5355\u53f7\u3011+\u3010\u6536\u606f\u65e5\u671f\u3011+\u6536\u606f+\u3010\u8d37\u6b3e\u5e01\u79cd\u3011+\u3010\u5b9e\u6536\u5229\u606f\u3011", (String)"BatchIntBillHelper_9", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)loanType, (CharSequence)"bond")) {
            return ResManager.loadKDString((String)"\u53d1\u884c\u7f16\u53f7+\u3010\u53d1\u884c\u7f16\u53f7\u3011+\u3010\u7ed3\u606f\u65e5\u671f\u3011+\u4ed8\u606f+\u3010\u53d1\u884c\u5e01\u79cd\u3011+\u3010\u5b9e\u4ed8\u5229\u606f\u3011", (String)"BatchIntBillHelper_10", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)loanType, (CharSequence)"ifm")) {
            return ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u53f7 +\u3010\u5408\u540c\u5355\u636e\u53f7\u3011+\u3010\u7ed3\u606f\u65e5\u671f\u3011+\u4ed8\u606f+\u3010\u501f\u6b3e\u5e01\u79cd\u3011+\u3010\u5b9e\u4ed8\u5229\u606f\u3011", (String)"BatchIntBillHelper_11", (String)"tmc-cfm-common", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u63d0\u6b3e\u5355\u53f7+\u3010\u63d0\u6b3e\u5355\u53f7\u3011+\u3010\u4ed8\u606f\u65e5\u671f\u3011+\u4ed8\u606f+\u3010\u501f\u6b3e\u5e01\u79cd\u3011+\u3010\u5b9e\u4ed8\u5229\u606f\u3011", (String)"BatchIntBillHelper_12", (String)"tmc-cfm-common", (Object[])new Object[0]);
    }

    public static Pair<String, String> getBatchIntBotpPair(String dataSource) {
        Pair batchIntBotpPair;
        DataSourceEnum dataSourceEnum = DataSourceEnum.ofValue(dataSource);
        if (null == dataSourceEnum) {
            return Pair.of((Object)"cfm_loanbill", (Object)"cfm_interestbill");
        }
        switch (dataSourceEnum) {
            case CFM: {
                batchIntBotpPair = Pair.of((Object)"cfm_loanbill", (Object)"cfm_interestbill");
                break;
            }
            case BOND: {
                batchIntBotpPair = Pair.of((Object)"cfm_loanbill_bond", (Object)"cfm_interestbill");
                break;
            }
            case INVEST: {
                batchIntBotpPair = Pair.of((Object)"cim_invest_loanbill", (Object)"cim_invest_interestbill");
                break;
            }
            case IFM: {
                batchIntBotpPair = Pair.of((Object)"ifm_loanbill", (Object)"ifm_interestbill");
                break;
            }
            default: {
                batchIntBotpPair = Pair.of((Object)"cfm_loanbill", (Object)"cfm_interestbill");
            }
        }
        return batchIntBotpPair;
    }

    public static Pair<String, String> getIntBotpPair(String loanType, String dataSource) {
        LoanTypeEnum loanTypeEnum = LoanTypeEnum.ofValue(loanType);
        if (loanTypeEnum == null) {
            return Pair.of((Object)"ifm_loanbill", (Object)"ifm_interestbill");
        }
        switch (loanTypeEnum) {
            case BOND: {
                return Pair.of((Object)"cfm_loanbill_bond", (Object)"cfm_interestbill");
            }
            case BANKLOAN: 
            case BANKSLOAN: {
                if (DataSourceEnum.isIfm(dataSource)) {
                    return Pair.of((Object)"ifm_loanbill", (Object)"ifm_interestbill");
                }
                return Pair.of((Object)"cfm_loanbill", (Object)"cfm_interestbill");
            }
            case LINKLEND: 
            case ENTRUSTLOAN: {
                if (DataSourceEnum.isCfm(dataSource)) {
                    return Pair.of((Object)"cfm_loanbill", (Object)"cfm_interestbill");
                }
                return Pair.of((Object)"cim_invest_loanbill", (Object)"cim_invest_interestbill");
            }
        }
        return Pair.of((Object)"ifm_loanbill", (Object)"ifm_interestbill");
    }

    public static Pair<String, String> getPreIntBotpPair(String loanType, String datasource) {
        LoanTypeEnum loanTypeEnum = LoanTypeEnum.ofValue(loanType);
        if (loanTypeEnum == null) {
            return Pair.of((Object)"ifm_loanbill", (Object)"ifm_preinterestbill");
        }
        switch (loanTypeEnum) {
            case BOND: {
                return Pair.of((Object)"cfm_loanbill_bond", (Object)"cfm_preinterestbill");
            }
            case BANKLOAN: 
            case BANKSLOAN: {
                if ("ifm".equals(datasource)) {
                    return Pair.of((Object)"ifm_loanbill", (Object)"ifm_preinterestbill");
                }
                return Pair.of((Object)"cfm_loanbill", (Object)"cfm_preinterestbill");
            }
            case LINKLEND: 
            case ENTRUSTLOAN: {
                if (DataSourceEnum.isCfm(datasource)) {
                    return Pair.of((Object)"cfm_loanbill", (Object)"cfm_preinterestbill");
                }
                return Pair.of((Object)"cim_invest_loanbill", (Object)"cim_preinterestbill");
            }
            case DEPOSIT: {
                if (DataSourceEnum.isIfm(datasource)) {
                    return Pair.of((Object)"cim_deposit", (Object)"ifm_depositpreint");
                }
                return Pair.of((Object)"cim_deposit", (Object)"cim_depositpreint");
            }
        }
        return Pair.of((Object)"ifm_loanbill", (Object)"ifm_preinterestbill");
    }

    public static String getMainOrgFeild(DynamicObject loanBill) {
        String mainOrgFeild = "org";
        String datasource = loanBill.getString("datasource");
        String creditorType = loanBill.getString("creditortype");
        if (StringUtil.equals((String)DataSourceEnum.INVEST.getValue(), (String)datasource) || StringUtil.equals((String)CreditorTypeEnum.INNERUNIT.getValue(), (String)creditorType)) {
            mainOrgFeild = "creditorg";
        }
        if (EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject(mainOrgFeild))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e\u6570\u636e\u6765\u6e90\u662f\u5426\u6b63\u786e\u3002", (String)"BatchIntBillHelper_13", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
        return mainOrgFeild;
    }

    public static boolean isDepostPreInt(String entityName) {
        return "cim_depositpreint".equals(entityName) || "ifm_depositpreint".equals(entityName);
    }

    public static boolean isDepostPreIntBatch(String entityName) {
        return "cim_depositprebatch".equals(entityName) || "ifm_depositprebatch".equals(entityName);
    }

    public static void loanSofrIntDetailInfo(DynamicObject entry, AbstractFormPlugin formPlugin, IDataModel dataModel) {
        formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"intentry"});
        formPlugin.getView().setVisible(Boolean.TRUE, new String[]{"sofrintentry"});
        Object currency = BatchIntBillHelper.getPreIntCurreny(entry, formPlugin);
        if (currency == null) {
            return;
        }
        String callIntStr = entry.getString("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillExtInfo intBillInfo = (IntBillExtInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillExtInfo.class);
        List details = intBillInfo.getExtDetails();
        details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailExtInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("sofrintstartdate", intDetail.getBeginDate());
            data.put("sofrintenddate", intDetail.getEndDate());
            data.put("sofrintentrydays", intDetail.getDays());
            data.put("sofrintprinciple", intDetail.getPrinciple());
            data.put("sofrintrate", intDetail.getBenchmarkRate());
            data.put("sofrintdate", intDetail.getBeginDate());
            data.put("sofrintcurrency", currency);
            data.put("sofrinterestamt", intDetail.getBenchmarkInt());
            data.put("sofrbasis", intDetail.getBasisDay());
            data.put("sofrintcategory", intDetail.getIntType().getValue());
            data.put("sofrfloatint", intDetail.getFloatInt());
            data.put("sofrfloatrate", intDetail.getFloatRate());
            data.put("sofrlasttotalint", intDetail.getLastTotalInt());
            data.put("sofrcurtotalint", intDetail.getCurTotalInt());
            Date beginConfirmDate = intDetail.getBeginConfirmDate();
            Date endConfirmDate = intDetail.getEndConfirmDate();
            if (beginConfirmDate != null && endConfirmDate != null) {
                intDetail.setObserveOffsetDay(1);
                int lookDays = intDetail.getConfirmDays();
                data.put("lookdays", lookDays);
            }
            data.put("confirmratedate", beginConfirmDate);
            data.put("sofrtotalint", intDetail.getTotalInt());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"sofrintentry", (AbstractFormDataModel)((AbstractFormDataModel)dataModel), dataMap);
        formPlugin.getView().updateView("sofrintentry");
    }

    public static void loanIntDetailInfo(DynamicObject entry, AbstractFormPlugin formPlugin, IDataModel dataModel) {
        DynamicObject loanInfo;
        IFormView view = formPlugin.getView();
        view.setVisible(Boolean.TRUE, new String[]{"intentry"});
        view.setVisible(Boolean.FALSE, new String[]{"sofrintentry"});
        BatchIntBillHelper.initIntTypeComb(formPlugin);
        Object currency = BatchIntBillHelper.getPreIntCurreny(entry, formPlugin);
        if (currency == null) {
            return;
        }
        String callIntStr = entry.getString("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        long loanBillId = entry.getLong("loanbillid");
        if (EmptyUtil.isNoEmpty((Long)loanBillId) && EmptyUtil.isNoEmpty((DynamicObject)(loanInfo = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id,interesttype,ratesign,ratefloatpoint", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)loanBillId)})))) {
            BatchIntBillHelper.docfmBiz(currency, callIntStr, loanInfo, view);
            return;
        }
        BatchIntBillHelper.doOtherBiz(currency, callIntStr, view);
    }

    private static void doOtherBiz(Object currency, String callIntStr, IFormView view) {
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        if (EmptyUtil.isEmpty((Object)intBillInfo)) {
            return;
        }
        List details = intBillInfo.getDetails();
        if (EmptyUtil.isEmpty((Collection)details)) {
            return;
        }
        details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("intstartdate", intDetail.getBeginDate());
            data.put("intenddate", intDetail.getEndDate());
            data.put("intentrydays", intDetail.getDays());
            data.put("intprinciple", intDetail.getPrinciple());
            data.put("intrate", intDetail.getRate());
            data.put("intdate", intDetail.getBeginDate());
            data.put("intcurrency", currency);
            data.put("entryinterestamt", intDetail.getAmount());
            data.put("basis", intDetail.getBasisDay());
            data.put("intcategory", intDetail.getIntType().getValue());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"intentry", (AbstractFormDataModel)((AbstractFormDataModel)view.getModel()), dataMap);
        view.updateView("intentry");
    }

    private static void docfmBiz(Object currency, String callIntStr, DynamicObject loanInfo, IFormView view) {
        String interestType = loanInfo.getString("interesttype");
        boolean isFloatRate = InterestTypeEnum.isFloat((String)interestType);
        String rateSign = loanInfo.getString("ratesign");
        BigDecimal rateFloatpoint = loanInfo.getBigDecimal("ratefloatpoint");
        IntBillExtInfo intBillInfo = (IntBillExtInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillExtInfo.class);
        List details = intBillInfo.getExtDetails();
        if (EmptyUtil.isEmpty((Collection)details)) {
            BatchIntBillHelper.doOtherBiz(currency, callIntStr, view);
        } else {
            details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
            ArrayList dataMap = new ArrayList(details.size());
            DataEntityPropertyCollection properties = FormParameterHelper.getDataEntityProperties(view.getModel(), "intentry");
            for (IntBillDetailExtInfo intDetail : details) {
                if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("intstartdate", intDetail.getBeginDate());
                data.put("intenddate", intDetail.getEndDate());
                data.put("intentrydays", intDetail.getDays());
                data.put("intprinciple", intDetail.getPrinciple());
                data.put("intrate", intDetail.getRate());
                data.put("intdate", intDetail.getBeginDate());
                data.put("intcurrency", currency);
                if (properties != null && properties.containsKey((Object)"floatrate") && properties.containsKey((Object)"floatint")) {
                    BigDecimal totalRate = intDetail.getRate();
                    BigDecimal totalInt = intDetail.getTotalInt();
                    totalInt = EmptyUtil.isEmpty((BigDecimal)totalInt) ? intDetail.getAmount() : totalInt;
                    BigDecimal resPointRate = InterestCalcHelper.getPointRate(isFloatRate, rateSign, rateFloatpoint, intDetail.getFloatRate());
                    data.put("floatrate", resPointRate);
                    data.put("benchmarkrate", totalRate.subtract(resPointRate));
                    BigDecimal resPointInt = InterestCalcHelper.getPointInt(totalRate, totalInt, resPointRate);
                    data.put("floatint", resPointInt);
                    data.put("benchmarkint", totalInt.subtract(resPointInt));
                }
                data.put("entryinterestamt", intDetail.getAmount());
                data.put("basis", intDetail.getBasisDay());
                data.put("intcategory", intDetail.getIntType().getValue());
                dataMap.add(data);
            }
            TmcViewInputHelper.batchFillEntity((String)"intentry", (AbstractFormDataModel)((AbstractFormDataModel)view.getModel()), dataMap);
            view.updateView("intentry");
        }
    }

    private static void initIntTypeComb(AbstractFormPlugin formPlugin) {
        boolean isCurrentPre;
        ComboEdit categoryComb = (ComboEdit)formPlugin.getControl("intcategory");
        IFormView parentView = formPlugin.getView().getViewNoPlugin(formPlugin.getView().getFormShowParameter().getParentPageId());
        if (EmptyUtil.isEmpty((Object)parentView)) {
            return;
        }
        IDataModel pModel = parentView.getModel();
        if (EmptyUtil.isEmpty((Object)pModel)) {
            return;
        }
        Object currentIntType = formPlugin.getView().getFormShowParameter().getCustomParams().get("currentinttype");
        String pModelName = pModel.getDataEntityType().getName();
        boolean isCurrentInt = EmptyUtil.isNoEmpty(currentIntType) || pModelName.equals("ifm_intbill_batch_current");
        boolean bl = isCurrentPre = pModelName.equals("ifm_intbill_batch_pre") && PreintTypeEnum.CURRENTINT.getValue().equals(pModel.getValue("interesttype"));
        if (!isCurrentInt && !isCurrentPre) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38\u5229\u606f", (String)"BatchIntBillHelper_14", (String)"tmc-cfm-common", (Object[])new Object[0])), "normal"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u903e\u671f\u5229\u606f", (String)"BatchIntBillHelper_15", (String)"tmc-cfm-common", (Object[])new Object[0])), "overdue"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5c55\u671f\u5229\u606f", (String)"BatchIntBillHelper_16", (String)"tmc-cfm-common", (Object[])new Object[0])), "extend"));
            categoryComb.setComboItems(comboItems);
        }
    }

    private static Object getPreIntCurreny(DynamicObject entry, AbstractFormPlugin formPlugin) {
        String parrentEntityId = formPlugin.getView().getEntityId();
        if ("cfm_intbill_batch_loan".equals(parrentEntityId)) {
            return entry.getDynamicObject("loancurrency").getPkValue();
        }
        DynamicObject currency = entry.getDynamicObject("currency");
        return EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getPkValue() : null;
    }

    public static void setSlBankEntryAmount(List<DynamicObject> slBankEntrys, BigDecimal amount, String slField, DynamicObject currency, boolean isSameCurrency) {
        int amtPrecision = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 2;
        BigDecimal totalAmount = slBankEntrys.stream().map(o -> o.getBigDecimal("s_loanamount")).reduce(BigDecimal::add).orElse(BigDecimal.ONE);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject slBankEntry : slBankEntrys) {
            BigDecimal intAmount = slBankEntry.getBigDecimal("s_loanamount").multiply(amount).divide(totalAmount, amtPrecision, RoundingMode.HALF_UP);
            sumAmount = sumAmount.add(intAmount);
            slBankEntry.set(slField, (Object)intAmount);
            if (isSameCurrency && "s_repayinst".equals(slField)) {
                slBankEntry.set("s_convertintamt", (Object)intAmount);
            }
            if (!"s_convertintamt".equals(slField) || !slBankEntry.getDataEntityType().getProperties().containsKey((Object)"s_instcurrency")) continue;
            slBankEntry.set("s_instcurrency", (Object)currency);
        }
        DynamicObject mbEntry = slBankEntrys.stream().filter(o -> SlBankRoleEnum.MB.getValue().equals(o.getString("s_bankrole"))).findFirst().orElse(null);
        BigDecimal subAmount = amount.subtract(sumAmount);
        if (subAmount.compareTo(BigDecimal.ZERO) != 0 && EmptyUtil.isNoEmpty((DynamicObject)mbEntry)) {
            BigDecimal repayInst = mbEntry.getBigDecimal(slField).add(subAmount);
            repayInst = repayInst.compareTo(BigDecimal.ZERO) > 0 ? repayInst : BigDecimal.ZERO;
            mbEntry.set(slField, (Object)repayInst);
            if (isSameCurrency && "s_repayinst".equals(slField)) {
                mbEntry.set("s_convertintamt", (Object)repayInst);
            }
        }
    }
}

