/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.helper.TreeSelectHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class BondLimitHelper {
    public static void changeLimitOnSave(DynamicObject dataEntity, Object limitpkValue, BigDecimal drawAmount) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)limitpkValue);
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        Optional<DynamicObject> firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == ((Long)dataEntity.getPkValue()).longValue()).findFirst();
        if (!firstEntryOptional.isPresent()) {
            BondLimitHelper.deleteOldOccupyLimit(dataEntity, limitpkValue);
            DynamicObject newEntry = entry.addNew();
            newEntry.set("limitbilltype", (Object)dataEntity.getDataEntityType().getExtendName());
            newEntry.set("limitbillid", dataEntity.getPkValue());
            newEntry.set("limitbillno", dataEntity.get("billno"));
            newEntry.set("limitorg", dataEntity.get("org"));
            newEntry.set("limitstartdate", dataEntity.get("bizdate"));
            newEntry.set("limitenddate", dataEntity.get("expiredate"));
            newEntry.set("limitcurrency", dataEntity.get("currency"));
            newEntry.set("limitadvanceamt", (Object)drawAmount);
            newEntry.set("limitactualoccupyamt", (Object)drawAmount);
        } else {
            BondLimitHelper.deleteOldOccupyLimit(dataEntity, limitpkValue);
            DynamicObject firstEntry = firstEntryOptional.get();
            firstEntry.set("limitadvanceamt", (Object)drawAmount);
            firstEntry.set("limitactualoccupyamt", (Object)drawAmount);
            firstEntry.set("limitstartdate", dataEntity.get("bizdate"));
            firstEntry.set("limitenddate", dataEntity.get("expiredate"));
            firstEntry.set("limitcurrency", dataEntity.get("currency"));
            firstEntry.set("limitorg", dataEntity.get("org"));
        }
        BondLimitHelper.sumLimit(limit);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
    }

    public static void changeLimitOnInitSave(DynamicObject dataEntity, Object limitpkValue, BigDecimal drawAmount, BigDecimal repayamount) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)limitpkValue);
        String limittype = limit.getString("limittype");
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        Optional<DynamicObject> firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == ((Long)dataEntity.getPkValue()).longValue()).findFirst();
        if (!firstEntryOptional.isPresent()) {
            BondLimitHelper.deleteOldOccupyLimit(dataEntity, limitpkValue);
            DynamicObject newEntry = entry.addNew();
            newEntry.set("limitbilltype", (Object)dataEntity.getDataEntityType().getExtendName());
            newEntry.set("limitbillid", dataEntity.getPkValue());
            newEntry.set("limitbillno", dataEntity.get("billno"));
            newEntry.set("limitorg", dataEntity.get("org"));
            newEntry.set("limitstartdate", dataEntity.get("bizdate"));
            newEntry.set("limitenddate", dataEntity.get("expiredate"));
            newEntry.set("limitcurrency", dataEntity.get("currency"));
            newEntry.set("limitusedamt", (Object)drawAmount);
            if ("loop".equals(limittype)) {
                newEntry.set("limitreleasedamt", (Object)repayamount);
                newEntry.set("limitactualoccupyamt", (Object)drawAmount.subtract(repayamount));
            } else {
                newEntry.set("limitactualoccupyamt", (Object)drawAmount);
            }
        } else {
            BondLimitHelper.deleteOldOccupyLimit(dataEntity, limitpkValue);
        }
        BondLimitHelper.sumLimit(limit);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
    }

    public static void deleteOldOccupyLimit(DynamicObject dataEntity, Object limitId) {
        DynamicObject limit = TmcDataServiceHelper.loadSingle((String)"bdim_bond_limit", (String)"id,totalamt,advanceamt,usedamt,availamt,limittype,entry.limitbilltype,entry.limitbillno,entry.limitbillid,entry.limitorg,entry.limitstartdate,entry.limitenddate,entry.limitadvanceamt,entry.limitreleasedamt,entry.limitusedamt,entry.limitactualoccupyamt,entry.limitcurrency", (QFilter[])new QFilter[]{new QFilter("entry.limitbillid", "=", dataEntity.getPkValue())});
        if (limit == null) {
            return;
        }
        if (ObjectUtils.notEqual((Object)limitId, (Object)limit.get("id"))) {
            DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
            entry.removeIf(e -> e.getLong("limitbillid") == dataEntity.getLong("id"));
            BondLimitHelper.sumLimit(limit);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
        }
    }

    public static void changeLimitOnSubmit(DynamicObject dataEntity, Object pkValue, BigDecimal drawAmount) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)pkValue);
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        Optional<DynamicObject> firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == dataEntity.getLong("id")).findFirst();
        if (!firstEntryOptional.isPresent()) {
            BondLimitHelper.deleteOldOccupyLimit(dataEntity, pkValue);
            DynamicObject newEntry = entry.addNew();
            newEntry.set("limitbilltype", (Object)dataEntity.getDataEntityType().getExtendName());
            newEntry.set("limitbillno", dataEntity.get("billno"));
            newEntry.set("limitbillid", dataEntity.getPkValue());
            newEntry.set("limitorg", dataEntity.get("org"));
            newEntry.set("limitstartdate", dataEntity.get("bizdate"));
            newEntry.set("limitenddate", dataEntity.get("expiredate"));
            newEntry.set("limitcurrency", dataEntity.get("currency"));
            newEntry.set("limitusedamt", (Object)drawAmount);
            newEntry.set("limitactualoccupyamt", (Object)drawAmount);
        } else {
            DynamicObject limitentry = firstEntryOptional.get();
            limitentry.set("limitusedamt", (Object)drawAmount);
            limitentry.set("limitadvanceamt", (Object)BigDecimal.ZERO);
            limitentry.set("limitactualoccupyamt", (Object)drawAmount);
            limitentry.set("limitstartdate", dataEntity.get("bizdate"));
            limitentry.set("limitenddate", dataEntity.get("expiredate"));
            limitentry.set("limitcurrency", dataEntity.get("currency"));
            limitentry.set("limitorg", dataEntity.get("org"));
        }
        BondLimitHelper.sumLimit(limit);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
    }

    public static void changeLimitOnUnsubmitOrUnAudit(DynamicObject dataEntity, Object pkValue, BigDecimal drawAmount) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)pkValue);
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        Optional<DynamicObject> firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == dataEntity.getLong("id")).findFirst();
        if (firstEntryOptional.isPresent()) {
            DynamicObject limitentry = firstEntryOptional.get();
            limitentry.set("limitusedamt", (Object)limitentry.getBigDecimal("limitusedamt").subtract(drawAmount));
            limitentry.set("limitadvanceamt", (Object)limitentry.getBigDecimal("limitadvanceamt").add(drawAmount));
            BondLimitHelper.sumLimit(limit);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
        }
    }

    public static void changeLimitOnDelete(DynamicObject dataEntity, Object pkValue) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)pkValue);
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        entry.removeIf(e -> e.getLong("limitbillid") == ((Long)dataEntity.getPkValue()).longValue());
        BondLimitHelper.sumLimit(limit);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
    }

    public static void changeLimitOnRepaymentAudit(DynamicObject dataEntity, Object pkValue, BigDecimal repayamount) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)pkValue);
        String limittype = limit.getString("limittype");
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        Optional<DynamicObject> firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == dataEntity.getLong("id")).findFirst();
        if (firstEntryOptional.isPresent()) {
            DynamicObject firstEntry = firstEntryOptional.get();
            if ("loop".equals(limittype)) {
                BigDecimal limitreleasedamt = firstEntry.getBigDecimal("limitreleasedamt").add(repayamount);
                firstEntry.set("limitreleasedamt", (Object)limitreleasedamt);
                BigDecimal limitactualoccupyamt = firstEntry.getBigDecimal("limitusedamt").add(firstEntry.getBigDecimal("limitadvanceamt").subtract(limitreleasedamt));
                firstEntry.set("limitactualoccupyamt", (Object)limitactualoccupyamt);
                BondLimitHelper.sumLimit(limit);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
            }
        }
    }

    public static void changeLimitOnRepaymentUnAudit(DynamicObject dataEntity, Object pkValue, BigDecimal repayamount) {
        DynamicObject limit = BondLimitHelper.getLimit((Long)pkValue);
        String limittype = limit.getString("limittype");
        DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
        Optional<DynamicObject> firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == dataEntity.getLong("id")).findFirst();
        if (firstEntryOptional.isPresent()) {
            DynamicObject firstEntry = firstEntryOptional.get();
            if ("loop".equals(limittype)) {
                BigDecimal limitreleasedamt = firstEntry.getBigDecimal("limitreleasedamt").subtract(repayamount);
                firstEntry.set("limitreleasedamt", (Object)limitreleasedamt);
                BigDecimal limitactualoccupyamt = firstEntry.getBigDecimal("limitusedamt").add(firstEntry.getBigDecimal("limitadvanceamt").add(limitreleasedamt));
                firstEntry.set("limitactualoccupyamt", (Object)limitactualoccupyamt);
                BondLimitHelper.sumLimit(limit);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
            }
        }
    }

    public static void changeLimitOnInitBillBondReverseInit(DynamicObject loanDelBill) {
        DynamicObject occupybondlimit = loanDelBill.getDynamicObject("occupybondlimit");
        if (occupybondlimit != null) {
            DynamicObject limit = BondLimitHelper.getLimit(occupybondlimit.getLong("id"));
            DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
            entry.removeIf(e -> e.getLong("limitbillid") == loanDelBill.getLong("id"));
            BondLimitHelper.sumLimit(limit);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{limit});
        }
    }

    public static DynamicObject getLimit(Long pkValue) {
        return TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"bdim_bond_limit", (String)"number,totalamt,advanceamt,usedamt,availamt,limittype,entry.limitbilltype,entry.limitbillno,entry.limitbillid,entry.limitorg,entry.limitstartdate,entry.limitenddate,entry.limitadvanceamt,entry.limitreleasedamt,entry.limitusedamt,entry.limitactualoccupyamt,entry.limitcurrency");
    }

    private static void sumLimit(DynamicObject limit) {
        DynamicObjectCollection entrys = limit.getDynamicObjectCollection("entry");
        String limittype = limit.getString("limittype");
        BigDecimal totalamt = limit.getBigDecimal("totalamt");
        BigDecimal usedamt = BigDecimal.ZERO;
        BigDecimal advanceamt = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            BigDecimal limitusedamt = entry.getBigDecimal("limitusedamt");
            BigDecimal limitadvanceamt = entry.getBigDecimal("limitadvanceamt");
            BigDecimal limitreleasedamt = entry.getBigDecimal("limitreleasedamt");
            advanceamt = advanceamt.add(limitadvanceamt);
            if ("loop".equals(limittype)) {
                usedamt = usedamt.add(limitusedamt).subtract(limitreleasedamt);
                continue;
            }
            usedamt = usedamt.add(limitusedamt);
        }
        limit.set("usedamt", (Object)usedamt);
        limit.set("advanceamt", (Object)advanceamt);
        limit.set("availamt", (Object)totalamt.subtract(usedamt).subtract(advanceamt));
    }

    public static QFilter getBondlimitFilter(Long orgId, Long currencyId, Long finproductId, Date bizDate) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("currency", "=", (Object)currencyId));
        ArrayList<Long> ids = new ArrayList<Long>(10);
        TreeSelectHelper.getTreeNodeIds("cfm_financingvarieties", finproductId, ids);
        filter.and(new QFilter("finproducts.fbasedataid.id", "in", ids).or(new QFilter("finproducts.fbasedataid.id", "=", (Object)0))).and(new QFilter("effectdate", "<=", (Object)bizDate).and(new QFilter("expirydate", ">=", (Object)bizDate)));
        return filter;
    }
}

