/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.IListView;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CfmBillCommonHelper {
    private static Log logger = LogFactory.getLog(CfmBillCommonHelper.class);
    private static final Map<String, String> bizBillPushRelationMap = new HashMap<String, String>(16);
    private static final Map<String, Pair<String, String>> loanRePayInstPlanMap;

    public static void setNeedPayAmt(DynamicObject dataEntity) {
        CfmBillCommonHelper.setNeedPayAmt(dataEntity, false);
    }

    public static void setNeedPayAmt(DynamicObject dataEntity, boolean isPayInt) {
        if (!dataEntity.getBoolean("isrelcash")) {
            dataEntity.set("needpayamt", (Object)BigDecimal.ZERO);
        } else if (isPayInt || !dataEntity.getDataEntityState().getFromDatabase() || BillStatusEnum.isSave((String)dataEntity.getString("billstatus")) || BillStatusEnum.isSubmit((String)dataEntity.getString("billstatus"))) {
            dataEntity.set("needpayamt", (Object)CfmBillCommonHelper.getNeedPayAmt(dataEntity));
        }
    }

    public static BigDecimal getNeedPayAmt(DynamicObject dataEntity) {
        BigDecimal repayAmt = dataEntity.getBigDecimal("amount");
        DynamicObjectCollection loans = dataEntity.getDynamicObjectCollection("loans");
        BigDecimal intAmt = loans.stream().filter(o -> o.getBoolean("e_ispayinst") && o.getBoolean("e_combineinst")).map(o -> o.getBigDecimal("e_actintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return repayAmt.add(intAmt).subtract(CfmBillCommonHelper.getSuretyRepayAmt(dataEntity));
    }

    private static BigDecimal getSuretyRepayAmt(DynamicObject dataEntity) {
        BigDecimal suretyRepayAmt = BigDecimal.ZERO;
        DynamicObjectCollection suretyEntries = dataEntity.getDynamicObjectCollection("entry_surety");
        if (dataEntity.getBoolean("issuretyrepay") && EmptyUtil.isNoEmpty((DynamicObjectCollection)suretyEntries)) {
            suretyRepayAmt = ((DynamicObject)suretyEntries.get(0)).getBigDecimal("suretyrepayamt");
        }
        return suretyRepayAmt;
    }

    public static int getWorkDayCount(Long[] wcIds, Date startDate, Date endDate) {
        Map workDateMap = WorkCalendarHelper.getDateTypeMap((Long[])wcIds, (Date)startDate, (Date)endDate);
        if (workDateMap.isEmpty()) {
            return 0;
        }
        TreeMap dateBooleanTreeMap = new TreeMap(workDateMap);
        return (int)dateBooleanTreeMap.subMap(startDate, endDate).values().stream().filter(v -> v).count();
    }

    public static Integer getSofrDiffDays(DynamicObject loanbill) {
        int diffDays = 0;
        Date actStartIntDate = loanbill.getDate("startintdate");
        Date rateAdjustDate = loanbill.getDate("rateadjustdate");
        DynamicObjectCollection workCalendar = loanbill.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)workCalendar) && EmptyUtil.isNoEmpty((Object)actStartIntDate) && EmptyUtil.isNoEmpty((Object)rateAdjustDate)) {
            Long[] wcIds = workCalendar.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
            if (actStartIntDate.compareTo(rateAdjustDate) >= 0) {
                diffDays = CfmBillCommonHelper.getWorkDayCount(wcIds, rateAdjustDate, actStartIntDate);
            }
        }
        return diffDays;
    }

    public static Date getLastDayByWorkCalendar(DynamicObjectCollection workCalendars, int diffDays, Date bizDate, int dataRange) {
        if (workCalendars == null || workCalendars.size() == 0) {
            return DateUtils.getLastDay((Date)bizDate, (int)diffDays);
        }
        if (diffDays == 0) {
            return bizDate;
        }
        Long[] wcIds = workCalendars.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
        Map workCalendarMap = WorkCalendarHelper.getDateTypeMap((Long[])wcIds, (Date)DateUtils.getLastMonth((Date)bizDate, (int)dataRange), (Date)DateUtils.getNextMonth((Date)bizDate, (int)dataRange));
        int resetDays = diffDays;
        while (resetDays > 0) {
            if (!TermHelper.isWorkDay((Map)workCalendarMap, (Date)(bizDate = DateUtils.getLastDay((Date)bizDate, (int)1)))) continue;
            --resetDays;
        }
        return bizDate;
    }

    public static void constomSaveOp(DynamicObject bill) {
        CfmBillCommonHelper.checkAmountMaxValue(bill);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private static void checkAmountMaxValue(DynamicObject bill) {
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
            throw new KDBizException(new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
        }
    }

    public static String getRePayInstPlanView(IFormView view, boolean isRepay) {
        String billFormId = CfmBillCommonHelper.getFormIdByShowParameter(view);
        if (isRepay) {
            return (String)loanRePayInstPlanMap.get(billFormId).getLeft();
        }
        return (String)loanRePayInstPlanMap.get(billFormId).getRight();
    }

    public static QFilter getIntPlanFilter() {
        List<String> noOpPlanWays = Arrays.asList(RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue());
        QFilter qFilter = new QFilter("repaymentway", "not in", noOpPlanWays);
        QFilter zoreRateQFilter = new QFilter("interesttype", "=", (Object)InterestTypeEnum.FLOAT).or(new QFilter("loanrate", ">", (Object)0).and(new QFilter("interesttype", "!=", (Object)InterestTypeEnum.FLOAT)));
        qFilter.and(zoreRateQFilter);
        QFilter productQfilter = new QFilter("productfactory", "=", (Object)0).or(new QFilter("productfactory", ">", (Object)0).and(new QFilter("productfactory.iscallint", "=", (Object)"1")));
        qFilter.and(productQfilter);
        return qFilter;
    }

    public static LocaleString getDisPlayPropName(IDataModel model, String prop) {
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        return ((IDataEntityProperty)properties.get((Object)prop)).getDisplayName();
    }

    public static DynamicObject getInternalOrg(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        return (basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity, (String)"internal_company")) == null ? null : basedata.getDynamicObject("internal_company");
    }

    public static void setNeedSaveFieldValue(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject org;
            if (DataSourceEnum.INVEST.getValue().equals(dataEntity.getString("datasource"))) {
                dataEntity.set("registorg", (Object)dataEntity.getDynamicObject("creditorg"));
                org = dataEntity.getDynamicObject("creditorg");
                dataEntity.set("creditortype", (Object)CreditorTypeEnum.INNERUNIT.getValue());
                dataEntity.set("creditor", (Object)org.getLong("id"));
                dataEntity.set("textcreditor", (Object)org.getString("name"));
                String debtorType = dataEntity.getString("debtortype");
                if (!CreditorTypeEnum.INNERUNIT.getValue().equals(debtorType)) continue;
                Long debtorId = dataEntity.getLong("debtor");
                DynamicObject detorOrg = null;
                if (EmptyUtil.isNoEmpty((Long)debtorId)) {
                    detorOrg = TmcDataServiceHelper.loadSingleFromCache((Object)debtorId, (String)"bos_org");
                }
                if (!EmptyUtil.isNoEmpty(detorOrg)) continue;
                dataEntity.set("org", (Object)detorOrg);
                continue;
            }
            dataEntity.set("registorg", (Object)dataEntity.getDynamicObject("org"));
            org = dataEntity.getDynamicObject("org");
            dataEntity.set("debtortype", (Object)CreditorTypeEnum.INNERUNIT.getValue());
            if (EmptyUtil.isEmpty((DynamicObject)org)) break;
            dataEntity.set("debtor", (Object)org.getLong("id"));
            dataEntity.set("textdebtor", (Object)org.getString("name"));
            String creditorType = dataEntity.getString("creditortype");
            if (!CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType)) continue;
            Long creditorId = dataEntity.getLong("creditor");
            DynamicObject creditorOrg = null;
            if (EmptyUtil.isNoEmpty((Long)creditorId)) {
                creditorOrg = TmcDataServiceHelper.loadSingleFromCache((Object)creditorId, (String)"bos_org");
            }
            if (!EmptyUtil.isNoEmpty(creditorOrg)) continue;
            dataEntity.set("creditorg", (Object)creditorOrg);
        }
    }

    public static void setLenderNature(DynamicObject dataEntity) {
        String type = dataEntity.getString("creditortype");
        Long creditorId = dataEntity.getLong("creditor");
        if (DataSourceEnum.INVEST.getValue().equals(dataEntity.getString("datasource"))) {
            type = dataEntity.getString("debtortype");
            creditorId = dataEntity.getLong("debtor");
        }
        String loanType = dataEntity.getString("loantype");
        String lenderNature = LenderNatureEnum.OUTGROUP.getValue();
        switch (type) {
            case "innerunit": 
            case "settlecenter": {
                lenderNature = LenderNatureEnum.INGROUP.getValue();
                break;
            }
            case "bank": {
                if (LoanTypeEnum.isBankLoan(loanType)) {
                    lenderNature = LenderNatureEnum.OUTGROUP.getValue();
                    break;
                }
                if (!LoanTypeEnum.isBanksLoan(loanType)) break;
                lenderNature = CfmBillCommonHelper.getLenderNatureByBanksLoan(dataEntity);
                break;
            }
            case "finorg": {
                lenderNature = CfmBillCommonHelper.getLenderNature(creditorId, "bd_finorginfo", "org");
                if (!LoanTypeEnum.isBanksLoan(loanType)) break;
                lenderNature = CfmBillCommonHelper.getLenderNatureByBanksLoan(dataEntity);
                break;
            }
            case "custom": {
                lenderNature = CfmBillCommonHelper.getLenderNature(creditorId, "bd_bizpartner", "internal_company");
                break;
            }
            case "other": {
                lenderNature = LenderNatureEnum.OUTGROUP.getValue();
                break;
            }
        }
        dataEntity.set("lendernature", (Object)lenderNature);
    }

    private static String getLenderNatureByBanksLoan(DynamicObject dataEntity) {
        String lenderNature = LenderNatureEnum.OUTGROUP.getValue();
        DynamicObjectCollection bankCateEntrys = dataEntity.getDynamicObjectCollection("banksyndicate_entry");
        for (DynamicObject bankCateEntry : bankCateEntrys) {
            DynamicObject bank = bankCateEntry.getDynamicObject("e_bank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)bank)) continue;
            lenderNature = CfmBillCommonHelper.getLenderNature(bank.getLong("id"), "bd_finorginfo", "org");
            if (!LenderNatureEnum.OUTGROUP.getValue().equals(lenderNature)) continue;
            return lenderNature;
        }
        return lenderNature;
    }

    private static String getLenderNature(Long creditorId, String entity, String proName) {
        DynamicObject finorg = QueryServiceHelper.queryOne((String)entity, (String)proName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)creditorId)});
        if (EmptyUtil.isEmpty((DynamicObject)finorg)) {
            return LenderNatureEnum.OUTGROUP.getValue();
        }
        return EmptyUtil.isEmpty((Object)finorg.get(proName)) ? LenderNatureEnum.OUTGROUP.getValue() : LenderNatureEnum.INGROUP.getValue();
    }

    public static void dealNoTermInfo(List<ExtendedDataEntity> bizBills) {
        for (ExtendedDataEntity bizBill : bizBills) {
            Date startDate;
            DynamicObject dataEntity = bizBill.getDataEntity();
            if (!dataEntity.getBoolean("isnofixedterm") || !BillStatusEnum.isSave((String)dataEntity.getString("billstatus")) || !EmptyUtil.isNoEmpty((Object)(startDate = dataEntity.getDate("startintdate")))) continue;
            dataEntity.set("term", (Object)"1y");
            dataEntity.set("expiredate", (Object)DateUtils.getNextYear((Date)startDate, (int)1));
        }
    }

    public static void dealFloatRateVal(DynamicObject contractBill) {
        if (EmptyUtil.isEmpty((BigDecimal)contractBill.getBigDecimal("interestrate"))) {
            Map rateDatas;
            Date startdate = contractBill.getDate("startdate");
            DynamicObject refindex = contractBill.getDynamicObject("referencerate");
            if (EmptyUtil.isNoEmpty((DynamicObject)refindex) && EmptyUtil.isNoEmpty((Object)startdate) && EmptyUtil.isNoEmpty((Object)(rateDatas = MarketDataServiceHelper.referRate((String)refindex.getString("number"), (Date)startdate, (Date)startdate))) && rateDatas.size() > 0) {
                Optional firstRate;
                String rateSign = contractBill.getString("ratesign");
                BigDecimal rateFloatPoint = contractBill.getBigDecimal("ratefloatpoint");
                BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 20, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
                if ((firstRate = rateDatas.values().stream().findFirst()).isPresent()) {
                    contractBill.set("interestrate", (Object)((BigDecimal)firstRate.get()).add(rateFloat));
                }
            }
        }
    }

    public static String getInterestEntity(String entity) {
        switch (entity) {
            case "cim_invest_repaybill": {
                return "cim_invest_interestbill";
            }
            case "cfm_repaymentbill_bond": {
                return "cfm_interestbill_bond";
            }
            case "ifm_repaymentbill": {
                return "ifm_interestbill";
            }
        }
        return "cfm_interestbill";
    }

    public static String getRepaymentBillEntityByIntBill(String entity) {
        switch (entity) {
            case "cim_invest_interestbill": {
                return "cim_invest_repaybill";
            }
            case "cfm_interestbill_bond": {
                return "cfm_repaymentbill_bond";
            }
            case "ifm_interestbill": {
                return "ifm_repaymentbill";
            }
        }
        return "cfm_repaymentbill";
    }

    public static String getOppEntityBill(String entity) {
        switch (entity) {
            case "cfm_loanbill": {
                return "cim_invest_loanbill";
            }
            case "cim_invest_loanbill": {
                return "cfm_loanbill";
            }
            case "cfm_repaymentbill": {
                return "cim_invest_repaybill";
            }
            case "cim_invest_repaybill": {
                return "cfm_repaymentbill";
            }
            case "cfm_interestbill": {
                return "cim_invest_interestbill";
            }
            case "cim_invest_interestbill": {
                return "cfm_interestbill";
            }
        }
        return null;
    }

    public static void setVisibleWhenBotpTrance(IFormView view, String billStatus) {
        String parentFormId = view.getFormShowParameter().getParentFormId();
        if (StringUtils.isNotBlank((CharSequence)parentFormId) && ("botp_lookupTracker".equalsIgnoreCase(parentFormId) || "botp_lookdownTracker".equalsIgnoreCase(parentFormId))) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit"});
            if (BillStatusEnum.isAudit((String)billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_save", "bar_unsubmit", "bar_audit"});
            }
            if (BillStatusEnum.isSubmit((String)billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unaudit", "bar_save"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"bar_cancelconfirm", "bar_modify", "bar_more", "bar_repaymentsc", "bar_updateinstplan"});
        }
    }

    public static String getFormIdByShowParameter(IFormView view) {
        String billFormId = view.getFormShowParameter().getFormId();
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            billFormId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        }
        return billFormId;
    }

    public static void setRepayIntPlanBotnVisable(IFormView view) {
        String billFormId = CfmBillCommonHelper.getFormIdByShowParameter(view);
        if (billFormId.endsWith("_intplan") || "cfm_loadbill_view".equals(billFormId) || billFormId.endsWith("_plan") || "cfm_loanbill_bond_p".equals(billFormId) || billFormId.endsWith("_loanbill_layout")) {
            if (view.getFormShowParameter() instanceof ListShowParameter) {
                view.setVisible(Boolean.FALSE, new String[]{"tblrepaymentsc", "tblupdateinstplan"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"bar_updateinstplan", "bar_repaymentsc"});
            }
        }
    }

    public static void setSignMustInput(IFormView view, Boolean isMust, String ... key) {
        for (String sign : key) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(sign);
            fieldEdit.setMustInput(isMust.booleanValue());
        }
    }

    public static boolean pushOpConfirmStatusValid(DynamicObject bizBill) {
        String confirmStatus = bizBill.getString("confirmstatus");
        return StringUtils.equals((CharSequence)confirmStatus, (CharSequence)ConfirmStatusEnum.YETCONFIRM.getValue());
    }

    public static void checkLinkPush2TarBill(BeforeDoOperationEventArgs args, IFormView view, String entityId) {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource("");
        Object selectPkId = null;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            IListView listview = (IListView)view;
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (EmptyUtil.isNoEmpty((Object)selectedRows)) {
                if (selectedRows.getPrimaryKeyValues().length > 1) {
                    view.showErrorNotification(bizResource.getLbBatcherror());
                    args.setCancel(true);
                } else {
                    selectPkId = selectedRows.getPrimaryKeyValues()[0];
                }
            }
        } else {
            DynamicObject dataEntity = view.getModel().getDataEntity();
            selectPkId = dataEntity.getPkValue();
        }
        if (!EmptyUtil.isEmpty((Object)selectPkId)) {
            DynamicObject bizBillDO = QueryServiceHelper.queryOne((String)entityId, (String)"billstatus,confirmstatus", (QFilter[])new QFilter("id", "=", selectPkId).toArray());
            String billstatus = bizBillDO.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus) || !CfmBillCommonHelper.pushOpConfirmStatusValid(bizBillDO)) {
                view.showTipNotification(String.format(bizResource.getRecBillStatusConfirmStatusError(), CfmEntityEnum.getName(entityId), bizBillPushRelationMap.get(entityId)));
                args.setCancel(true);
            }
        }
    }

    public static String getFundOrgFieldName(String dataSource, boolean isNeedMainOrg) {
        return CfmBillCommonHelper.getFundOrgFieldName(dataSource, isNeedMainOrg, null);
    }

    public static String getFundOrgFieldName(String dataSource, boolean isNeedMainOrg, String creditorType) {
        if (StringUtils.equals((CharSequence)creditorType, (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue())) {
            return "creditorg";
        }
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            if (isNeedMainOrg) {
                return "creditorg";
            }
            return "org";
        }
        if (isNeedMainOrg) {
            return "org";
        }
        return "creditorg";
    }

    public static String getPropLocalDisplayName(IFormView view, String propName) {
        IDataEntityProperty prop = view.getModel().getProperty(propName);
        LocaleString curDisplayName = prop.getDisplayName();
        return curDisplayName != null ? curDisplayName.getLocaleValue() : null;
    }

    public static void PreOpenPageDeal(PreOpenFormEventArgs e, boolean isList) {
        String formId;
        String pFormId;
        Object pkId;
        ListShowParameter srcBillParameter;
        if (isList) {
            srcBillParameter = (ListShowParameter)e.getSource();
            if (EmptyUtil.isEmpty((Object)srcBillParameter)) {
                return;
            }
            LinkQueryPkIdCollection pkIds = srcBillParameter.getLinkQueryPkIdCollection();
            if (EmptyUtil.isEmpty((Collection)pkIds)) {
                return;
            }
            pkId = ((LinkQueryPkId)pkIds.get(0)).getPkId();
            pFormId = srcBillParameter.getParentFormId();
            formId = srcBillParameter.getBillFormId();
        } else {
            srcBillParameter = (BillShowParameter)e.getSource();
            if (EmptyUtil.isEmpty((Object)srcBillParameter)) {
                return;
            }
            pkId = srcBillParameter.getPkId();
            pFormId = srcBillParameter.getParentFormId();
            formId = srcBillParameter.getFormId();
        }
        if (BatchIntBillHelper.isDepostPreInt(formId)) {
            return;
        }
        if ("botp_lookuptracker".equals(pFormId) && EmptyUtil.isNoEmpty((String)formId) && EmptyUtil.isNoEmpty((Object)pkId) && EmptyUtil.isNoEmpty((String)pFormId)) {
            QFilter idQFilter = new QFilter("id", "=", pkId);
            DynamicObjectCollection bizBills = QueryServiceHelper.query((String)CfmBillCommonHelper.getEntityNameByFormId(formId), (String)"id,loantype", (QFilter[])idQFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)bizBills)) {
                logger.info(formId + ":botp_\u6ca1\u67e5\u5230\u6570\u636e\u88abcancel");
                e.setCancel(true);
                return;
            }
            String biztype = ((DynamicObject)bizBills.get(0)).getString("loantype");
            if (isList) {
                ((ListShowParameter)e.getFormShowParameter()).setBillFormId((String)CfmBillCommonHelper.getFormIdBySrcLoanType(formId, biztype).getLeft());
            } else {
                e.getFormShowParameter().setFormId((String)CfmBillCommonHelper.getFormIdBySrcLoanType(formId, biztype).getLeft());
            }
            String billCaption = (String)CfmBillCommonHelper.getFormIdBySrcLoanType(formId, biztype).getRight();
            if (EmptyUtil.isNoEmpty((String)billCaption)) {
                e.getFormShowParameter().setCaption(billCaption);
            }
            e.getFormShowParameter().setCustomParam("biztype", (Object)biztype);
        }
    }

    private static Pair<String, String> getFormIdBySrcLoanType(String srcFormId, String loanType) {
        if (BizTypeEnum.ENTRUST.getValue().equals(loanType) || BizTypeEnum.EC.getValue().equals(loanType)) {
            if (srcFormId.startsWith("cim_invest")) {
                return Pair.of((Object)srcFormId, null);
            }
            switch (srcFormId) {
                case "cfm_loancontractbill": {
                    return Pair.of((Object)"cfm_loancontract_ic_l", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e\u5408\u540c", (String)"CfmBillCommonHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_contractextendbill": {
                    return Pair.of((Object)"cfm_contractextend_ic_l", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e\u5408\u540c\u5c55\u671f", (String)"CfmBillCommonHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_repaymentbill": {
                    return Pair.of((Object)"cfm_repaymentbill_e_l", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u8fd8\u6b3e\u5904\u7406", (String)"CfmBillCommonHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_interestbill": {
                    return Pair.of((Object)"cfm_interestbill_e", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u4ed8\u606f\u5904\u7406", (String)"CfmBillCommonHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_loanbill": {
                    return Pair.of((Object)"cfm_loanbill_e_l", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u63d0\u6b3e\u5904\u7406", (String)"CfmBillCommonHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_preinterestbill": {
                    return Pair.of((Object)"cfm_preinterestbill_e", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u5e94\u4ed8\u5229\u606f\u9884\u63d0", (String)"CfmBillCommonHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
            }
        } else if (BizTypeEnum.LOAN.getValue().equals(loanType) || BizTypeEnum.SL.getValue().equals(loanType)) {
            switch (srcFormId) {
                case "cfm_loancontractbill": {
                    return Pair.of((Object)"cfm_loancontract_bl_l", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e\u5408\u540c", (String)"CfmBillCommonHelper_6", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_contractextendbill": {
                    return Pair.of((Object)"cfm_contractextend_bl_l", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e\u5408\u540c\u5c55\u671f", (String)"CfmBillCommonHelper_7", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_repaymentbill": {
                    return Pair.of((Object)"cfm_repaymentbill_b_l", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u8fd8\u6b3e\u5904\u7406", (String)"CfmBillCommonHelper_8", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_loanbill": {
                    return Pair.of((Object)"cfm_loanbill_b_l", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5904\u7406", (String)"CfmBillCommonHelper_9", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_interestbill": {
                    return Pair.of((Object)"cfm_interestbill_b", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u4ed8\u606f\u5904\u7406", (String)"CfmBillCommonHelper_10", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_preinterestbill": {
                    return Pair.of((Object)"cfm_preinterestbill_b", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u5e94\u4ed8\u5229\u606f\u9884\u63d0", (String)"CfmBillCommonHelper_11", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
            }
        } else if (BizTypeEnum.BOND.getValue().equals(loanType)) {
            switch (srcFormId) {
                case "cfm_repaymentbill": {
                    return Pair.of((Object)"cfm_repaymentbill_bond", (Object)ResManager.loadKDString((String)"\u503a\u5238\u8fd8\u6b3e\u5904\u7406", (String)"CfmBillCommonHelper_12", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_interestbill": {
                    return Pair.of((Object)"cfm_interestbill_bond", (Object)ResManager.loadKDString((String)"\u503a\u5238\u4ed8\u606f\u5904\u7406", (String)"CfmBillCommonHelper_13", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
                case "cfm_preinterestbill": {
                    return Pair.of((Object)"cfm_preinterestbill_bond", (Object)ResManager.loadKDString((String)"\u503a\u5238\u5e94\u4ed8\u5229\u606f\u9884\u63d0", (String)"CfmBillCommonHelper_14", (String)"tmc-cfm-common", (Object[])new Object[0]));
                }
            }
        }
        return Pair.of((Object)srcFormId, null);
    }

    public static String getEntityNameByFormId(String billFormId) {
        switch (billFormId) {
            case "cfm_loancontract_bl_l": 
            case "cfm_loancontract_ic_l": {
                return "cfm_loancontractbill";
            }
            case "cfm_loanbill_b_l": 
            case "cfm_loanbill_e_l": {
                return "cfm_loanbill";
            }
            case "cfm_repaymentbill_b_l": 
            case "cfm_repaymentbill_e_l": 
            case "cfm_repaymentbill_bond": {
                return "cfm_repaymentbill";
            }
            case "cfm_interestbill_b": 
            case "cfm_interestbill_e": 
            case "cfm_interestbill_bond": {
                return "cfm_interestbill";
            }
            case "cfm_preinterestbill_b": 
            case "cfm_preinterestbill_e": 
            case "cfm_preinterestbill_bond": {
                return "cfm_preinterestbill";
            }
            case "cfm_contractextend_bl_l": 
            case "cfm_contractextend_ic_l": {
                return "cfm_contractextendbill";
            }
        }
        return billFormId;
    }

    public static boolean isSettleCenter(DynamicObject repayApplyBill) {
        DynamicObject contractF7 = repayApplyBill.getDynamicObject("loancontractbill");
        String creditorType = contractF7.getString("creditortype");
        return CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType);
    }

    public static boolean isInnerOrg(DynamicObject repayApplyBill) {
        DynamicObject contractF7 = repayApplyBill.getDynamicObject("loancontractbill");
        String creditorType = contractF7.getString("creditortype");
        return CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType);
    }

    public static void trace2RepayExtendBill(DynamicObject applyBill, IFormView view, String applyType) {
        DynamicObjectCollection tagBill;
        QFilter applyFilter;
        if (!BillStatusEnum.AUDIT.getValue().equals(applyBill.getString("billstatus"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u8054\u67e5\u8fd8\u6b3e\u64cd\u4f5c\u3002", (String)"CfmBillCommonHelper_15", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        String loanType = applyBill.getString("loantype");
        String formId = "cfm_repaymentbill_b_l";
        if ("repay".equals(applyType)) {
            if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
                formId = "cfm_repaymentbill_e_l";
            } else if (LoanTypeEnum.FINLEASE.getValue().equals(loanType)) {
                formId = "fl_rentpaybill";
            } else if (LoanTypeEnum.isBond(loanType)) {
                formId = "cfm_repaymentbill_bond";
            }
            applyFilter = new QFilter("repayapplyf7", "=", applyBill.getPkValue());
            tagBill = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id", (QFilter[])applyFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)tagBill)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8fd8\u6b3e\u7533\u8bf7\u5355\u672a\u627e\u5230\u8fd8\u6b3e\u5355,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CfmBillCommonHelper_16", (String)"tmc-cfm-common", (Object[])new Object[0]));
                return;
            }
        } else if ("extend".equals(applyType)) {
            formId = "cfm_contractextend_bl_l";
            if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
                formId = "cfm_contractextend_ic_l";
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(tagBill = QueryServiceHelper.query((String)"cfm_contractextendbill", (String)"id", (QFilter[])(applyFilter = new QFilter("extendapplyf7", "=", applyBill.getPkValue())).toArray())))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5c55\u671f\u7533\u8bf7\u5355\u672a\u627e\u5230\u5c55\u671f\u5355,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CfmBillCommonHelper_17", (String)"tmc-cfm-common", (Object[])new Object[0]));
                return;
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u3002", (String)"CfmBillCommonHelper_18", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(((DynamicObject)tagBill.get(0)).get("id"));
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
        view.showForm((FormShowParameter)showParameter);
    }

    public static void updateApplyBizStatus(List<DynamicObject> bizBills, String bizApplyF7Prop, String applyEntity, String bizSataus) {
        DynamicObject[] applyBills;
        Set applyIds = bizBills.stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject(bizApplyF7Prop))).map(d -> d.getDynamicObject(bizApplyF7Prop).getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(applyIds)) {
            return;
        }
        for (DynamicObject applyBill : applyBills = TmcDataServiceHelper.load((String)applyEntity, (String)"businessstatus", (QFilter[])new QFilter("id", "in", applyIds).toArray())) {
            applyBill.set("businessstatus", (Object)bizSataus);
        }
        SaveServiceHelper.update((DynamicObject[])applyBills);
    }

    public static void updateApplyBizStatus(DynamicObject bizBill, String bizApplyF7Prop, String applyEntity, String bizSataus) {
        CfmBillCommonHelper.updateApplyBizStatus(Collections.singletonList(bizBill), bizApplyF7Prop, applyEntity, bizSataus);
    }

    public static Set<Long> getVoucherList(List<String> entityNames, List<Object> billIds) {
        QFilter filter = new QFilter("sourcebillid", "in", billIds);
        filter.and(new QFilter("billtype", "in", entityNames));
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{filter});
        HashSet<Long> idSet = new HashSet<Long>(16);
        if (vouchersDaps != null) {
            for (DynamicObject vh : vouchersDaps) {
                idSet.add(vh.getLong("sourcebillid"));
            }
        }
        return idSet;
    }

    public static void checkUnAuditIntBill(BeforeDoOperationEventArgs args, IFormView view) {
        Object[] rePaymentBillIds = CfmBillCommonHelper.getSelectIds(view);
        DynamicObjectCollection rePaymentBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"billno,datasource", (QFilter[])new QFilter("id", "in", (Object)rePaymentBillIds).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)rePaymentBills)) {
            return;
        }
        QFilter filter = new QFilter("repaymentid", "in", (Object)rePaymentBillIds);
        filter.and(new QFilter("instbillctg", "=", (Object)InterestbillctgEnum.PAYPRINANDINTE.getValue()));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        DynamicObjectCollection intBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"repaymentid", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)intBills)) {
            return;
        }
        Map intBillMap = intBills.stream().collect(Collectors.toMap(v -> v.get("repaymentid"), Function.identity()));
        HashSet<String> errorRePayBillNo = new HashSet<String>(rePaymentBills.size());
        for (DynamicObject rePaymentBill : rePaymentBills) {
            if (!EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)intBillMap.get(rePaymentBill.getPkValue())))) continue;
            errorRePayBillNo.add(rePaymentBill.getString("billno"));
        }
        if (EmptyUtil.isNoEmpty(errorRePayBillNo)) {
            args.setCancel(true);
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(((DynamicObject)rePaymentBills.get(0)).getString("datasource"));
            view.showErrorNotification(String.format(bizResource.getIbUnAuditPayCorInt(), String.join((CharSequence)"\uff0c", errorRePayBillNo)));
        }
    }

    private static Object[] getSelectIds(IFormView view) {
        Object[] rePaymentBillIds = null;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            IListView listView = (IListView)view;
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (EmptyUtil.isNoEmpty((Object)selectedRows)) {
                rePaymentBillIds = selectedRows.getPrimaryKeyValues();
            }
        } else {
            DynamicObject dataEntity = view.getModel().getDataEntity();
            rePaymentBillIds = new Object[]{dataEntity.getPkValue()};
        }
        return rePaymentBillIds;
    }

    public static boolean isRelateAppSet(String appId) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        long orgId = null != rootNode ? Long.parseLong(rootNode.getId()) : 0L;
        Set<String> appSet = CfmSysParamHelper.getParameterComboxs(TmcAppEnum.IFM.getId(), orgId, "ifm003");
        return null != appSet && appSet.contains(appId);
    }

    public static String getLoanNameByDataSource(String dataSource) {
        String resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_19.loadKDString();
        if (DataSourceEnum.isBond(dataSource)) {
            resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_21.loadKDString();
        } else if (DataSourceEnum.isInvest(dataSource) || DataSourceEnum.isIfm(dataSource)) {
            resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_20.loadKDString();
        }
        return resMsg;
    }

    public static String getContractNameByDataSource(String dataSource) {
        String resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_22.loadKDString();
        if (DataSourceEnum.isBond(dataSource)) {
            resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_23.loadKDString();
        }
        return resMsg;
    }

    public static String getIntNameByDataSource(String dataSource) {
        String resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_24.loadKDString();
        if (DataSourceEnum.isInvest(dataSource)) {
            resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_25.loadKDString();
        } else if (DataSourceEnum.isIfm(dataSource)) {
            resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_26.loadKDString();
        }
        return resMsg;
    }

    public static String getRepayNameByDataSource(String dataSource) {
        String resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_27.loadKDString();
        if (DataSourceEnum.isInvest(dataSource) || DataSourceEnum.isIfm(dataSource)) {
            resMsg = CfmCommonResourceEnum.CfmBillCommonHelper_28.loadKDString();
        }
        return resMsg;
    }

    static {
        bizBillPushRelationMap.put(CfmEntityEnum.INVEST_LOANBILL.getValue(), CfmEntityEnum.getName(CfmEntityEnum.CAS_PAYBILL.getValue()));
        bizBillPushRelationMap.put(CfmEntityEnum.LOANBILL.getValue(), CfmEntityEnum.getName(CfmEntityEnum.CAS_RECBILL.getValue()));
        bizBillPushRelationMap.put(CfmEntityEnum.INVEST_REPAYBILL.getValue(), CfmEntityEnum.getName(CfmEntityEnum.REPAYMENTBILL.getValue()));
        bizBillPushRelationMap.put(CfmEntityEnum.REPAYMENTBILL.getValue(), CfmEntityEnum.getName(CfmEntityEnum.CAS_PAYBILL.getValue()));
        bizBillPushRelationMap.put(CfmEntityEnum.INVEST_INTERESTBILL.getValue(), CfmEntityEnum.getName(CfmEntityEnum.CAS_RECBILL.getValue()));
        bizBillPushRelationMap.put(CfmEntityEnum.INTERESTBILL.getValue(), CfmEntityEnum.getName(CfmEntityEnum.CAS_PAYBILL.getValue()));
        loanRePayInstPlanMap = new HashMap<String, Pair<String, String>>(16);
        loanRePayInstPlanMap.put("cfm_loanbill", (Pair<String, String>)Pair.of((Object)"cfm_loadbill_view", (Object)"cfm_loanbill_intplan"));
        loanRePayInstPlanMap.put("cfm_loanbill_b_l", (Pair<String, String>)Pair.of((Object)"cfm_loadbill_view", (Object)"cfm_loanbill_intplan"));
        loanRePayInstPlanMap.put("cfm_loanbill_e_l", (Pair<String, String>)Pair.of((Object)"cfm_loadbill_view", (Object)"cfm_loanbill_intplan"));
        loanRePayInstPlanMap.put("cfm_loanbill_bond", (Pair<String, String>)Pair.of((Object)"cfm_loanbill_bond_p", (Object)"cfm_loanbill_bond_intplan"));
        loanRePayInstPlanMap.put("cim_invest_loanbill", (Pair<String, String>)Pair.of((Object)"cim_invest_loanbil_plan", (Object)"cim_invest_loanb_intplan"));
        loanRePayInstPlanMap.put("ifm_loanbill", (Pair<String, String>)Pair.of((Object)"ifm_loanbill_repayplan_l", (Object)"ifm_loanbill_intplan"));
    }
}

