/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.RelationTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmContractBillHelper {
    private static final Map<String, String> statusMap = new HashMap<String, String>(16);

    public static void setLoanApplyBillConfirmStatus(DynamicObject[] contractBills, boolean isDel) {
        List<DynamicObject> needSaveApplyBills;
        List afterFilterBizBills = Arrays.stream(contractBills).filter(o -> !EmptyUtil.isEmpty((String)o.getString("lenderapplyno"))).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(afterFilterBizBills) && afterFilterBizBills.size() > 0 && !(needSaveApplyBills = afterFilterBizBills.stream().map(contractBill -> CfmContractBillHelper.getTargetPriorityBillStautsApplyBill(contractBill, isDel)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList())).isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needSaveApplyBills.toArray(new DynamicObject[0]));
        }
    }

    public static void resetApplyBillConfirmStatus(DynamicObject[] contractBills) {
        Object[] applyDOs;
        List contractIds = Arrays.stream(contractBills).map(o -> o.getLong("id")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        DynamicObjectCollection contractDOs = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id, sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIds), new QFilter("sourcebillid", ">", (Object)0L)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractDOs)) {
            return;
        }
        ArrayList<Long> needResetApplyIds = new ArrayList<Long>(contractBills.length);
        HashMap<Long, Long> idSourceBillIdMap = new HashMap<Long, Long>(10);
        for (DynamicObject contract : contractDOs) {
            idSourceBillIdMap.put(contract.getLong("id"), contract.getLong("sourcebillid"));
        }
        for (DynamicObject contract : contractBills) {
            Long sourceBillId = (Long)idSourceBillIdMap.get(contract.getLong("id"));
            if (!EmptyUtil.isNoEmpty((Long)sourceBillId) || sourceBillId.equals(contract.getLong("sourcebillid"))) continue;
            needResetApplyIds.add(sourceBillId);
        }
        if (EmptyUtil.isEmpty(needResetApplyIds)) {
            return;
        }
        for (Object applyDo : applyDOs = TmcDataServiceHelper.load((String)CfmEntityEnum.LOAN_APPLY.getValue(), (String)"id,businessstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", needResetApplyIds)})) {
            applyDo.set("businessstatus", (Object)ApplyBusinessStatusEnum.NOTHAND.getValue());
        }
        if (EmptyUtil.isNoEmpty((Object[])applyDOs)) {
            SaveServiceHelper.save((DynamicObject[])applyDOs);
        }
    }

    public static void setDrawPlanOrder(DynamicObject[] contractBills) {
        for (DynamicObject contractBill : contractBills) {
            int i;
            String loanType = contractBill.getString("loantype");
            if (BizTypeEnum.isBond(loanType) || BizTypeEnum.isFinLease(loanType)) {
                return;
            }
            DynamicObjectCollection planEntrys = contractBill.getDynamicObjectCollection("drawdownplan_entry");
            for (i = planEntrys.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)planEntrys.get(i);
                if (!EmptyUtil.isEmpty((Object)entry.get("e_plandrawdate")) && !EmptyUtil.isEmpty((Object)entry.get("e_plandrawamt"))) continue;
                planEntrys.remove(i);
            }
            Collections.sort(planEntrys, Comparator.comparing(o -> o.getDate("e_plandrawdate")));
            for (i = 0; i <= planEntrys.size() - 1; ++i) {
                ((DynamicObject)planEntrys.get(i)).set("seq", (Object)(i + 1));
            }
        }
    }

    public static DynamicObject getTargetPriorityBillStautsApplyBill(DynamicObject contractBill, boolean isDelOp) {
        DynamicObject lenderApplyDo;
        TreeSet<String> tagBillBillStatus = new TreeSet<String>(Comparator.comparingInt(String::hashCode));
        String lenderApplyNo = contractBill.getString("lenderapplyno");
        String applyName = CfmEntityEnum.LOAN_APPLY.getValue();
        if ("fl_leasecontractbill".equals(contractBill.getDataEntityType().getName())) {
            applyName = "fl_financelease_apply";
        }
        if (!EmptyUtil.isEmpty((DynamicObject)(lenderApplyDo = TmcDataServiceHelper.loadSingle((String)applyName, (String)"id,businessstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)lenderApplyNo)})))) {
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)applyName, (Long[])new Long[]{lenderApplyDo.getLong("id")});
            for (Map.Entry targetBillMap : targetBills.entrySet()) {
                Object[] targetDOs = TmcDataServiceHelper.load((Object[])((HashSet)targetBillMap.getValue()).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)targetBillMap.getKey())));
                if (EmptyUtil.isEmpty((Object[])targetDOs)) continue;
                List contractTarList = Arrays.stream(targetDOs).filter(o -> CfmEntityEnum.INVEST_CONTRACT.getValue().equals(o.getDynamicObjectType().getName()) || CfmEntityEnum.CONTRACTBILL.getValue().equals(o.getDynamicObjectType().getName()) || CfmEntityEnum.FL_LEASECONTRACTBILL.getValue().equals(o.getDynamicObjectType().getName())).collect(Collectors.toList());
                if (contractTarList.isEmpty()) {
                    return null;
                }
                if (isDelOp) {
                    for (DynamicObject targetDO : contractTarList) {
                        if (contractBill.getPkValue().equals(targetDO.getPkValue())) continue;
                        tagBillBillStatus.add(targetDO.getString("billstatus"));
                    }
                    continue;
                }
                for (Object targetDO : targetDOs) {
                    tagBillBillStatus.add(targetDO.getString("billstatus"));
                }
            }
        }
        if (!tagBillBillStatus.isEmpty()) {
            String priorityBillStauts = tagBillBillStatus.last();
            String confirmStatus = lenderApplyDo.getString("businessstatus");
            if (!statusMap.get(priorityBillStauts).equals(confirmStatus)) {
                lenderApplyDo.set("businessstatus", (Object)statusMap.get(priorityBillStauts));
                return lenderApplyDo;
            }
        } else if (isDelOp) {
            lenderApplyDo.set("businessstatus", (Object)ApplyBusinessStatusEnum.NOTHAND.getValue());
            return lenderApplyDo;
        }
        return null;
    }

    public static boolean mayUseCreditLimit(DynamicObject contractBill) {
        String entityName = contractBill.getDynamicObjectType().getName();
        if (CfmEntityConst.isLeaseContractBill(entityName)) {
            return true;
        }
        DynamicObject pfDO = contractBill.getDynamicObject("productfactory");
        String loanType = contractBill.getString("loantype");
        String dataSource = contractBill.getString("datasource");
        String creditType = contractBill.getString("creditortype");
        if (DataSourceEnum.isInvest(dataSource)) {
            creditType = contractBill.getString("debtortype");
        }
        if (BizTypeEnum.isSL(loanType)) {
            return true;
        }
        return CfmContractBillHelper.creditLoanType(loanType, creditType) && EmptyUtil.isNoEmpty((DynamicObject)pfDO) && pfDO.getBoolean("isloancommit");
    }

    public static boolean mayUseCreditLimit(IDataModel model) {
        String entityName = model.getDataEntityType().getName();
        if (CfmEntityConst.isLeaseContractBill(entityName)) {
            return true;
        }
        Object pfDO = model.getValue("productfactory");
        String loanType = (String)model.getValue("loantype");
        String creditType = (String)model.getValue("creditortype");
        String dataSource = (String)model.getValue("datasource");
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && !CreditorTypeEnum.isInnerUnit((String)(creditType = (String)model.getValue("debtortype")))) {
            return false;
        }
        if (BizTypeEnum.SL.getValue().equals(loanType)) {
            return true;
        }
        return CfmContractBillHelper.creditLoanType(loanType, creditType) && EmptyUtil.isNoEmpty((Object)pfDO) && ((DynamicObject)pfDO).getBoolean("isloancommit");
    }

    public static boolean mustUseCreditLimit(DynamicObject contractBill) {
        DynamicObject pfDO = contractBill.getDynamicObject("productfactory");
        String loanType = contractBill.getString("loantype");
        String creditType = contractBill.getString("creditortype");
        String dataSource = contractBill.getString("datasource");
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && !CreditorTypeEnum.isInnerUnit((String)(creditType = contractBill.getString("debtortype")))) {
            return false;
        }
        return CfmContractBillHelper.creditLoanType(loanType, creditType) && EmptyUtil.isNoEmpty((DynamicObject)pfDO) && pfDO.getBoolean("isloancommit") && pfDO.getBoolean("iscreditlimit");
    }

    public static void pushLoanBill(IFormView view, Long contractId) {
        String srcLayoutFormId = CfmBillCommonHelper.getFormIdByShowParameter(view);
        String targetLayoutFormId = "cfm_loanbill";
        String targetEntityNumber = "cfm_loanbill";
        String srcEntityNumber = "cfm_loancontractbill";
        if ("cfm_loancontract_bl_l".equals(srcLayoutFormId)) {
            targetLayoutFormId = "cfm_loanbill_b_l";
        } else if ("cfm_loancontract_ic_l".equals(srcLayoutFormId)) {
            targetLayoutFormId = "cfm_loanbill_e_l";
        } else if ("cfm_loancontract_bo".equals(srcLayoutFormId)) {
            srcEntityNumber = "cfm_loancontract_bo";
            targetLayoutFormId = "cfm_loanbill_bond";
            targetEntityNumber = "cfm_loanbill_bond";
        } else if ("cim_invest_contract".equals(srcLayoutFormId)) {
            srcEntityNumber = "cim_invest_contract";
            targetLayoutFormId = "cim_invest_loanbill";
            targetEntityNumber = "cim_invest_loanbill";
        } else if ("ifm_loancontractbill".equals(srcLayoutFormId)) {
            srcEntityNumber = "ifm_loancontractbill";
            targetLayoutFormId = "ifm_loanbill";
            targetEntityNumber = "ifm_loanbill";
        }
        TmcBotpHelper.doPush((IFormView)view, (Long)contractId, (String)srcEntityNumber, (String)targetEntityNumber, (String)srcLayoutFormId, (String)targetLayoutFormId);
    }

    public static void pushRepaymentBill(IFormView view, DynamicObject[] loanBills) {
        String thisSrcFormId = CfmBillCommonHelper.getFormIdByShowParameter(view);
        String srcEntityNumber = "cfm_loanbill";
        String srcLayoutFormId = "cfm_loanbill_b_l";
        String biztype = loanBills[0].getString("loantype");
        String targetEntityNumber = "cfm_repaymentbill";
        String targetLayoutFormId = "cfm_repaymentbill_b_l";
        if (BizTypeEnum.BOND.getValue().equals(biztype)) {
            srcEntityNumber = "cfm_loanbill_bond";
            srcLayoutFormId = "cfm_loanbill_bond";
            targetLayoutFormId = "cfm_repaymentbill_bond";
        } else if (BizTypeEnum.ENTRUST.getValue().equals(biztype) || BizTypeEnum.EC.getValue().equals(biztype)) {
            if ("cfm_loancontract_ic_l".equals(thisSrcFormId)) {
                srcLayoutFormId = "cfm_loanbill_e_l";
                targetLayoutFormId = "cfm_repaymentbill_e_l";
            } else if ("cim_invest_contract".equals(thisSrcFormId)) {
                srcEntityNumber = "cim_invest_loanbill";
                srcLayoutFormId = "cim_invest_loanbill";
                targetEntityNumber = "cim_invest_repaybill";
                targetLayoutFormId = "cim_invest_repaybill";
            }
        } else if ("ifm_loancontractbill".equals(thisSrcFormId)) {
            srcEntityNumber = "ifm_loanbill";
            srcLayoutFormId = "ifm_loanbill";
            targetEntityNumber = "ifm_repaymentbill";
            targetLayoutFormId = "ifm_repaymentbill";
        } else if (BizTypeEnum.isFinLease(biztype)) {
            srcEntityNumber = "fl_receiptbill";
            srcLayoutFormId = "fl_receiptbill";
            targetEntityNumber = "fl_rentpaybill";
            targetLayoutFormId = "fl_rentpaybill";
        }
        List loanIds = Arrays.stream(loanBills).map(v -> v.getLong("id")).collect(Collectors.toList());
        TmcBotpHelper.doPush((IFormView)view, loanIds, (String)srcEntityNumber, (String)targetEntityNumber, (String)srcLayoutFormId, (String)targetLayoutFormId);
    }

    public static void dealFieldValueOnSave(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String intType = dataEntity.getString("interesttype");
            if (InterestTypeEnum.FIXED.getValue().equals(intType) || InterestTypeEnum.AGREE.getValue().equals(intType)) {
                dataEntity.set("rateadjuststyle", null);
                dataEntity.set("rateadjustcycle", (Object)0);
                dataEntity.set("rateadjustcycletype", null);
                dataEntity.set("rateadjustdate", null);
                dataEntity.set("referencerate", null);
                dataEntity.set("ratesign", null);
                dataEntity.set("ratefloatpoint", null);
            }
            if (InterestTypeEnum.FLOAT.getValue().equals(intType)) {
                CfmBillCommonHelper.dealFloatRateVal(dataEntity);
                String adjuststyle = dataEntity.getString("rateadjuststyle");
                if (!RateAdjustStyleEnum.CYCLE.getValue().equals(adjuststyle)) {
                    dataEntity.set("rateadjustcycle", (Object)0);
                    dataEntity.set("rateadjustcycletype", null);
                    dataEntity.set("rateadjustdate", null);
                }
            }
            if (!EmptyUtil.isEmpty((String)dataEntity.getString("lenderapplyno"))) continue;
            dataEntity.set("loanapply", null);
            dataEntity.set("sourcebillid", (Object)0L);
        }
    }

    public static boolean isCanOpContract(String dataSource, String contractBillFormId) {
        if (DataSourceEnum.BOND.getValue().equals(dataSource) && "cfm_loancontract_bo".equals(contractBillFormId)) {
            return true;
        }
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && "cim_invest_contract".equals(contractBillFormId)) {
            return true;
        }
        if (DataSourceEnum.CFM.getValue().equals(dataSource) && ("cfm_loancontract_ic_l".equals(contractBillFormId) || "cfm_loancontract_bl_l".equals(contractBillFormId)) || "cfm_loancontractbill".equals(contractBillFormId)) {
            return true;
        }
        if (DataSourceEnum.IFM.getValue().equals(dataSource) && "ifm_loancontractbill".equals(contractBillFormId)) {
            return true;
        }
        return DataSourceEnum.FL.getValue().equals(dataSource) && "fl_leasecontractbill".equals(contractBillFormId);
    }

    public static void contractRepay(Long id, IFormView view) {
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"cfm_loancontractbill", (String)"id, contractstatus, datasource, creditortype, creditorg, org, productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u4e2d\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CfmContractBillHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("loancontractbill.id", "=", (Object)id).and(new QFilter("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue())));
        Map map = TmcDataServiceHelper.loadFromCache((String)"cfm_loanbill", (String)"id,loantype,repaymentway,repayplan_entry,repayplan_entry.exrepaymentdate,repayplan_entry.enotrepayamount,repayplan_entry.repaystate", (QFilter[])filter.toArray());
        if (map == null || map.isEmpty()) {
            if (!LoanContractStatusEnum.EXECUTING.getValue().equals(contractBill.getString("contractstatus"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u4e2d\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CfmContractBillHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
                return;
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u72b6\u6001\u7684\u4e0b\u6e38\u5355\u636e,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CfmContractBillHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] loanBills = map.values().toArray(new DynamicObject[0]);
        if (CfmContractBillHelper.isRepayByPlan(contractBill) && loanBills.length > 1 && CfmContractBillHelper.isCanNotRepay(loanBills)) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
            view.showTipNotification(bizResource.getrepayByPlanLoansCheck());
            return;
        }
        QFilter repayFilter = new QFilter("loancontractbill.id", "=", (Object)id).and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        boolean isHasIngRepayBill = TmcDataServiceHelper.exists((String)"cfm_repaymentbill", (QFilter[])repayFilter.toArray());
        if (isHasIngRepayBill) {
            String appId = view.getFormShowParameter().getAppId();
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u8fd8\u6b3e/\u6536\u56de\u5355,\u8bf7\u5148\u5904\u7406\u3002", (String)"CfmContractBillHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]);
            if (StringUtils.equals((CharSequence)appId, (CharSequence)"fl")) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u79df\u91d1\u652f\u4ed8\u5355,\u8bf7\u5148\u5904\u7406\u3002", (String)"CfmContractBillHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            view.showTipNotification(errorMsg);
            return;
        }
        CfmContractBillHelper.pushRepaymentBill(view, loanBills);
    }

    public static boolean creditLoanType(String type, String creditType) {
        if (CreditorTypeEnum.OTHER.getValue().equals(creditType)) {
            return false;
        }
        return LoanTypeEnum.isBankLoan(type) || LoanTypeEnum.isBanksLoan(type) || LoanTypeEnum.isEntrustLoan(type) || LoanTypeEnum.isLinklend(type);
    }

    public static boolean creditPreUse(String type, String creditorType) {
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            return false;
        }
        List<String> types = Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue());
        return types.contains(type);
    }

    public static QFilter getLcArrivalQfilter(DynamicObject org) {
        QFilter lcPresentQF = new QFilter("billstatus", "=", (Object)"C").and(new QFilter("org.id", "=", org.getPkValue())).and("arrivalstatus", "=", (Object)"arrival_confirm").and("arrivalway", "!=", (Object)"protest").and("islinkcfm", "=", (Object)false);
        DynamicObject[] lcBills = TmcDataServiceHelper.load((String)RelationTypeEnum.IL.getEntiy(), (String)"id,todoamount,lockamount", (QFilter[])lcPresentQF.toArray());
        List presentIds = Arrays.stream(lcBills).filter(o -> o.getBigDecimal("todoamount").compareTo(o.getBigDecimal("lockamount")) > 0).map(o -> o.getLong("id")).collect(Collectors.toList());
        return new QFilter("id", "in", presentIds);
    }

    public static QFilter getLcPresentQfilter(DynamicObject org) {
        QFilter lcArralQF = new QFilter("org.id", "=", org.getPkValue());
        lcArralQF.and(new QFilter("billstatus", "=", (Object)"C")).and("arrivalstatus", "=", (Object)"present_confirm").and("arrivalway", "!=", (Object)"protest").and("isreceipt", "=", (Object)false).and("isforfaiting", "=", (Object)false).and(new QFilter("islinkcfm", "=", (Object)"0"));
        return lcArralQF;
    }

    public static Set<Long> getCurrencyPks(Long acctIds) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acctIds), new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1'))}, null);
        HashSet<Long> currencyIdSet = new HashSet<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            currencyIdSet.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return currencyIdSet;
    }

    public static boolean isRepayByPlan(DynamicObject bill) {
        String creditorType;
        String dataSource = bill.getString("datasource");
        String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName(dataSource, true, creditorType = bill.getString("creditortype"));
        DynamicObject org = bill.getDynamicObject(mainOrgField);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return false;
        }
        DynamicObject product = bill.getDynamicObject("productfactory");
        boolean isRepayByPlan = EmptyUtil.isNoEmpty((DynamicObject)product) && product.getBoolean("isrepayplan");
        boolean isCfm = !dataSource.equals(DataSourceEnum.BOND.getValue()) && CfmSysParamHelper.getAppBoolParameter(org.getLong("id"), "cfm005");
        boolean isBdim = dataSource.equals(DataSourceEnum.BOND.getValue()) && TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.BOND.getId(), (long)org.getLong("id"), (String)"bdim001");
        return isCfm || isBdim || isRepayByPlan;
    }

    public static boolean isCanNotRepay(DynamicObject[] loanBills) {
        Date repaymentDate = null;
        for (DynamicObject loanBill : loanBills) {
            DynamicObjectCollection repayPlanEntrys = loanBill.getDynamicObjectCollection("repayplan_entry");
            DynamicObject repayPlanEntry = repayPlanEntrys.stream().filter(o -> o.getBigDecimal("enotrepayamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("repaystate") == 0).min(Comparator.comparing(c -> c.getDate("exrepaymentdate"))).orElseGet(null);
            if (!EmptyUtil.isNoEmpty((DynamicObject)repayPlanEntry)) continue;
            Date exRepaymentDate = repayPlanEntry.getDate("exrepaymentdate");
            if (repaymentDate != null && repaymentDate.compareTo(exRepaymentDate) != 0) {
                return true;
            }
            repaymentDate = exRepaymentDate;
        }
        return false;
    }

    public static boolean isChangePlanByApply(DynamicObject loanBill) {
        String creditorType;
        String dataSource = loanBill.getString("datasource");
        String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName(dataSource, true, creditorType = loanBill.getString("creditortype"));
        DynamicObject org = loanBill.getDynamicObject(mainOrgField);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return false;
        }
        return CfmSysParamHelper.getAppBoolParameter(org.getLong("id"), "cfm011");
    }

    public static boolean isPayIntByPlan(DynamicObject loanBill) {
        String creditorType;
        String dataSource = loanBill.getString("datasource");
        String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName(dataSource, true, creditorType = loanBill.getString("creditortype"));
        DynamicObject org = loanBill.getDynamicObject(mainOrgField);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return false;
        }
        if (DataSourceEnum.isBond(dataSource)) {
            return CfmSysParamHelper.getAppBoolParameter((String)TmcAppEnum.BOND.getId(), (long)org.getLong("id"), (String)"bdim002");
        }
        return CfmSysParamHelper.getAppBoolParameter(org.getLong("id"), "cfm012");
    }

    static {
        statusMap.put(BillStatusEnum.SAVE.getValue(), ApplyBusinessStatusEnum.HANDING.getValue());
        statusMap.put(BillStatusEnum.SUBMIT.getValue(), ApplyBusinessStatusEnum.HANDING.getValue());
        statusMap.put(BillStatusEnum.AUDIT.getValue(), ApplyBusinessStatusEnum.HANDED.getValue());
    }
}

