/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.bean.CompCostBean;
import kd.tmc.fbp.common.bean.CompCostRateBean;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CompCostHelper {
    public static List<CompCostBean> calcCompCost(List<Object> contractIds) {
        if (EmptyUtil.isEmpty(contractIds)) {
            return new ArrayList<CompCostBean>(8);
        }
        Map<Long, BigDecimal> feeAmtMap = CompCostHelper.getContractFeeAmt(contractIds);
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id,payinterestamount,notpayinterestamount", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIds)}, (String)"");
        Map<Long, BigDecimal> intMap = contractBills.stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r.getBigDecimal("payinterestamount").add(r.getBigDecimal("notpayinterestamount")), (r1, r2) -> r1));
        if (EmptyUtil.isEmpty(intMap) || intMap.size() == 0) {
            return CompCostHelper.buildCompCostBeansFromMap(feeAmtMap);
        }
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>(feeAmtMap);
        intMap.forEach((k, v) -> resultMap.merge((Long)k, (BigDecimal)v, BigDecimal::add));
        return CompCostHelper.buildCompCostBeansFromMap(resultMap);
    }

    private static List<CompCostBean> buildCompCostBeansFromMap(Map<Long, BigDecimal> map) {
        if (EmptyUtil.isEmpty(map) || map.size() == 0) {
            return new ArrayList<CompCostBean>(8);
        }
        ArrayList<CompCostBean> resList = new ArrayList<CompCostBean>(map.size());
        for (Map.Entry<Long, BigDecimal> entry : map.entrySet()) {
            CompCostBean bean = new CompCostBean();
            bean.setBillId(entry.getKey());
            bean.setCostAmt(entry.getValue());
            resList.add(bean);
        }
        return resList;
    }

    public static List<CompCostRateBean> calcCompCostRate(List<CompCostBean> list) {
        if (EmptyUtil.isEmpty(list)) {
            return new ArrayList<CompCostRateBean>(8);
        }
        ArrayList<CompCostRateBean> resList = new ArrayList<CompCostRateBean>(list.size());
        Map<Long, BigDecimal> costMap = list.stream().collect(Collectors.toMap(r -> r.getBillId(), r -> r.getCostAmt(), (r1, r2) -> r1));
        Object[] contractBills = BusinessDataServiceHelper.load((String)"cfm_loancontractbill", (String)"id,basis,renewalexpiredate,enddate,startdate,amount,workcalendar,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", costMap.keySet())}, (String)"");
        if (EmptyUtil.isEmpty((Object[])contractBills)) {
            return resList;
        }
        for (Object contractBill : contractBills) {
            int diffDays;
            Date endDate = Optional.ofNullable(contractBill.getDate("renewalexpiredate")).orElseGet(() -> CompCostHelper.lambda$calcCompCostRate$7((DynamicObject)contractBill));
            Date startDate = contractBill.getDate("startdate");
            String basis = contractBill.getString("basis");
            BigDecimal debtAmt = contractBill.getBigDecimal("amount");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{endDate, startDate, basis, debtAmt})) continue;
            int yearDay = TermHelper.getBasis_YearDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)basis));
            DynamicObjectCollection workcalendar = contractBill.getDynamicObjectCollection("workcalendar");
            DynamicObject[] workCalArr = new DynamicObject[]{};
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)workcalendar)) {
                workCalArr = (DynamicObject[])workcalendar.toArray((Object[])new DynamicObject[0]);
            }
            if ((diffDays = TermHelper.getBasis_BetweenDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)basis), (DynamicObject[])workCalArr)) < 1) continue;
            Integer scale = Optional.ofNullable(contractBill.getDynamicObject("currency")).map(r -> r.getInt("amtprecision")).orElse(2);
            long contractId = contractBill.getLong("id");
            BigDecimal compCost = costMap.get(contractId);
            if (EmptyUtil.isEmpty((BigDecimal)compCost)) continue;
            BigDecimal costRate = compCost.multiply(new BigDecimal(yearDay)).multiply(new BigDecimal("100")).divide(debtAmt.multiply(new BigDecimal(diffDays)), (int)scale, 4);
            CompCostRateBean rateBean = new CompCostRateBean();
            rateBean.setBillId(Long.valueOf(contractId));
            rateBean.setRateAmt(costRate);
            resList.add(rateBean);
        }
        return resList;
    }

    public static Map<Long, BigDecimal> getContractFeeAmt(List<Object> idList) {
        HashMap<Long, BigDecimal> feeMap = new HashMap<Long, BigDecimal>(idList.size());
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "in", idList);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue()))));
        DataSet idMapDs = CompCostHelper.addFeeBilIdQfilter(idList, feeIdFilter);
        DataSet feeDs = QueryServiceHelper.queryDataSet((String)"", (String)"cfm_feebill", (String)"entry.srcbillid as srcbillid,entry.feedetailamt as feedetailamt,entry.excrate as excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter}, (String)"");
        if (feeDs.copy().isEmpty()) {
            return feeMap;
        }
        DataSet joinedDs = feeDs.leftJoin(idMapDs).on("srcbillid", "loanid").select(new String[]{"srcbillid", "feedetailamt", "excrate", "contractid"}).finish();
        DataSet contractFeeDs = joinedDs.copy().filter("contractid is null").select("srcbillid,feedetailamt*excrate as feeamt");
        DataSet loanFeeDs = joinedDs.copy().filter("contractid is not null").select("contractid as srcbillid, feedetailamt*excrate as feeamt");
        DataSet dealedDs = contractFeeDs.union(loanFeeDs);
        DataSet groupedDs = dealedDs.groupBy(new String[]{"srcbillid"}).sum("feeamt").finish();
        for (Row row : groupedDs) {
            feeMap.put(row.getLong("srcbillid"), row.getBigDecimal("feeamt"));
        }
        return feeMap;
    }

    private static DataSet addFeeBilIdQfilter(List<Object> idList, QFilter feeIdFilter) {
        RowMeta rowMeta = new RowMeta(new String[]{"loanid", "contractid"}, new DataType[]{DataType.LongType, DataType.LongType});
        DataSet dataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        Object[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", idList)});
        if (EmptyUtil.isNoEmpty((Object[])loanBills)) {
            List loanBillIds = Arrays.stream(loanBills).map(o -> o.getLong("id")).collect(Collectors.toList());
            feeIdFilter.or("entry.srcbillid", "in", loanBillIds);
            DataSetBuilder builder = Algo.create((String)"Loanid->Contractid").createDataSetBuilder(rowMeta);
            for (Object loanBill : loanBills) {
                Object[] row = new Object[]{loanBill.getLong("id"), loanBill.getLong("sourcebillid")};
                builder.append(row);
            }
            dataSet = builder.build();
        }
        return dataSet;
    }

    private static /* synthetic */ Date lambda$calcCompCostRate$7(DynamicObject contractBill) {
        return contractBill.getDate("enddate");
    }
}

