/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractApplyHelper {
    public static final String COLOR_GRID_COLOR = "rgba(200, 100, 60, .2)";
    private static final Log logger = LogFactory.getLog(ContractApplyHelper.class);
    public static final List<String> MODIFIABLE_HEAD_PROPS = new ArrayList<String>(8);
    public static final String[] REPAYMENT_BILL_PROPS;
    public static final String[] LOAN_BILL_PROPS;
    public static final String[] GUARANTEE_USE_PROPS;

    public static DynamicObject queryLoanContractBill(Object loanContractId, String props) {
        return BusinessDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)props, (QFilter[])new QFilter[]{new QFilter("id", "=", loanContractId)});
    }

    public static DynamicObject queryLoanContractBill(Object loanContractId) {
        return ContractApplyHelper.queryLoanContractBill("cfm_loancontractbill", loanContractId);
    }

    public static DynamicObject queryLoanContractBill(String entityName, Object loanContractId) {
        return BusinessDataServiceHelper.loadSingle((Object)loanContractId, (String)entityName);
    }

    public static DynamicObject[] queryRepaymentBills(List<Long> loanContractIds) {
        return ContractApplyHelper.queryRepaymentBills("cfm_repaymentbill", loanContractIds);
    }

    public static DynamicObject[] queryRepaymentBills(String entityName, List<Long> loanContractIds) {
        return BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", REPAYMENT_BILL_PROPS), (QFilter[])new QFilter[]{new QFilter("loancontractbill", "in", loanContractIds), new QFilter("confirmstatus", "=", (Object)"yetconfirm")});
    }

    public static DynamicObject[] queryLoanBills(Object loanContractId) {
        return ContractApplyHelper.queryLoanBills("cfm_loanbill", loanContractId);
    }

    public static DynamicObject[] queryLoanBills(String entityName, Object loanContractId) {
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])new QFilter[]{new QFilter("loancontractbill", "=", loanContractId)});
        return map.values().toArray(new DynamicObject[0]);
    }

    public static void assembleGuaranteeEntry(DynamicObject loanContractBill) {
        QFilter idFilter = new QFilter("gsrcbillid", "=", loanContractBill.getPkValue());
        Object[] gcBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcBills)) {
            return;
        }
        for (Object gcBIll : gcBills) {
            DynamicObject row = loanContractBill.getDynamicObjectCollection("entry_gcontract").addNew();
            row.set("gcontract", gcBIll.get("gcontract"));
            row.set("gamount", gcBIll.get("gamount"));
            row.set("gratio", gcBIll.get("gratio"));
            row.set("gexchrate", gcBIll.get("gexchrate"));
            row.set("gcomment", gcBIll.get("gcomment"));
            row.set("gsrcbillid", gcBIll.get("gsrcbillid"));
            row.set("gsrcbilltype", gcBIll.get("gsrcbilltype"));
            if (!GuaranteeUseHelper.getMultiCreditorFlag((String)loanContractBill.getDataEntityType().getName())) continue;
            row.set("gcreditortype", gcBIll.get("gcreditortype"));
            row.set("gcreditor", gcBIll.get("gcreditor"));
            row.set("gcreditortext", gcBIll.get("gcreditortext"));
        }
    }

    public static Map<String, List<Object>> guaranteeEntriesDiffering(Map<String, Object> leftObjMap, Map<String, Object> rightObjMap) {
        return DynamicObjectCompareHelper.entriesDiffering(ContractApplyHelper.getModifyGuaranteeUseMap(leftObjMap), ContractApplyHelper.getModifyGuaranteeUseMap(rightObjMap));
    }

    public static Map<String, List<Object>> projectEntriesDiffering(Map<String, Object> leftObjMap, Map<String, Object> rightObjMap) {
        Map<String, Object> leftMap = ContractApplyHelper.getModifyProjectMap(leftObjMap);
        Map<String, Object> rightMap = ContractApplyHelper.getModifyProjectMap(rightObjMap);
        return DynamicObjectCompareHelper.entriesDiffering(leftMap, rightMap);
    }

    public static Map<String, Object> getModifyGuaranteeUseMap(Map<String, Object> guaranteeMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("gcontract", guaranteeMap.get("gcontract"));
        resultMap.put("gamount", guaranteeMap.get("gamount"));
        resultMap.put("gratio", guaranteeMap.get("gratio"));
        resultMap.put("gexchrate", guaranteeMap.get("gexchrate"));
        resultMap.put("gcomment", guaranteeMap.get("gcomment"));
        resultMap.put("gsrcbillid", guaranteeMap.get("gsrcbillid"));
        return resultMap;
    }

    public static Map<String, Object> getModifyProjectMap(Map<String, Object> projectMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("e_project", projectMap.get("e_project"));
        resultMap.put("e_projectname", projectMap.get("e_projectname"));
        resultMap.put("e_projdescription", projectMap.get("e_projdescription"));
        return resultMap;
    }

    public static void updateContractInfo(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> loanContractBillList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> loanBillList = new ArrayList<DynamicObject>(8);
        for (DynamicObject applyBill : dataEntities) {
            DynamicObject[] loanBills;
            String contractName;
            String entityName;
            DynamicObject loanContractF7 = applyBill.getDynamicObject("loancontractbill");
            switch (entityName = applyBill.getDynamicObjectType().getName()) {
                case "fl_contract_apply": {
                    contractName = "fl_leasecontractbill";
                    break;
                }
                case "cim_contract_apply": {
                    contractName = "cim_invest_contract";
                    break;
                }
                default: {
                    contractName = "cfm_loancontractbill";
                }
            }
            DynamicObject loanContractBill = ContractApplyHelper.queryLoanContractBill(contractName, loanContractF7.getPkValue());
            loanContractBill.set("contractstatus", (Object)ContractStatusEnum.EXECUTING.getValue());
            ContractApplyHelper.assembleGuaranteeEntry(loanContractBill);
            ContractApplyHelper.saveHistory(loanContractBill, applyBill);
            ContractApplyHelper.copyValue(applyBill, loanContractBill);
            applyBill.set("bizstatus", (Object)ApplyBizStatusEnum.DONE.getValue());
            applyBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            loanContractBillList.add(loanContractBill);
            String loanBillName = entityName.equals("fl_contract_apply") ? "fl_receiptbill" : "cfm_loanbill";
            for (DynamicObject loanBill : loanBills = ContractApplyHelper.queryLoanBills(loanBillName, loanContractF7.getPkValue())) {
                ContractApplyHelper.copyGuaranteeEntry(applyBill.getDynamicObjectCollection("entry_gcontract"), loanBill);
                loanBillList.add(loanBill);
            }
            ContractApplyHelper.addAttachment(applyBill, loanContractBill, contractName);
        }
        logger.info("loanContractBillList:size->" + loanContractBillList.size() + "  " + ((Object)loanContractBillList).toString());
        if (EmptyUtil.isEmpty(loanBillList)) {
            return;
        }
        DynamicObject[] loanContractBills = loanContractBillList.toArray(new DynamicObject[loanContractBillList.size()]);
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])loanContractBills, (String[])new String[]{LoanTypeEnum.isBankLoan(loanContractBills[0].getString("loantype")) || LoanTypeEnum.isBanksLoan(loanContractBills[0].getString("loantype")) ? "cfm_loancontract_bl_l" : null});
        SaveServiceHelper.save((DynamicObject[])loanContractBills);
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])loanBillList.toArray(new DynamicObject[0]), (String[])new String[0]);
        List idList = loanBillList.stream().filter(o -> BillStatusEnum.SUBMIT.getValue().equals(o.getString("billstatus")) || BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toList());
        GuaranteeUseHelper.confirmGuaranteeUse(idList);
        String payBillName = dataEntities[0].getDynamicObjectType().getName().equals("fl_contract_apply") ? "fl_rentpaybill" : "cfm_repaymentbill";
        Object[] repaymentBills = ContractApplyHelper.queryRepaymentBills(payBillName, loanContractBillList.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        if (EmptyUtil.isNoEmpty((Object[])repaymentBills)) {
            RepaymentbillHelper.returnGuaranteeUse((DynamicObject[])repaymentBills);
        }
    }

    public static void copyGuaranteeEntry(DynamicObjectCollection gcEntry, DynamicObject loanBill) {
        DynamicObjectCollection creditLimitGcBills;
        BigDecimal ratio = BigDecimal.ZERO;
        Set<Object> creditLimitIdSet = new HashSet<Object>(8);
        if (loanBill.get("creditlimit") != null) {
            creditLimitIdSet.add(loanBill.getDynamicObject("creditlimit").getPkValue());
        } else {
            creditLimitIdSet = loanBill.getDynamicObjectCollection("banksyndicate_entry").stream().filter(f -> EmptyUtil.isNoEmpty((DynamicObject)f.getDynamicObject("e_bankcreditlimit"))).map(v -> v.getDynamicObject("e_bankcreditlimit").getPkValue()).collect(Collectors.toSet());
        }
        if (!creditLimitIdSet.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(creditLimitGcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])new QFilter("gsrcbillid", "in", creditLimitIdSet).toArray())))) {
            DynamicObject[] loanBillGcBills;
            QFilter filter = new QFilter("gsrcbillid", "=", loanBill.getPkValue()).and("gcontract", "in", creditLimitGcBills.stream().map(o -> o.get("gcontract")).collect(Collectors.toSet()));
            for (DynamicObject sourceRow : loanBillGcBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])filter.toArray())) {
                DynamicObject targetRow = loanBill.getDynamicObjectCollection("entry_gcontract").addNew();
                targetRow.set("gcontract", sourceRow.get("gcontract"));
                targetRow.set("gratio", sourceRow.get("gratio"));
                targetRow.set("gamount", sourceRow.get("gamount"));
                targetRow.set("gexchrate", sourceRow.get("gexchrate"));
                targetRow.set("gcomment", sourceRow.get("gcomment"));
                if (GuaranteeUseHelper.getMultiCreditorFlag((String)loanBill.getDataEntityType().getName())) {
                    targetRow.set("gcreditortype", sourceRow.get("gcreditortype"));
                    targetRow.set("gcreditor", sourceRow.get("gcreditor"));
                    targetRow.set("gcreditortext", sourceRow.get("gcreditortext"));
                }
                ratio = ratio.add(sourceRow.getBigDecimal("gratio"));
            }
        }
        TreeMap<String, ArrayList<DynamicObject>> sumGcMap = new TreeMap<String, ArrayList<DynamicObject>>();
        String creditorType = loanBill.getString("creditortype");
        Long creditor = loanBill.getLong("creditor");
        for (DynamicObject gc : gcEntry) {
            ArrayList<DynamicObject> gcTemp;
            if (GuaranteeUseHelper.getMultiCreditorFlag((String)loanBill.getDataEntityType().getName())) {
                creditorType = gc.getString("gcreditortype");
                creditor = gc.getLong("gcreditor");
            }
            if ((gcTemp = (ArrayList<DynamicObject>)sumGcMap.get(creditorType + creditor)) == null) {
                gcTemp = new ArrayList<DynamicObject>(gcEntry.size());
            }
            gcTemp.add(gc);
            sumGcMap.put(creditorType + creditor, gcTemp);
        }
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)loanBill.getDataEntityType().getName(), (DynamicObject)loanBill);
        BigDecimal bizAmount = loanBill.getBigDecimal("drawamount");
        DynamicObject currency = loanBill.getDynamicObject("currency");
        for (Map.Entry entry : sumGcMap.entrySet()) {
            List gcsList = (List)entry.getValue();
            if (EmptyUtil.isEmpty((Collection)gcsList)) continue;
            bizAmount = bizAmountMap.containsKey(entry.getKey()) ? (BigDecimal)bizAmountMap.get(entry.getKey()) : bizAmount;
            BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (int i = 0; i < gcsList.size(); ++i) {
                BigDecimal gAmount;
                DynamicObject sourceRow = (DynamicObject)gcsList.get(i);
                BigDecimal rowRatio = sourceRow.getBigDecimal("gratio");
                DynamicObject targetRow = loanBill.getDynamicObjectCollection("entry_gcontract").addNew();
                targetRow.set("gcontract", sourceRow.get("gcontract"));
                targetRow.set("gratio", (Object)rowRatio);
                if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                    gAmount = bizAmount.subtract(sumAmount);
                } else {
                    gAmount = bizAmount.multiply(rowRatio).divide(Constants.ONE_HUNDRED, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(gAmount);
                }
                targetRow.set("gamount", (Object)gAmount);
                targetRow.set("gcontractamount", sourceRow.get("gcontractamount"));
                targetRow.set("gcontractcurrency", sourceRow.get("gcontractcurrency"));
                targetRow.set("gexchrate", sourceRow.get("gexchrate"));
                targetRow.set("gcomment", sourceRow.get("gcomment"));
                if (!GuaranteeUseHelper.getMultiCreditorFlag((String)loanBill.getDataEntityType().getName())) continue;
                targetRow.set("gcreditortype", sourceRow.get("gcreditortype"));
                targetRow.set("gcreditor", sourceRow.get("gcreditor"));
                targetRow.set("gcreditortext", sourceRow.get("gcreditortext"));
            }
        }
    }

    public static void copyValue(DynamicObject applyBill, DynamicObject loanContractBill) {
        DynamicObject targetRow;
        for (String prop : MODIFIABLE_HEAD_PROPS) {
            loanContractBill.set(prop, applyBill.get(prop));
        }
        loanContractBill.getDynamicObjectCollection("entry_gcontract").clear();
        for (DynamicObject sourceRow : applyBill.getDynamicObjectCollection("entry_gcontract")) {
            targetRow = loanContractBill.getDynamicObjectCollection("entry_gcontract").addNew();
            targetRow.set("gcontract", sourceRow.get("gcontract"));
            targetRow.set("gratio", sourceRow.get("gratio"));
            targetRow.set("gamount", sourceRow.get("gamount"));
            targetRow.set("gcontractamount", sourceRow.get("gcontractamount"));
            targetRow.set("gcontractcurrency", sourceRow.get("gcontractcurrency"));
            targetRow.set("gexchrate", sourceRow.get("gexchrate"));
            targetRow.set("gcomment", sourceRow.get("gcomment"));
            if (!GuaranteeUseHelper.getMultiCreditorFlag((String)loanContractBill.getDataEntityType().getName())) continue;
            targetRow.set("gcreditortype", sourceRow.get("gcreditortype"));
            targetRow.set("gcreditor", sourceRow.get("gcreditor"));
            targetRow.set("gcreditortext", sourceRow.get("gcreditortext"));
        }
        loanContractBill.getDynamicObjectCollection("project_entry").clear();
        for (DynamicObject sourceRow : applyBill.getDynamicObjectCollection("project_entry")) {
            targetRow = loanContractBill.getDynamicObjectCollection("project_entry").addNew();
            targetRow.set("e_project", sourceRow.get("e_project"));
            targetRow.set("e_projdescription", sourceRow.get("e_projdescription"));
        }
    }

    public static void saveHistory(DynamicObject loanContractBill, DynamicObject applyBill) {
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)applyBill.getPkValue()), (String)applyBill.getDataEntityType().getName(), (String)applyBill.getString("billno"), (String)"", (String)loanContractBill.getString("billno"), (DynamicObject)loanContractBill);
    }

    public static void showChangePropForFormView(DynamicObject lastBill, DynamicObject nextBill, IFormView formView) {
        Map<String, Object> nextDataMap;
        Map<String, Object> lastDataMap = ContractApplyHelper.getModifyProperties(lastBill);
        Map entriesDiffering = DynamicObjectCompareHelper.entriesDiffering(lastDataMap, nextDataMap = ContractApplyHelper.getModifyProperties(nextBill));
        if (CollectionUtils.isEmpty((Map)entriesDiffering)) {
            return;
        }
        for (Map.Entry entry : entriesDiffering.entrySet()) {
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("fc", "#ED9121");
            formView.updateControlMetadata((String)entry.getKey(), fieldMap);
        }
    }

    public static Map<String, Object> getModifyProperties(DynamicObject dynamicObject) {
        HashMap<String, Object> modifyMap = new HashMap<String, Object>(8);
        List<String> pros = Arrays.asList("accountbank", "loaneracctbank", "interestsettledplan");
        for (String pro : MODIFIABLE_HEAD_PROPS) {
            if (!dynamicObject.containsProperty(pro)) continue;
            String value = pros.contains(pro) ? (EmptyUtil.isEmpty((Object)dynamicObject.get(pro)) ? null : dynamicObject.getDynamicObject(pro).getString("id")) : (pro.equals("guarantee") ? String.valueOf(dynamicObject.get(pro)).replace(",", "") : (EmptyUtil.isEmpty((Object)dynamicObject.get(pro)) ? null : String.valueOf(dynamicObject.get(pro))));
            modifyMap.put(pro, value);
        }
        return modifyMap;
    }

    public static void setGridBackgroundColor(EntryGrid entryGrid, int[] row) {
        entryGrid.setRowBackcolor(COLOR_GRID_COLOR, row);
    }

    public static void setGridBackgroundColor(EntryGrid entryGrid, int row) {
        ContractApplyHelper.setGridBackgroundColor(entryGrid, new int[]{row});
    }

    public static CellStyle buildCellStyle(String propertyName, int index) {
        CellStyle style = new CellStyle();
        style.setFieldKey(propertyName);
        style.setRow(index);
        style.setBackColor(COLOR_GRID_COLOR);
        return style;
    }

    private static void addAttachment(DynamicObject applyBill, DynamicObject loanContractBill, String contractName) {
        TmcAttachmentHelper.setAttachments((DynamicObject)applyBill, (String)contractName, (Long)loanContractBill.getLong("id"), (String)"attachmentpanel", (String)"attachmentpanel");
        String oppositeEntity = TmcAttachmentHelper.getOppositeEntity((DynamicObject)applyBill, (String)applyBill.getDynamicObjectType().getName());
        if (EmptyUtil.isNoEmpty((String)oppositeEntity) && !oppositeEntity.equals(contractName)) {
            TmcAttachmentHelper.setAttachments((DynamicObject)applyBill, (String)oppositeEntity, (Long)loanContractBill.getLong("id"), (String)"attachmentpanel", (String)"attachmentpanel");
        }
    }

    static {
        MODIFIABLE_HEAD_PROPS.add("contractno");
        MODIFIABLE_HEAD_PROPS.add("contractname");
        MODIFIABLE_HEAD_PROPS.add("accountbank");
        MODIFIABLE_HEAD_PROPS.add("loaneracctbank");
        MODIFIABLE_HEAD_PROPS.add("guarantee");
        MODIFIABLE_HEAD_PROPS.add("region");
        MODIFIABLE_HEAD_PROPS.add("confirmdescription");
        MODIFIABLE_HEAD_PROPS.add("description");
        MODIFIABLE_HEAD_PROPS.add("interestsettledplan");
        MODIFIABLE_HEAD_PROPS.add("repaymentway");
        MODIFIABLE_HEAD_PROPS.add("stageplan");
        MODIFIABLE_HEAD_PROPS.add("settleintmode");
        REPAYMENT_BILL_PROPS = new String[]{"datasource", "amount", "e_loanbill", "e_repayamount", "slentryentity", "slentryentity.s_bankrole", "slentryentity.s_bank", "slentryentity.s_repayamount", "slentryentity.s_loanbillno"};
        LOAN_BILL_PROPS = new String[]{"drawamount", "billstatus", "loancontractbill", "billno", "currency", "bizdate", "textcreditor", "expiredate", "creditlimit", "org", "gcontract", "gratio", "gamount", "gcontractamount", "gcontractcurrency", "gexchrate", "gcomment"};
        GUARANTEE_USE_PROPS = new String[]{"gcontract", "gamount", "gratio", "gexchrate", "gcomment", "gsrcbillid", "gsrcbilltype", "gcreditortype", "gcreditor", "gcreditortext"};
    }
}

