/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditUseHelper {
    public static void autoUseCreditLimit(DynamicObject bill, boolean isForceCreate, boolean isPreOcupty) {
        QFilter filter = new QFilter("sourcebillid", "=", bill.get("id"));
        DynamicObject creditLimit = bill.getDynamicObject("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            filter.and(new QFilter("creditlimit", "=", creditLimit.getPkValue()));
        }
        filter.and(new QFilter("returnamt", "=", (Object)Constants.ZERO));
        if (!TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])filter.toArray()) || isForceCreate) {
            CreditLimitUseBean useBean = CreditUseHelper.getCreditLimitUseInfo(bill);
            useBean.setCreditLimitNo(creditLimit.getString("number"));
            useBean.setPreOccupy(Boolean.valueOf(isPreOcupty));
            CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
        }
    }

    private static CreditLimitUseBean getCreditLimitUseInfo(DynamicObject bill) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId((Long)bill.getDynamicObject("org").getPkValue());
        if (bill.getDynamicObjectType().getProperty("creditor") instanceof BasedataProp) {
            useBean.setFinOrgId((Long)bill.getDynamicObject("creditor").getPkValue());
        } else {
            useBean.setFinOrgId(Long.valueOf(bill.getLong("creditor")));
        }
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        useBean.setStartDate(bill.getDate("cfm_loanbill".equals(bill.getDynamicObjectType().getName()) ? "bizdate" : "startdate"));
        useBean.setEndDate(bill.getDate("cfm_loanbill".equals(bill.getDynamicObjectType().getName()) ? "expiredate" : "enddate"));
        useBean.setCreditTypeId(CreditUseHelper.getCreditTypeId(bill));
        useBean.setCreditVariety(CreditUseHelper.getCreditVariety(bill));
        useBean.setCreditRatio(CreditUseHelper.getCreditRatio(bill));
        String amt = "cfm_loanbill".equals(bill.getDynamicObjectType().getName()) ? "drawamount" : "amount";
        useBean.setMaxAmt(bill.getBigDecimal(amt));
        useBean.setBizAmt(bill.getBigDecimal(amt));
        DynamicObject creditLimit = bill.getDynamicObject("creditlimit");
        useBean.setCreditLimitId((Long)creditLimit.getPkValue());
        return useBean;
    }

    private static String getCreditVariety(DynamicObject bill) {
        DynamicObject finProduct = bill.getDynamicObject("finproduct");
        return finProduct.getString("name");
    }

    private static Long getCreditTypeId(DynamicObject bill) {
        DynamicObject finProduct = bill.getDynamicObject("finproduct");
        return CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)finProduct.getPkValue());
    }

    private static BigDecimal getCreditRatio(DynamicObject bill) {
        DynamicObject creditUseBill;
        if (EmptyUtil.isNoEmpty((String)bill.getDynamicObjectType().getName()) && (creditUseBill = CreditLimitHelper.getCreditUseBill(bill.getLong("id"), bill.getDynamicObjectType().getName())) != null) {
            return creditUseBill.getBigDecimal("creditratio");
        }
        return Constants.ONE_HUNDRED;
    }

    public static DynamicObjectCollection getCreditUses(long sourceBillId, long sourcebillEntryId, String sels) {
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId).and(new QFilter("isrelease", "=", (Object)"0")).and(new QFilter("creditlimit.isclose", "=", (Object)"0"));
        if (EmptyUtil.isNoEmpty((Long)sourcebillEntryId)) {
            qFilter.and(new QFilter("sourcebillentryid", "=", (Object)sourcebillEntryId));
        }
        return QueryServiceHelper.query((String)"cfm_credituse", (String)sels, (QFilter[])new QFilter[]{qFilter});
    }
}

