/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ContractExtendStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ExtendHelper {
    private static String[] SELECT_PPOPS = new String[]{"renewalexpiredate", "createtime", "loanbilllist.drawbillid", "loanbilllist.lrenewalexpiredate", "loanbilllist.isrenewal"};

    public static Pair<Boolean, String> isExtendAllowed(DynamicObject billDO, String billType) {
        int count;
        Object renewalLimitObj;
        int ongoningBillCount;
        DynamicObject pf = billDO.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)pf) && !pf.getBoolean("iscandefer")) {
            String msg = ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0d\u5141\u8bb8\u5c55\u671f\u3002", (String)"ExtendHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]);
            if ("bond".equals(billDO.getString("loantype"))) {
                msg = ResManager.loadKDString((String)"\u8be5\u53d1\u884c\u8ba1\u5212\u7684\u53d1\u503a\u6a21\u578b\u4e0d\u5141\u8bb8\u5c55\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ExtendHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]);
            }
            return Pair.of((Object)Boolean.FALSE, (Object)msg);
        }
        Long contractId = null;
        Long extendBillId = null;
        if ("contract".equals(billType)) {
            if (billDO.getDynamicObjectType().getProperties().containsKey((Object)"isnofixedterm") && billDO.getBoolean("isnofixedterm")) {
                return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u65e0\u56fa\u5b9a\u671f\u9650,\u4e0d\u5141\u8bb8\u5c55\u671f\u3002", (String)"ExtendHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]));
            }
            contractId = (Long)billDO.getPkValue();
        } else {
            contractId = billDO.getLong("sourcebillid");
            extendBillId = (Long)billDO.getPkValue();
        }
        QFilter conFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        QFilter extendBillQF = new QFilter("billstatus", "in", (Object)new Object[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()});
        QFilter unconfirmStatus = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        unconfirmStatus.and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
        extendBillQF = extendBillQF.or(unconfirmStatus);
        extendBillQF = extendBillQF.and(conFilter);
        QFilter excludeQF = null;
        if (extendBillId != null) {
            excludeQF = new QFilter("id", "!=", (Object)extendBillId);
            extendBillQF = extendBillQF.and(excludeQF);
        }
        if ((ongoningBillCount = TmcDataServiceHelper.count((String)"cfm_contractextendbill", (QFilter[])extendBillQF.toArray())) > 0) {
            return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5728\u9014\u5c55\u671f\u5355,\u8bf7\u5148\u5b8c\u6210\u5728\u9014\u5c55\u671f\u3002", (String)"ExtendHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
        int renewalLimit = 99;
        if (EmptyUtil.isNoEmpty((DynamicObject)pf) && (renewalLimitObj = pf.get("defermaxcount")) != null) {
            renewalLimit = (Integer)renewalLimitObj;
        }
        if (excludeQF != null) {
            conFilter = conFilter.and(excludeQF);
        }
        if ((count = TmcDataServiceHelper.count((String)"cfm_contractextendbill", (QFilter[])conFilter.toArray())) >= renewalLimit) {
            return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8be5\u5408\u540c\u7684\u5c55\u671f\u6b21\u6570\u5df2\u7b49\u4e8e\u6240\u9009\u878d\u8d44\u6a21\u578b\u7684\u5c55\u671f\u6700\u5927\u6b21\u6570\u3002", (String)"ExtendHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public static Pair<Boolean, String> isExtendAllowed(DynamicObject contractDO) {
        return ExtendHelper.isExtendAllowed(contractDO, "contract");
    }

    public static boolean isTheLatestExtendBill(DynamicObject extendBill) {
        Long contractId = extendBill.getLong("sourcebillid");
        QFilter cQFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        cQFilter.and(new QFilter("id", "!=", extendBill.getPkValue()));
        cQFilter.and(new QFilter("createtime", ">", extendBill.get("createtime")));
        int cntOfExtendBills = TmcDataServiceHelper.count((String)"cfm_contractextendbill", (QFilter[])cQFilter.toArray());
        return cntOfExtendBills <= 0;
    }

    public static void doExtend(DynamicObject extendBill) {
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)extendBill.get("sourcebillid"), (String)"cfm_loancontractbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)contractBill)) {
            HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
            ArrayList<Long> pkList = new ArrayList<Long>();
            contractBill.set("extendstatus", (Object)ContractExtendStatusEnum.AUDIT.getValue());
            contractBill.set("isextend", (Object)true);
            contractBill.set("renewalexpiredate", (Object)extendBill.getDate("renewalexpiredate"));
            SaveServiceHelper.save((IDataEntityType)contractBill.getDataEntityType(), (Object[])new DynamicObject[]{contractBill});
            DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                return;
            }
            for (DynamicObject entry : entrys) {
                if (!entry.getBoolean("isrenewal")) continue;
                entryMap.put(entry.getLong("drawbillid"), entry);
                pkList.add(entry.getLong("drawbillid"));
            }
            Object[] loanBills = TmcDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"));
            if (EmptyUtil.isNoEmpty((Object[])loanBills)) {
                for (Object loanBill : loanBills) {
                    DynamicObject entry = (DynamicObject)entryMap.get(loanBill.getPkValue());
                    loanBill.set("renewalexpiredate", entry.get("lrenewalexpiredate"));
                }
                SaveServiceHelper.save((IDataEntityType)loanBills[0].getDataEntityType(), (Object[])loanBills);
            }
        }
    }

    public static void undoExtend(DynamicObject extendBill) {
        Object[] loanBills;
        Long contractId = extendBill.getLong("sourcebillid");
        QFilter cQFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        cQFilter.and(new QFilter("id", "!=", extendBill.getPkValue()));
        cQFilter.and(new QFilter("createtime", "<", extendBill.get("createtime")));
        Object[] hisExtendBills = TmcDataServiceHelper.load((String)"cfm_contractextendbill", (String)String.join((CharSequence)",", SELECT_PPOPS), (QFilter[])cQFilter.toArray(), (String)"createtime desc");
        String extendStatus = ContractExtendStatusEnum.SAVE.getValue();
        boolean isExtend = false;
        Date previousRenewalDate = null;
        if (EmptyUtil.isNoEmpty((Object[])hisExtendBills)) {
            previousRenewalDate = hisExtendBills[0].getDate("renewalexpiredate");
            extendStatus = ContractExtendStatusEnum.AUDIT.getValue();
            isExtend = true;
        }
        DynamicObject contactDO = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill");
        contactDO.set("renewalexpiredate", (Object)previousRenewalDate);
        contactDO.set("isextend", (Object)isExtend);
        contactDO.set("extendstatus", (Object)extendStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contactDO});
        DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(entrys.size());
        for (Object[] entry : entrys) {
            if (!entry.getBoolean("isrenewal")) continue;
            pkList.add(entry.getLong("drawbillid"));
        }
        HashMap<Long, Date> loanBillRenewalDateMap = new HashMap<Long, Date>();
        if (EmptyUtil.isNoEmpty((Object[])hisExtendBills)) {
            for (Object hisExtendBill : hisExtendBills) {
                DynamicObjectCollection hisLoanbillEntrys = hisExtendBill.getDynamicObjectCollection("loanbilllist");
                for (DynamicObject hisLoanbillEntry : hisLoanbillEntrys) {
                    if (!hisLoanbillEntry.getBoolean("isrenewal")) continue;
                    loanBillRenewalDateMap.putIfAbsent(hisLoanbillEntry.getLong("drawbillid"), hisLoanbillEntry.getDate("lrenewalexpiredate"));
                }
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])(loanBills = TmcDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"))))) {
            for (Object loanBill : loanBills) {
                Date prevRenewalExpiredate = loanBillRenewalDateMap.getOrDefault(loanBill.getPkValue(), null);
                loanBill.set("renewalexpiredate", (Object)prevRenewalExpiredate);
            }
            SaveServiceHelper.save((DynamicObject[])loanBills);
        }
    }
}

