/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestServiceHelper {
    private static final String REPAYMENT_BILL_PROP = "isrelcash,amount,totalamt,loans,e_loanbill,e_actintamt,e_convertactintamt,e_ispayinst,e_combineinst,needpayamt,issuretyrepay,entry_surety,entry_surety.suretyrepayamt,slentryentity.s_loanbillno,slentryentity.s_bank,slentryentity.s_repayinst, loans.convertrate";

    public static List<String> getAuditSelector() {
        ArrayList<String> ias = new ArrayList<String>(20);
        ias.add("sourcebillid");
        ias.add("billno");
        ias.add("billstatus");
        ias.add("repaymentid");
        ias.add("actualinstamt");
        ias.add("startinstdate");
        ias.add("bizdate");
        ias.add("bechargeinstamt");
        ias.add("afterchargeinstamt");
        ias.add("instbillctg");
        ias.add("endinstdate");
        ias.add("confirmstatus");
        ias.add("lendernature");
        ias.add("datasource");
        ias.add("creditorg");
        ias.add("org");
        ias.add("confirmer");
        ias.add("confirmtime");
        ias.add("loaneracctbank");
        ias.add("instbankacct");
        ias.add("datasource");
        ias.add("auditdate");
        ias.add("auditor");
        ias.add("modifier");
        ias.add("modifytime");
        ias.add("loantype");
        ias.add("settlestatus");
        ias.add("creditortype");
        ias.add("loanbillno");
        ias.add("actualinstamt");
        ias.add("instbillctg");
        ias.add("repaymentid");
        ias.add("sourcebillid");
        ias.add("convertintamt");
        return ias;
    }

    public static void confirmProcess(DynamicObject interestEntity) {
        BusinessHelper.fillConfirmInfo(interestEntity);
    }

    public static void writeBackRePayment(DynamicObject[] intBills) {
        Object[] rePaymentIds = Arrays.stream(intBills).filter(v -> StringUtils.equals((CharSequence)v.getString("instbillctg"), (CharSequence)InterestbillctgEnum.PAYPRINANDINTE.getValue())).filter(r -> EmptyUtil.isNoEmpty((Object)r.get("sourcebillid"))).map(v -> v.get("repaymentid")).filter(EmptyUtil::isNoEmpty).toArray();
        if (EmptyUtil.isEmpty((Object[])rePaymentIds)) {
            return;
        }
        DynamicObject[] repayments = TmcDataServiceHelper.load((String)"cfm_repaymentbill", (String)REPAYMENT_BILL_PROP, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)rePaymentIds)});
        Map repaymentMap = Arrays.stream(repayments).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        for (DynamicObject intBill : intBills) {
            DynamicObject repayment;
            String instBillCtg = intBill.getString("instbillctg");
            Object rePaymentId = intBill.get("repaymentid");
            Object loanBillId = intBill.get("sourcebillid");
            if (EmptyUtil.isEmpty((Object)loanBillId) || !StringUtils.equals((CharSequence)instBillCtg, (CharSequence)InterestbillctgEnum.PAYPRINANDINTE.getValue()) || EmptyUtil.isEmpty((Object)rePaymentId) || (repayment = (DynamicObject)repaymentMap.get(rePaymentId)) == null) continue;
            DynamicObjectCollection loans = repayment.getDynamicObjectCollection("loans");
            for (DynamicObject loan : loans) {
                if (!loan.getDynamicObject("e_loanbill").getPkValue().equals(loanBillId)) continue;
                BigDecimal actualInstAmt = intBill.getBigDecimal("actualinstamt");
                BigDecimal totalAmt = repayment.getBigDecimal("totalamt").subtract(loan.getBigDecimal("e_actintamt")).add(actualInstAmt);
                repayment.set("totalamt", (Object)totalAmt);
                loan.set("e_actintamt", (Object)actualInstAmt);
                BigDecimal convertRate = loan.getBigDecimal("convertrate");
                convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
                loan.set("e_convertactintamt", (Object)actualInstAmt.multiply(convertRate));
                break;
            }
            CfmBillCommonHelper.setNeedPayAmt(repayment, true);
            DynamicObjectCollection intSlEntrys = intBill.getDynamicObjectCollection("slentryentity");
            DynamicObjectCollection repaySlEntrys = repayment.getDynamicObjectCollection("slentryentity");
            InterestServiceHelper.updateSlentry(intSlEntrys, repaySlEntrys);
        }
        SaveServiceHelper.update((DynamicObject[])repayments);
    }

    public static void updatePayIntAcct(DynamicObject interestBill, DynamicObject repaymentBill) {
        Object loanerAcctBank = repaymentBill.get("loaneracctbank");
        if (EmptyUtil.isNoEmpty((Object)loanerAcctBank)) {
            interestBill.set("loaneracctbank", loanerAcctBank);
        }
    }

    private static void updateSlentry(DynamicObjectCollection intSlEntrys, DynamicObjectCollection repaySlEntrys) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)intSlEntrys) || EmptyUtil.isEmpty((DynamicObjectCollection)repaySlEntrys)) {
            return;
        }
        DynamicObject intSlEntry = (DynamicObject)intSlEntrys.get(0);
        Map<Long, BigDecimal> intAmountMap = intSlEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.toMap(o -> o.getDynamicObject("s_bank").getLong("id"), o -> o.getBigDecimal("s_repayinst"), (v1, v2) -> v2));
        List slEntrys = repaySlEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == intSlEntry.getDynamicObject("s_loanbillno").getLong("id")).collect(Collectors.toList());
        for (DynamicObject slEntry : slEntrys) {
            DynamicObject bank = slEntry.getDynamicObject("s_bank");
            if (EmptyUtil.isEmpty((DynamicObject)bank)) continue;
            BigDecimal intAmount = intAmountMap.get(bank.getLong("id"));
            slEntry.set("s_repayinst", (Object)intAmount);
        }
    }
}

