/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.constant.CfmBizConstant;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.cfm.common.helper.ProductFactoryHelper;
import kd.tmc.cfm.common.repository.LoanContractBillRepository;
import kd.tmc.cfm.common.repository.PreInterestBillRepository;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.enums.RateCycleWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.WorkCalendarAdjustParam;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillHelper {
    private static final Log logger = LogFactory.getLog(LoanBillHelper.class);

    public static boolean isLoanBillBondAndPerpetual(DynamicObject finProduct) {
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            return false;
        }
        return finProduct.getBoolean("perpetualbond");
    }

    public static boolean isSofrRate(DynamicObject loanBill) {
        return loanBill.getBoolean("issofrrate");
    }

    public static boolean isSofr(DynamicObject loanBill) {
        boolean isSofrRate = loanBill.getBoolean("issofrrate");
        boolean isCallCompInt = loanBill.getBoolean("iscallcompint");
        return isSofrRate && isCallCompInt;
    }

    public static boolean isObserve(DynamicObject loanBill) {
        return ProductFactoryHelper.isObserve(loanBill.getDynamicObject("productfactory"));
    }

    @Deprecated
    public static boolean isPostposition(DynamicObject loanBill) {
        return LoanBillHelper.isSofr(loanBill);
    }

    public static BigDecimal calLockInAmout(Long loanBillId) {
        return RepaymentBillRepository.getLockInAmout(loanBillId);
    }

    public static BigDecimal getNotDrawAmount(long loanContractId, BigDecimal convertRate, int scale) {
        Map<Long, ContractBillAmountSumDTO> canDrawAmountMap = LoanContractBillRepository.getContractBillDrawAmountSum(Collections.singletonList(loanContractId));
        ContractBillAmountSumDTO amountSumDTO = canDrawAmountMap.get(loanContractId);
        BigDecimal notDrawAmount = amountSumDTO.getUnDrawAmt();
        if (convertRate.compareTo(BigDecimal.ZERO) > 0) {
            notDrawAmount = notDrawAmount.divide(convertRate, scale, RoundingMode.HALF_UP);
        }
        return notDrawAmount;
    }

    public static WorkCalendarAdjustParam buildWorkCalendarAdjustParam(DynamicObject loanBill, String adjustRulePropName) {
        String payIntRule = null;
        DynamicObject contratBill = loanBill.getDynamicObject("loancontractbill");
        if (loanBill.containsProperty(adjustRulePropName)) {
            payIntRule = loanBill.getString(adjustRulePropName);
        } else if (contratBill != null && contratBill.containsProperty(adjustRulePropName)) {
            payIntRule = contratBill.getString(adjustRulePropName);
        }
        if (EmptyUtil.isEmpty((String)payIntRule)) {
            return WorkCalendarAdjustParam.build(null, (AdjustMethodEnum)AdjustMethodEnum.no_adjust);
        }
        DynamicObjectCollection workCalendars = null;
        if (loanBill.containsProperty("workcalendar")) {
            workCalendars = loanBill.getDynamicObjectCollection("workcalendar");
        } else if (contratBill != null && contratBill.containsProperty("workcalendar")) {
            workCalendars = contratBill.getDynamicObjectCollection("workcalendar");
        }
        RateCycleWayEnum rateCycleWay = RateCycleWayEnum.FixDate;
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            rateCycleWay = RateCycleWayEnum.getEnumByValue((String)productFactory.getString("ratecycleway"));
        }
        return WorkCalendarAdjustParam.build((DynamicObjectCollection)workCalendars, (AdjustMethodEnum)AdjustMethodEnum.getEnumByValue((String)payIntRule)).setRateCycleWay(rateCycleWay);
    }

    public static void autoWriteOff(DynamicObject intBill, String settleInfoStr) {
        if (!IntBillWriteOffHelper.isAutoPreInt(intBill)) {
            return;
        }
        Object[] preIntBills = IntBillWriteOffHelper.getPreIntBills(new DynamicObject[]{intBill}, null);
        if (EmptyUtil.isEmpty((Object[])preIntBills)) {
            return;
        }
        List preIntBillIds = Arrays.stream(preIntBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"notrepayamount", (QFilter[])new QFilter[]{new QFilter("id", "=", intBill.get("sourcebillid"))});
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        BigDecimal writeOffAmt = intBill.getBigDecimal("convertintamt");
        if (LoanBillHelper.hasSettled(loanBill, intBill, settleInfoStr)) {
            writeOffAmt = IntBillWriteOffHelper.getTotalPreIntBillAmt((DynamicObject[])preIntBills);
        }
        OperateOption operate = OperateOption.create();
        operate.setVariableValue(CfmBizConstant.PARAM_AUTOWRITEOFF, "true");
        operate.setVariableValue("back", "true");
        operate.setVariableValue("settleinfo", settleInfoStr);
        operate.setVariableValue(CfmBizConstant.PREINTBILLIDS, JSON.toJSONString(preIntBillIds));
        operate.setVariableValue("writeoffamt", JSON.toJSONString((Object)writeOffAmt));
        TmcOperateServiceHelper.execOperate((String)"writeoff", (String)intBill.getDynamicObjectType().getName(), (Object[])new Object[]{intBill.getPkValue()}, (OperateOption)operate);
    }

    public static void autoRedWriteOff(DynamicObject preIntBill) {
        if (!LoanBillHelper.isNeedAutoRedWriteOff(preIntBill)) {
            return;
        }
        String loanBillNo = preIntBill.getString("loanbillno");
        if (EmptyUtil.isEmpty((String)loanBillNo)) {
            return;
        }
        QFilter filter = new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("loanbillno", "=", (Object)loanBillNo);
        Object[] unWriteOffPreIntBills = TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((Object[])unWriteOffPreIntBills)) {
            return;
        }
        long batchNoId = preIntBill.getLong("id");
        preIntBill.set("batchnoid", (Object)batchNoId);
        OperateOption operate = OperateOption.create();
        operate.setVariableValue(CfmBizConstant.PARAM_AUTOREDWRITEOFF, "true");
        operate.setVariableValue("back", "true");
        operate.setVariableValue(CfmBizConstant.PARAM_REDWRITEOFFBATCH, String.valueOf(batchNoId));
        Object[] ids = Arrays.stream(unWriteOffPreIntBills).map(DataEntityBase::getPkValue).toArray();
        logger.info("\u81ea\u52a8\u7ea2\u51b2\u9884\u63d0\u5355ID{}", (Object)Arrays.toString(ids));
        TmcOperateServiceHelper.execOperate((String)"redwriteoff", (String)"cfm_preinterestbill", (Object[])ids, (OperateOption)operate);
    }

    public static void autoUnRedWriteOff(DynamicObject preIntBill, String app) {
        long pkValue = preIntBill.getLong("id");
        QFilter filter = new QFilter("batchnoid", "=", (Object)pkValue);
        filter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue()));
        filter.and(new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue()));
        String entityName = preIntBill.getDynamicObjectType().getName();
        Object[] autoRedWriteOffBills = TmcDataServiceHelper.load((String)entityName, (String)"billno,id", (QFilter[])filter.toArray(), (String)"prestartdate desc,billno desc");
        if (EmptyUtil.isNoEmpty((Object[])autoRedWriteOffBills)) {
            Object[] ids = Arrays.stream(autoRedWriteOffBills).map(DataEntityBase::getPkValue).toArray();
            logger.info("\u53cd\u5411\u51b2\u9500\u7684\u7ea2\u51b2\u9884\u63d0\u5355ID{}", (Object)Arrays.toString(ids));
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("back", "true");
            operate.setVariableValue("appid", app);
            TmcOperateServiceHelper.execOperate((String)"unredwriteoff", (String)entityName, (Object[])ids, (OperateOption)operate);
        }
    }

    public static boolean isNeedAutoRedWriteOff(DynamicObject preIntBill) {
        String creditorType = preIntBill.getString("creditortype");
        String mainOrgField = "org";
        String preIntBillFormId = preIntBill.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)"cim_preinterestbill", (CharSequence)preIntBillFormId) || StringUtils.equals((CharSequence)creditorType, (CharSequence)CreditorTypeEnum.INNERUNIT.getValue())) {
            mainOrgField = "creditorg";
        }
        long orgId = preIntBill.getDynamicObject(mainOrgField).getLong("id");
        return IntBillWriteOffHelper.isAutoRedWriteOffParam(orgId);
    }

    private static boolean hasSettled(DynamicObject loanBill, DynamicObject intBill, String settleInfoStr) {
        Map settleInfo = EmptyUtil.isEmpty((String)settleInfoStr) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)settleInfoStr, Map.class);
        boolean settleInfoFlag = EmptyUtil.isEmpty(settleInfo.get(intBill.getString("billno"))) ? false : (Boolean)settleInfo.get(intBill.getString("billno"));
        return settleInfoFlag || EmptyUtil.isEmpty((BigDecimal)loanBill.getBigDecimal("notrepayamount"));
    }

    public static DynamicObject getPayIntAccountFromPlan(DynamicObject loanbill) {
        int size;
        DynamicObjectCollection intPlanEntrys = loanbill.getDynamicObjectCollection("interest_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)intPlanEntrys)) {
            return null;
        }
        for (int i = size = intPlanEntrys.size() - 1; i >= 0; --i) {
            if (((DynamicObject)intPlanEntrys.get(i)).getInt("intstate") == 1 && i < size) {
                return ((DynamicObject)intPlanEntrys.get(i + 1)).getDynamicObject("intaccount");
            }
            if (i != 0) continue;
            return ((DynamicObject)intPlanEntrys.get(0)).getDynamicObject("intaccount");
        }
        return null;
    }

    public static boolean isYkx(DynamicObject loanBill) {
        return SettleIntModeEnum.ykx.getValue().equals(loanBill.getString("settleintmode"));
    }

    public static boolean isPrePayint(String payIntType) {
        return InterestbillctgEnum.isPrePayint((String)payIntType);
    }

    public static boolean isCorrectPreIntBill(DynamicObject preIntBill) {
        String operateType = preIntBill.getString("operatetype");
        return PreIntOperateTypeEnum.isSupInt(operateType) || PreIntOperateTypeEnum.isWriteOffInt(operateType);
    }

    public static DynamicObject[] getCorrectBills(Object preIntBillId, String correctType) {
        QFilter filter = new QFilter("writeoffpreintbillid", "=", preIntBillId);
        if (EmptyUtil.isNoEmpty((String)correctType)) {
            filter.and("operatetype", "=", (Object)correctType);
        } else {
            filter.and("operatetype", "in", Arrays.asList(PreIntOperateTypeEnum.SUPINT.getValue(), PreIntOperateTypeEnum.WRITEOFFINT.getValue()));
        }
        return TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)"id,supintamt,writeoffamt,nowriteoffamt,operatetype", (QFilter[])filter.toArray());
    }

    public static boolean existCorrectBill(Object preIntBillId) {
        return EmptyUtil.isNoEmpty((Object[])LoanBillHelper.getCorrectBills(preIntBillId, null));
    }

    public static String verifyLastEntIntDate(DynamicObject loanBill, Date repayDate) {
        Date loanEndInstDate = loanBill.getDate("endinstdate");
        if (repayDate == null || loanEndInstDate == null) {
            return null;
        }
        if (!LoanBillHelper.isYkx(loanBill) && repayDate.compareTo(loanEndInstDate) < 0) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
            return String.format(bizResource.getRbEndinstdateMin(), DateUtils.formatString((Date)loanEndInstDate, (String)"yyyy-MM-dd"));
        }
        return null;
    }

    public static Map<Long, Map<Long, BigDecimal>> getSlBankNotdrawamount(Collection<Long> contractIds) {
        HashMap<Long, Map<Long, BigDecimal>> contractDrawAmountMap = new HashMap<Long, Map<Long, BigDecimal>>(contractIds.size());
        String selectProps = "loantype,iscycleloan,,banksyndicate_entry.e_bank,banksyndicate_entry.e_shareamount";
        QFilter qFilter = new QFilter("id", "in", contractIds).and("loantype", "=", (Object)LoanTypeEnum.BANKSLOAN.getValue());
        Object[] contractBills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)selectProps, (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((Object[])contractBills)) {
            return contractDrawAmountMap;
        }
        String selectProperties = "id,amount,drawamount,repayamount,sourcebillid,banksyndicate_entry.e_bank,banksyndicate_entry.e_shareamount,banksyndicate_entry.e_bankrole,currency";
        Map<Long, DynamicObject> contractBillMap = Arrays.stream(contractBills).collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        QFilter filter = new QFilter("sourcebillid", "in", contractBillMap.keySet()).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        Object[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)selectProperties, (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((Object[])loanBills)) {
            return contractDrawAmountMap;
        }
        Map<Long, List<DynamicObject>> loanBillGroupMap = Arrays.stream(loanBills).collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : loanBillGroupMap.entrySet()) {
            Long contractId = entry.getKey();
            DynamicObject contractBill = contractBillMap.get(contractId);
            boolean isCycleLoan = contractBill.getBoolean("iscycleloan");
            DynamicObjectCollection slBankEntrys = contractBill.getDynamicObjectCollection("banksyndicate_entry");
            Map<Long, BigDecimal> drawAmountMap = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_bank"))).collect(Collectors.toMap(o -> o.getDynamicObject("e_bank").getLong("id"), o -> o.getBigDecimal("e_shareamount"), (v1, v2) -> v2));
            for (DynamicObject loanBill : entry.getValue()) {
                BigDecimal repayAmount = isCycleLoan ? loanBill.getBigDecimal("repayamount") : BigDecimal.ZERO;
                DynamicObjectCollection loanBankEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
                DynamicObject currency = loanBill.getDynamicObject("currency");
                int scale = currency != null ? currency.getInt("amtprecision") : 2;
                Map<Long, BigDecimal> loanBankRepayMap = LoanBillHelper.getLoanBankRepayMap(loanBankEntrys, loanBill.getBigDecimal("drawamount"), repayAmount, scale);
                for (DynamicObject loanBankEntry : loanBankEntrys) {
                    DynamicObject bank = loanBankEntry.getDynamicObject("e_bank");
                    if (EmptyUtil.isEmpty((DynamicObject)bank) || !drawAmountMap.containsKey(bank.getLong("id"))) continue;
                    long bankId = bank.getLong("id");
                    BigDecimal repayAmt = loanBankRepayMap.getOrDefault(bankId, BigDecimal.ZERO);
                    BigDecimal notDrawAmount = drawAmountMap.get(bankId).subtract(loanBankEntry.getBigDecimal("e_shareamount")).add(repayAmt);
                    drawAmountMap.put(bankId, BigDecimal.ZERO.compareTo(notDrawAmount) > 0 ? BigDecimal.ZERO : notDrawAmount);
                }
            }
            contractDrawAmountMap.put(contractId, drawAmountMap);
        }
        return contractDrawAmountMap;
    }

    public static Map<Long, BigDecimal> getSlBankNotdrawamount(long loanConId, long loanId) {
        DynamicObject[] loanBills;
        Map<Long, BigDecimal> drawAmountMap = new HashMap<Long, BigDecimal>();
        DynamicObject loanConBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"loantype,iscycleloan,,banksyndicate_entry.e_bank,banksyndicate_entry.e_shareamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)loanConId)});
        if (EmptyUtil.isEmpty((DynamicObject)loanConBill) || !LoanTypeEnum.isBanksLoan(loanConBill.getString("loantype"))) {
            return drawAmountMap;
        }
        boolean isCycleLoan = loanConBill.getBoolean("iscycleloan");
        DynamicObjectCollection slBankEntrys = loanConBill.getDynamicObjectCollection("banksyndicate_entry");
        drawAmountMap = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_bank"))).collect(Collectors.toMap(o -> o.getDynamicObject("e_bank").getLong("id"), o -> o.getBigDecimal("e_shareamount"), (v1, v2) -> v2));
        QFilter filter = new QFilter("loancontractbill", "=", (Object)loanConId).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        if (EmptyUtil.isNoEmpty((Long)loanId)) {
            filter.and(new QFilter("id", "!=", (Object)loanId));
        }
        for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id,amount,drawamount,repayamount,banksyndicate_entry.e_bank,banksyndicate_entry.e_shareamount,banksyndicate_entry.e_bankrole,currency", (QFilter[])new QFilter[]{filter})) {
            BigDecimal repayAmount = isCycleLoan ? loanBill.getBigDecimal("repayamount") : BigDecimal.ZERO;
            DynamicObjectCollection loanBankEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
            DynamicObject currency = loanBill.getDynamicObject("currency");
            int scale = currency != null ? currency.getInt("amtprecision") : 2;
            Map<Long, BigDecimal> loanBankRepayMap = LoanBillHelper.getLoanBankRepayMap(loanBankEntrys, loanBill.getBigDecimal("drawamount"), repayAmount, scale);
            for (DynamicObject loanBankEntry : loanBankEntrys) {
                DynamicObject bank = loanBankEntry.getDynamicObject("e_bank");
                if (EmptyUtil.isEmpty((DynamicObject)bank) || !drawAmountMap.containsKey(bank.getLong("id"))) continue;
                long bankId = bank.getLong("id");
                BigDecimal repayAmt = loanBankRepayMap.getOrDefault(bankId, BigDecimal.ZERO);
                BigDecimal notDrawAmount = drawAmountMap.get(bankId).subtract(loanBankEntry.getBigDecimal("e_shareamount")).add(repayAmt);
                drawAmountMap.put(bankId, BigDecimal.ZERO.compareTo(notDrawAmount) > 0 ? BigDecimal.ZERO : notDrawAmount);
            }
        }
        return drawAmountMap;
    }

    private static Map<Long, BigDecimal> getLoanBankRepayMap(DynamicObjectCollection loanBankEntrys, BigDecimal loanAmount, BigDecimal repayAmount, int scale) {
        HashMap<Long, BigDecimal> loanBankMap = new HashMap<Long, BigDecimal>();
        if (EmptyUtil.isEmpty((BigDecimal)repayAmount)) {
            return loanBankMap;
        }
        BigDecimal totalRepamount = BigDecimal.ZERO;
        long mbRoleId = 0L;
        for (DynamicObject loanBankEntry : loanBankEntrys) {
            BigDecimal shareAmount = loanBankEntry.getBigDecimal("e_shareamount");
            DynamicObject bank = loanBankEntry.getDynamicObject("e_bank");
            if (EmptyUtil.isEmpty((DynamicObject)bank)) continue;
            if ("mb".equals(loanBankEntry.getString("e_bankrole"))) {
                mbRoleId = bank.getLong("id");
            }
            BigDecimal repAmount = shareAmount.multiply(repayAmount).divide(loanAmount, scale, RoundingMode.HALF_UP);
            loanBankMap.put(bank.getLong("id"), repAmount);
            totalRepamount = totalRepamount.add(repAmount);
        }
        if (totalRepamount.compareTo(repayAmount) != 0 && EmptyUtil.isNoEmpty((Long)mbRoleId) && loanBankMap.containsKey(mbRoleId)) {
            BigDecimal subAmount = repayAmount.subtract(totalRepamount);
            loanBankMap.put(mbRoleId, ((BigDecimal)loanBankMap.get(mbRoleId)).add(subAmount));
        }
        return loanBankMap;
    }

    public static BigDecimal getNoWriteOffPreInstAmt(DynamicObject bill, boolean fromContract) {
        String creditorType;
        if (null == bill) {
            return BigDecimal.ZERO;
        }
        String dataSource = bill.getString("datasource");
        String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName(dataSource, true, creditorType = bill.getString("creditortype"));
        DynamicObject org = bill.getDynamicObject(mainOrgField);
        if (null == org) {
            return BigDecimal.ZERO;
        }
        boolean isRedWriteOffParam = IntBillWriteOffHelper.isRedWriteOffParam(org.getLong("id"));
        if (isRedWriteOffParam) {
            return PreInterestBillRepository.getPreInstDifferAmt(bill, fromContract);
        }
        return PreInterestBillRepository.getInstDifferAmt(bill, fromContract);
    }

    public static void autoRedWriteOffOneSelf(DynamicObject preInterestBill) {
        if (!PreIntOperateTypeEnum.PREINT.getValue().equals(preInterestBill.getString("operatetype"))) {
            return;
        }
        String billNo = preInterestBill.getString("billno");
        logger.info("\u9884\u63d0\u5355\u5f00\u59cb\u81ea\u52a8\u51b2\u9500\uff0c\u9884\u63d0\u5355\u7f16\u53f7{}", (Object)billNo);
        String dataSource = preInterestBill.getString("datasource");
        String creditorType = preInterestBill.getString("creditortype");
        String orgFieldName = CfmBillCommonHelper.getFundOrgFieldName(dataSource, true, creditorType);
        DynamicObject org = preInterestBill.getDynamicObject(orgFieldName);
        boolean isRedWriteOffParam = IntBillWriteOffHelper.isRedWriteOffParam(org.getLong("id"));
        boolean needAutoRedWriteOff = IntBillWriteOffHelper.isAutoRedWriteOffParam(org.getLong("id"));
        if (!isRedWriteOffParam || !needAutoRedWriteOff) {
            logger.info("\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5355\u81ea\u52a8\u7ea2\u51b2\uff0c\u83b7\u53d6\u53c2\u6570\uff1a\u9884\u63d0\u65b9\u6cd5\u8bbe\u7f6e\uff1a{}\uff0c\u81ea\u52a8\u7ea2\u51b2\uff1a{}", (Object)isRedWriteOffParam, (Object)needAutoRedWriteOff);
            return;
        }
        String loanBillNo = preInterestBill.getString("loanbillno");
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"drawtype,cleardate", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)loanBillNo)});
        String drawType = loanBill.getString("drawtype");
        if (!DrawTypeEnum.isCloseout(drawType)) {
            logger.info("\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5355\u81ea\u52a8\u7ea2\u51b2\uff0c\u63d0\u6b3e\u5355\u7ed3\u6e05\u72b6\u6001\uff1a{}", (Object)drawType);
            return;
        }
        Date clearDate = loanBill.getDate("cleardate");
        Date bizDate = preInterestBill.getDate("bizdate");
        if (EmptyUtil.isEmpty((Object)clearDate) || EmptyUtil.isEmpty((Object)bizDate) || bizDate.compareTo(DateUtils.getLastDay((Date)clearDate, (int)1)) < 0) {
            logger.info("\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5355\u81ea\u52a8\u7ea2\u51b2\uff0c\u63d0\u6b3e\u5355\u8fd8\u6e05\u65e5\u671f\uff1a{}\uff0c\u9884\u63d0\u5355\u9884\u63d0\u7ed3\u675f\u65e5\uff1a{}", (Object)clearDate, (Object)bizDate);
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("autoRedWriteOffOneSelf", "true");
        String entityName = DataSourceEnum.isInvest(dataSource) ? "cim_preinterestbill" : "cfm_preinterestbill";
        TmcOperateServiceHelper.execOperate((String)"redwriteoff", (String)entityName, (Object[])new Object[]{preInterestBill.getPkValue()}, (OperateOption)operateOption);
        logger.info("\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5355\u81ea\u52a8\u7ea2\u51b2\u6210\u529f\uff0c\u9884\u63d0\u5355\u7f16\u53f7{}", (Object)billNo);
    }

    public static boolean isBond(DynamicObject loanBill) {
        return loanBill.getDataEntityType().getName().equals("cfm_loanbill_bond");
    }

    public static BigDecimal getConvertRate(DynamicObject loanBill) {
        BigDecimal convertRate = loanBill.getBigDecimal("convertrate");
        return convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
    }
}

