/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.service.UpdateRepayPlanService;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.model.interest.WorkCalendarAdjustParam;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.factory.PlanCallStragetyFactory;

public class LoanBillRepayPlanHelper {
    private static final UpdateRepayPlanService updateRepayPlanService = new UpdateRepayPlanService();

    public static void updateLoanBillRepayPlanList(DynamicObject loanBill) {
        DynamicObjectCollection repayPlanColls = loanBill.getDynamicObjectCollection("repayplan_entry");
        if (repayPlanColls.isEmpty()) {
            return;
        }
        DynamicObjectCollection repaymentBills = RepaymentBillRepository.queryRepaymentByLoanBillId(loanBill.getLong("id"));
        updateRepayPlanService.updateLoanBillRepayPlanList(loanBill, repaymentBills);
    }

    public static void updateLoanBillRepayPlanList(DynamicObject loanBill, List<DynamicObject> repaymentBills) {
        DynamicObjectCollection repayPlanColls = loanBill.getDynamicObjectCollection("repayplan_entry");
        if (repayPlanColls.isEmpty()) {
            return;
        }
        DynamicObjectCollection colls = new DynamicObjectCollection();
        if (repaymentBills != null) {
            colls.addAll(repaymentBills);
        }
        updateRepayPlanService.updateLoanBillRepayPlanList(loanBill, colls);
    }

    public static void repaymentScWriteBack(DynamicObject loanBill) {
        LoanBillRepayPlanHelper.updateLoanBillRepayPlanList(loanBill);
    }

    public static void updateLoanBillRepayPlanByPayment(DynamicObject loanBill, LoanWriteParam param) {
        LoanBillRepayPlanHelper.updateLoanBillRepayPlanList(loanBill);
    }

    public static void autoGenRepayPlan(DynamicObject[] loanBills) {
        Object[] ids = Arrays.stream(loanBills).map(o -> o.getLong("id")).toArray();
        DynamicObjectCollection loanInfos = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,drawamount,bizdate,startintdate,expiredate,repaymentway,stageplan,accountbank,currency,productfactory,fixedrepayamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        Map<Long, DynamicObject> idLoanMap = loanInfos.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (DynamicObject loanBill : loanBills) {
            DynamicObject loanInfoFromDB = idLoanMap.get(loanBill.getLong("id"));
            boolean isReCalPlan = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)loanInfoFromDB)) {
                BigDecimal drawAmountDB = loanInfoFromDB.getBigDecimal("drawamount");
                BigDecimal drawAmountNow = loanBill.getBigDecimal("drawamount");
                BigDecimal fixedRepayAmountDB = loanInfoFromDB.getBigDecimal("fixedRepayAmount");
                BigDecimal fixedRepayAmountNow = loanBill.getBigDecimal("fixedRepayAmount");
                Date bizDateDB = loanInfoFromDB.getDate("bizdate");
                Date bizDateNow = loanBill.getDate("bizdate");
                Date startIntDateDB = loanInfoFromDB.getDate("startintdate");
                Date startIntDateNow = loanBill.getDate("startintdate");
                Date expireDateDB = loanInfoFromDB.getDate("expiredate");
                Date expireDateNow = loanBill.getDate("expiredate");
                String repaymentWayDB = loanInfoFromDB.getString("repaymentway");
                String repaymentWayNow = loanBill.getString("repaymentway");
                Long productFactoryIdDB = loanInfoFromDB.getLong("productfactory");
                long productFactoryIdNow = loanBill.getLong("productfactory.id");
                Long stagePlanDb = loanInfoFromDB.getLong("stageplan");
                long stagePlanNow = loanBill.getLong("stageplan.id");
                Long currencyDB = loanInfoFromDB.getLong("currency");
                long currencyNow = loanBill.getLong("currency.id");
                if (!(drawAmountDB.compareTo(drawAmountNow) == 0 && fixedRepayAmountDB.compareTo(fixedRepayAmountNow) == 0 && DateUtils.isSameDay((Date)bizDateDB, (Date)bizDateNow) && DateUtils.isSameDay((Date)startIntDateDB, (Date)startIntDateNow) && DateUtils.isSameDay((Date)expireDateDB, (Date)expireDateNow) && repaymentWayDB.equals(repaymentWayNow) && productFactoryIdDB.equals(productFactoryIdNow) && stagePlanDb.equals(stagePlanNow) && currencyDB.equals(currencyNow))) {
                    isReCalPlan = true;
                }
            } else {
                isReCalPlan = true;
            }
            if (!isReCalPlan) continue;
            DynamicObjectCollection planEntrys = loanBill.getDynamicObjectCollection("repayplan_entry");
            planEntrys.clear();
            LoanBillRepayPlanHelper.createRepayPlan(loanBill, loanBill.getDate("bizdate"), loanBill.getBigDecimal("drawamount"));
        }
    }

    public static void autoGenRepayPlan(DynamicObject loanBill) {
        DynamicObjectCollection planEntrys = loanBill.getDynamicObjectCollection("repayplan_entry");
        planEntrys.clear();
        LoanBillRepayPlanHelper.createRepayPlan(loanBill, loanBill.getDate("bizdate"), loanBill.getBigDecimal("drawamount"));
    }

    public static void autoGenRepayPlan(List<ExtendedDataEntity> dataEntities) {
        DynamicObject[] loanBills = (DynamicObject[])dataEntities.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        LoanBillRepayPlanHelper.autoGenRepayPlan(loanBills);
    }

    private static void createRepayPlan(DynamicObject loanBill, Date beginDate, BigDecimal balance) {
        DynamicObject accountBank = loanBill.getDynamicObject("accountbank");
        DynamicObjectCollection planEntrys = loanBill.getDynamicObjectCollection("repayplan_entry");
        RepayPlanCallRequest request = LoanBillRepayPlanHelper.genRepayPlanRequest(loanBill, beginDate, balance);
        List repayPlanList = PlanCallStragetyFactory.createRepayPlanCallStragety().createPlan(request);
        if (EmptyUtil.isNoEmpty((Object)repayPlanList)) {
            LoanBillRepayPlanHelper.updateRepayPlanByAdjustRule(loanBill, repayPlanList);
            int seq = 1;
            for (PlanCallResult repayPlan : repayPlanList) {
                DynamicObject planEntry = planEntrys.addNew();
                planEntry.set("seq", (Object)seq++);
                planEntry.set("exrepaymentdate", (Object)repayPlan.getBizDate());
                planEntry.set("exdrawamount", (Object)repayPlan.getPrinciple());
                planEntry.set("erepayamount", (Object)BigDecimal.ZERO);
                planEntry.set("enotrepayamount", (Object)repayPlan.getPrinciple());
                planEntry.set("repayaccount", (Object)accountBank);
                planEntry.set("repaymentmodifier", (Object)RequestContext.get().getCurrUserId());
                planEntry.set("repaymentmodifytime", (Object)DateUtils.getCurrentTime());
                planEntry.set("repaystate", (Object)"0");
            }
        }
    }

    private static void updateRepayPlanByAdjustRule(DynamicObject loanBill, List<PlanCallResult> repayPlanList) {
        String adjustRule = null;
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        if (productFactory != null) {
            adjustRule = productFactory.getString("loanexpireadjustrule");
        }
        DynamicObjectCollection workCalendars = loanBill.getDynamicObjectCollection("workcalendar");
        InterestCalcHelper.updatePlanListByAdjustRule(repayPlanList, WorkCalendarAdjustParam.build((DynamicObjectCollection)workCalendars, (String)adjustRule));
    }

    private static RepayPlanCallRequest genRepayPlanRequest(DynamicObject loanBill, Date beginDate, BigDecimal balance) {
        DynamicObject currency;
        RepayPlanCallRequest request = new RepayPlanCallRequest();
        request.setBeginDate(beginDate != null ? beginDate : loanBill.getDate("bizdate")).setEndDate(loanBill.getDate("expiredate")).setRepayWay(RepaymentWayEnum.getByValue((String)loanBill.getString("repaymentway"))).setBalance(balance != null ? balance : loanBill.getBigDecimal("drawamount")).setFixedRepayAmount(loanBill.getBigDecimal("fixedRepayAmount"));
        RepaySchemeInfo schemeInfo = LoanBillRepayPlanHelper.trans2RepaySchemeInfo(loanBill.getDynamicObject("stageplan"));
        request.setSchemeInfo(schemeInfo);
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            request.setAmountRound(Integer.valueOf(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")).getRound()));
        }
        if ((currency = loanBill.getDynamicObject("currency")) != null) {
            request.setAmountScale(Integer.valueOf(currency.getInt("amtprecision")));
        }
        return request;
    }

    private static RepaySchemeInfo trans2RepaySchemeInfo(DynamicObject schemeObj) {
        String offetDay;
        if (schemeObj == null) {
            return null;
        }
        schemeObj = TmcDataServiceHelper.loadSingleFromCache((Object)schemeObj.get("id"), (String)"cfm_repayagingcheme");
        String period = schemeObj.getString("period");
        RepaySchemeEnum repaySchemeEnum = RepaySchemeEnum.trans2RepaySchemeEnum((String)period);
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        schemeInfo.setRepayScheme(repaySchemeEnum);
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)schemeObj.getString("month")));
        String day = schemeObj.getString("day");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        if (EmptyUtil.isNotBlank((CharSequence)(offetDay = schemeObj.getString("offetday")))) {
            schemeInfo.setOffetDay(Integer.valueOf(Integer.parseInt(offetDay)));
        }
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(schemeObj.getBoolean("drawmonthsettle")));
        return schemeInfo;
    }

    public static void updateLoanBillRepayPlan(DynamicObject loanBill, boolean isChangeApply) {
        boolean isDqhb;
        String repayment = loanBill.getString("repaymentway");
        if (RepaymentWayEnum.isHbfx((String)repayment) && !isChangeApply) {
            return;
        }
        boolean bl = isDqhb = RepaymentWayEnum.isDqhblsbq((String)repayment) || RepaymentWayEnum.isDqhbdqhx((String)repayment);
        if (isDqhb && EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject("stageplan"))) {
            return;
        }
        DynamicObjectCollection planEntrys = loanBill.getDynamicObjectCollection("repayplan_entry");
        for (int i = planEntrys.size() - 1; i >= 0; --i) {
            if (RepayStateEnum.isPayed(((DynamicObject)planEntrys.get(i)).getString("repaystate"))) continue;
            planEntrys.remove(i);
        }
        LoanBillRepayPlanHelper.createRepayPlan(loanBill, loanBill.getDate("lastrepaydate"), loanBill.getBigDecimal("notrepayamount"));
    }
}

