/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.service.writeback.LoanBillContractWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillExtendWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillIntBillWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillIntPlanWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillNoFixedTermWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillPreIntBillWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillRateAdjustFreeRateWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillRateAdjustWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillRepayBillWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillRepayPlanWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillStatusWriteService;
import kd.tmc.cfm.common.service.writeback.LoanBillWriteServiceChain;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanWriteBackHelper {
    private static final Log logger = LogFactory.getLog(LoanWriteBackHelper.class);

    public static void writeBack(Long loanBillId, LoanWBTypeEnum loanWBTypeEnum) {
        LoanWriteBackHelper.writeBack(loanBillId, loanWBTypeEnum, false, false, false);
    }

    public static void writeBack(List<Long> loanBillIds, LoanWBTypeEnum loanWBTypeEnum) {
        LoanWriteBackHelper.writeBack(LoanWriteParam.build(loanBillIds, loanWBTypeEnum));
    }

    public static void writeBack(LoanWriteParam param) {
        logger.info("\u53cd\u5199\u53c2\u6570: {}", (Object)SerializationUtils.toJsonString((Object)param));
        List<DynamicObject> loanBills = param.getLoanBills();
        if (EmptyUtil.isEmpty(loanBills)) {
            List<Long> loanBillIds = param.getLoanBillIds();
            if (EmptyUtil.isEmpty(loanBillIds) && EmptyUtil.isEmpty((Long)param.getLoanBillId())) {
                return;
            }
            loanBills = EmptyUtil.isNoEmpty(loanBillIds) ? LoanWriteBackHelper.getLoanBills(loanBillIds, param.isBond()) : LoanWriteBackHelper.getLoanBills(Collections.singletonList(param.getLoanBillId()), param.isBond());
        } else {
            loanBills = LoanWriteBackHelper.getLoanBills(loanBills);
        }
        if (EmptyUtil.isNoEmpty(loanBills)) {
            LoanWriteBackHelper.doWriteBack(loanBills, param);
        }
    }

    private static void doWriteBack(List<DynamicObject> loanBills, LoanWriteParam param) {
        LoanBillWriteServiceChain chain = new LoanBillWriteServiceChain();
        chain.addHandler(new LoanBillNoFixedTermWriteService(), new LoanBillExtendWriteService(), new LoanBillRepayBillWriteService(), new LoanBillIntBillWriteService(), new LoanBillPreIntBillWriteService(), new LoanBillStatusWriteService(), new LoanBillRateAdjustFreeRateWriteService(), new LoanBillRateAdjustWriteService(), new LoanBillRepayPlanWriteService(), new LoanBillIntPlanWriteService(), new LoanBillContractWriteService());
        chain.doWrite(loanBills, param);
        SaveServiceHelper.save((DynamicObject[])loanBills.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])loanBills.stream().map(l -> l.getDynamicObject("loancontractbill")).distinct().toArray(DynamicObject[]::new)));
        logger.info("loanBill,contractBill --save end");
    }

    public static void writeBack(LoanWriteParam param, DynamicObject scrLoanBill) {
        List<DynamicObject> loanBills = LoanWriteBackHelper.getLoanBills(Collections.singletonList(scrLoanBill));
        LoanWriteBackHelper.doWriteBack(loanBills, param);
    }

    public static void writeBack(long loanBillId, LoanWBTypeEnum loanWBTypeEnum, boolean isReSaveLoan, boolean isFromIsc, boolean isFromSch) {
        LoanWriteBackHelper.writeBack(LoanWriteParam.build(loanBillId, loanWBTypeEnum).setReSaveLoan(isReSaveLoan).setFromIsc(isFromIsc).setFromSch(isFromSch));
    }

    private static List<DynamicObject> getLoanBills(List<Long> loanBillIds, boolean isBond) {
        String entityName = isBond ? "cfm_loanbill_bond" : "cfm_loanbill";
        DynamicObject[] loanBills = TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        return LoanWriteBackHelper.getLoanBills(Arrays.stream(loanBills).collect(Collectors.toList()));
    }

    private static List<DynamicObject> getLoanBills(List<DynamicObject> loanBills) {
        Set contractIds = loanBills.stream().map(d -> d.getLong("loancontractbill.id")).collect(Collectors.toSet());
        Map contractMap = TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loancontractbill", contractIds);
        for (DynamicObject loanBill : loanBills) {
            loanBill.set("loancontractbill", contractMap.get(loanBill.getLong("loancontractbill.id")));
        }
        return loanBills;
    }

    public static void loanBillWriteBack(Pair<BigDecimal, List<IntBillExtInfo>> interestCals, DynamicObject loanBill) {
        LoanWriteBackHelper.loanBillWriteBack(interestCals, loanBill, true);
    }

    public static void loanBillWriteBack(Pair<BigDecimal, List<IntBillExtInfo>> interestCals, DynamicObject loanBill, boolean isUpdateCalInstAmt) {
        new LoanBillIntPlanWriteService().loanBillWriteBack(interestCals, loanBill, isUpdateCalInstAmt);
    }

    public static void preInterestBillDo(DynamicObject loanBill) {
        new LoanBillPreIntBillWriteService().doWrite(loanBill, null);
    }
}

