/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateHelper {
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        if (sourceCurrencyId != null && sourceCurrencyId.equals(targetCurrencyId)) {
            return BigDecimal.ONE;
        }
        return BaseDataServiceHelper.getExchangeRate((Long)TmcBusinessBaseHelper.getExchageTableId((Long)orgId), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
    }

    @Deprecated
    public static BigDecimal getMdTate(IFormView view, DynamicObject forexQuote, DynamicObject sourceCurrency, DynamicObject targetCurrency, Long orgId, Date date) {
        String fxquote;
        if (sourceCurrency.getPkValue() == targetCurrency.getPkValue()) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = BigDecimal.ZERO;
        if (forexQuote == null) {
            rate = RateHelper.getExchangeRate(sourceCurrency.getLong("id"), targetCurrency.getLong("id"), orgId, date);
            return rate;
        }
        ForexQuoteInfo info = new ForexQuoteInfo();
        String number = sourceCurrency.getString("number") + "/" + targetCurrency.getString("number");
        info.setFxquote(number);
        info.setIssuetime(date);
        ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.queryForexQuote((IFormView)view, (Long)forexQuote.getLong("id"), (ForexQuoteInfo)info);
        rate = forexQuoteInfo == null || forexQuoteInfo.getMiddleprice() == null || forexQuoteInfo.getMiddleprice().compareTo(BigDecimal.ZERO) <= 0 ? RateHelper.getExchangeRate(sourceCurrency.getLong("id"), targetCurrency.getLong("id"), orgId, date) : (number.equals(fxquote = forexQuoteInfo.getFxquote()) ? forexQuoteInfo.getMiddleprice() : BigDecimal.ONE.divide(forexQuoteInfo.getMiddleprice(), 10, RoundingMode.CEILING));
        return rate;
    }

    @Deprecated
    public static DynamicObject getCurrency(Long bizCurrency) {
        return TmcDataServiceHelper.loadSingleFromCache((Object)bizCurrency, (String)"bd_currency");
    }

    public static void referenceRateF7Evt(BeforeF7SelectEvent evt, IDataModel model, IFormView view) {
        RateHelper.referenceRateF7Evt(evt, model, view, null);
    }

    public static void referenceRateF7Evt(BeforeF7SelectEvent evt, IDataModel model, IFormView view, String bizDateProp) {
        Date bizDate;
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            evt.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"RateHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]));
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        QFilter currQFilter = new QFilter("currency", "=", currency.getPkValue());
        if (EmptyUtil.isNoEmpty((String)bizDateProp) && EmptyUtil.isNoEmpty((Object)(bizDate = (Date)model.getValue(bizDateProp)))) {
            sp.setCustomParam("PARAM_BIZDATEVAL", (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
        }
        sp.getListFilterParameter().setFilter(currQFilter);
    }
}

