/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SlBankRoleEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RepaymentbillHelper {
    public static String checkRepayDate(DynamicObject repayBill, Date repayDate, String compareField) {
        Date maxLastDate;
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        Optional<Date> maxLastDateOp = loans.stream().map(o -> Optional.ofNullable(o.getDynamicObject("e_loanbill")).map(r -> r.getDate(compareField))).filter(r -> r.isPresent()).map(r -> (Date)r.get()).max(Date::compareTo);
        if (maxLastDateOp.isPresent() && repayDate.before(maxLastDate = maxLastDateOp.get())) {
            return DateUtils.formatString((Date)maxLastDate, (String)"yyyy-MM-dd");
        }
        return "";
    }

    public static String getLoanPushInterestOp(String type) {
        if (BizTypeEnum.BOND.getValue().equals(type)) {
            return "bondinterestpushandsave";
        }
        if (BizTypeEnum.ENTRUST.getValue().equals(type) || BizTypeEnum.EC.getValue().equals(type)) {
            return "orginterestpushandsave";
        }
        return "bankinterestpushandsave";
    }

    public static IntBillExtInfo getIntBillInfo(DynamicObject bizBill, DynamicObject loanBill, Date repayDate, BigDecimal repayAmount) {
        DynamicObject factory = bizBill.getDynamicObject("productfactory");
        Long soucreId = loanBill.getLong("id");
        String repayWay = bizBill.getString("repaymentway");
        if (factory != null && RepaymentbillHelper.checkRepayWay(factory.getString("repaymentmode")) || repayWay != null && RepaymentbillHelper.checkRepayWay(repayWay)) {
            String entrySeq = RepaymentbillHelper.getRepaySeqNo(soucreId);
            if (EmptyUtil.isNoEmpty((String)entrySeq)) {
                return RepaymentbillHelper.getLoanRepayIntBillInfo(loanBill, entrySeq);
            }
        } else {
            BigDecimal notRepayAmt = loanBill.getBigDecimal("notrepayamount");
            if (repayAmount.compareTo(notRepayAmt) != 0) {
                return InterestCalcHelper.callInt(loanBill, repayDate, repayAmount);
            }
            Date lastEndIntDate = loanBill.getDate("endinstdate");
            if (EmptyUtil.isNoEmpty((Object)lastEndIntDate)) {
                lastEndIntDate = DateUtils.getNextDay((Date)lastEndIntDate, (int)1);
            }
            return InterestCalcHelper.callInt(InterestCalcRequest.build(loanBill, lastEndIntDate, repayDate));
        }
        return null;
    }

    public static IntBillExtInfo getLoanRepayIntBillInfo(DynamicObject loandBill, String interestSeq) {
        IntBillExtInfo info = null;
        DynamicObject interestEntry = loandBill.getDynamicObjectCollection("interest_entry").stream().filter(o -> interestSeq.equals(o.getString("interestseq"))).findFirst().orElse(null);
        if (interestEntry == null) {
            return info;
        }
        info = new IntBillExtInfo();
        info.setAmount(interestEntry.getBigDecimal("interestcalamount"));
        info.setBizDate(interestEntry.getDate("interesdate"));
        DynamicObjectCollection interestSubentry = interestEntry.getDynamicObjectCollection("interest_subentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestSubentry)) {
            return null;
        }
        info.setDetails(RepaymentbillHelper.getDetailIntBill(interestSubentry));
        info.initExtDetails(info.getDetails());
        return info;
    }

    private static List<IntBillDetailInfo> getDetailIntBill(DynamicObjectCollection interestSubentry) {
        ArrayList<IntBillDetailInfo> infoLists = new ArrayList<IntBillDetailInfo>(interestSubentry.size());
        IntBillDetailInfo info = null;
        for (DynamicObject entry : interestSubentry) {
            info = new IntBillDetailInfo();
            info.setBeginDate(entry.getDate("intereststartdate"));
            info.setEndDate(entry.getDate("interestenddate"));
            info.setDays(entry.getInt("interestdate"));
            info.setAmount(entry.getBigDecimal("interestamount"));
            info.setRate(entry.getBigDecimal("interestrate"));
            info.setPrinciple(entry.getBigDecimal("interestbalance"));
            info.setBasisDay(entry.getInt("interestdays"));
            info.setIntType(InterTypeEnum.valueOf((String)entry.getString("interestway")));
            infoLists.add(info);
        }
        return infoLists;
    }

    public static boolean checkRepayWay(String way) {
        return RepaymentWayEnum.debx.getValue().equals(way) || RepaymentWayEnum.debj.getValue().equals(way) || RepaymentWayEnum.dbdx.getValue().equals(way);
    }

    public static String getRepaySeqNo(Long LoandBillId) {
        DynamicObject entry;
        DynamicObjectCollection entrys;
        Set entrySets;
        Object[] bills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id,repayplan_entry.exrepaymentdate,repayplan_entry.enotrepayamount,repayplan_entry.seq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LoandBillId), new QFilter("repayplan_entry.enotrepayamount", ">", (Object)0)});
        if (!EmptyUtil.isEmpty((Object[])bills) && (entrySets = (entrys = bills[0].getDynamicObjectCollection("repayplan_entry")).stream().filter(o -> o.getBigDecimal("enotrepayamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toSet())) != null && entrySets.size() > 0 && (entry = entrySets.stream().sorted(Comparator.comparing(c -> c.getDate("exrepaymentdate"))).findFirst().orElseGet(null)) != null) {
            return entry.getString("seq");
        }
        return null;
    }

    public static String getLoanEntryName(String type) {
        if (BizTypeEnum.BOND.getValue().equals(type)) {
            return "cfm_loanbill_bond";
        }
        return "cfm_loanbill";
    }

    public static void returnGuaranteeUse(DynamicObject[] dataEntities) {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        boolean isBond = DataSourceEnum.isBond(dataEntities[0].getString("datasource"));
        String selectProps = "id,sourcebillid,creditortype,creditor,currency";
        if (isBond) {
            selectProps = selectProps + ",drawamount,investor_entry,investor_entry.e_investortype,investor_entry.e_investorid,investor_entry.e_avalinvestamt";
        }
        ArrayList<Long> loanIdSet = new ArrayList<Long>(RepaymentbillHelper.getLoanBillIds(Arrays.asList(dataEntities)));
        Map loanBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loanbill_bond", (String)selectProps, loanIdSet);
        HashMap<Long, Long> loanContractIdMap = new HashMap<Long, Long>(loanBillMap.size());
        HashMap<Long, String> creditorIdMap = new HashMap<Long, String>(loanBillMap.size());
        for (Map.Entry entry : loanBillMap.entrySet()) {
            Long loanBillId = (Long)entry.getKey();
            DynamicObject loanBill = (DynamicObject)entry.getValue();
            Long contractId = loanBill.getLong("sourcebillid");
            loanContractIdMap.put(loanBillId, contractId);
            String creditorType = loanBill.getString("creditortype");
            Long creditor = loanBill.getLong("creditor");
            if (!EmptyUtil.isNoEmpty((String)creditorType) || !EmptyUtil.isNoEmpty((Long)creditor)) continue;
            creditorIdMap.put(loanBillId, creditorType + creditor);
        }
        ArrayList<GuaranteeUseReturnBean> returnList = new ArrayList<GuaranteeUseReturnBean>(dataEntities.length);
        String billType = dataEntities[0].getDataEntityType().getName();
        for (DynamicObject repayBill : dataEntities) {
            DynamicObjectCollection slEntryCol = repayBill.containsProperty("slentryentity") ? repayBill.getDynamicObjectCollection("slentryentity") : null;
            DynamicObjectCollection loanEntryCol = repayBill.getDynamicObjectCollection("loans");
            for (DynamicObject loanEntry : loanEntryCol) {
                BigDecimal sumRepayAmount;
                BigDecimal remainInvestAmount;
                boolean isBuyBack;
                DynamicObjectCollection investorEntryCol;
                DynamicObject bondLoanBill;
                boolean isBuyBackFlag;
                Long loanId = loanEntry.getLong("e_loanbill.id");
                BigDecimal repayAmt = loanEntry.getBigDecimal("e_repayamount");
                Long retBillId = repayBill.getLong("id");
                GuaranteeUseReturnBean returnLoanBean = new GuaranteeUseReturnBean();
                returnLoanBean.setBizBillId(loanId);
                returnLoanBean.setReturnBillId(retBillId);
                returnLoanBean.setReturnBillType(billType);
                returnLoanBean.setCreditorId((String)creditorIdMap.get(loanId));
                returnLoanBean.setReturnAmount(repayAmt);
                returnList.add(returnLoanBean);
                GuaranteeUseReturnBean returnContractBean = new GuaranteeUseReturnBean();
                returnContractBean.setBizBillId((Long)loanContractIdMap.get(loanId));
                returnContractBean.setReturnBillId(retBillId);
                returnContractBean.setReturnBillType(billType);
                returnLoanBean.setCreditorId((String)creditorIdMap.get(loanId));
                returnContractBean.setReturnAmount(repayAmt);
                returnList.add(returnContractBean);
                DynamicObjectCollection buyBackEntryCol = loanEntry.containsProperty("buyback_entry") ? loanEntry.getDynamicObjectCollection("buyback_entry") : null;
                boolean bl = isBuyBackFlag = repayBill.containsProperty("isbuyback") && repayBill.getBoolean("isbuyback");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)slEntryCol)) {
                    for (DynamicObject slEntry : slEntryCol) {
                        if (!loanId.equals(slEntry.getDynamicObject("s_loanbillno").getLong("id"))) continue;
                        String creditorType = slEntry.getString("s_bankrole");
                        DynamicObject bankDo = slEntry.getDynamicObject("s_bank");
                        if (EmptyUtil.isEmpty((DynamicObject)bankDo)) continue;
                        Long creditor = bankDo.getLong("id");
                        returnLoanBean = new GuaranteeUseReturnBean();
                        returnLoanBean.setBizBillId(loanId);
                        returnLoanBean.setReturnBillId(retBillId);
                        returnLoanBean.setReturnBillType(billType);
                        returnLoanBean.setCreditorId(creditorType + creditor);
                        returnLoanBean.setReturnAmount(slEntry.getBigDecimal("s_repayamount"));
                        returnList.add(returnLoanBean);
                    }
                    continue;
                }
                if (isBuyBackFlag && EmptyUtil.isNoEmpty((DynamicObjectCollection)buyBackEntryCol)) {
                    for (DynamicObject buyBackEntry : buyBackEntryCol) {
                        String investorType = buyBackEntry.getString("e_investortype");
                        Long investorId = buyBackEntry.getLong("e_investorid");
                        returnLoanBean = new GuaranteeUseReturnBean();
                        returnLoanBean.setBizBillId(loanId);
                        returnLoanBean.setReturnBillId(retBillId);
                        returnLoanBean.setReturnBillType(billType);
                        returnLoanBean.setCreditorId(investorType + investorId);
                        returnLoanBean.setReturnAmount(buyBackEntry.getBigDecimal("e_buybackamt"));
                        returnList.add(returnLoanBean);
                    }
                    continue;
                }
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)slEntryCol) || isBuyBackFlag || !isBond || EmptyUtil.isEmpty((DynamicObject)(bondLoanBill = (DynamicObject)loanBillMap.get(loanId))) || EmptyUtil.isEmpty((DynamicObjectCollection)(investorEntryCol = bondLoanBill.getDynamicObjectCollection("investor_entry")))) continue;
                BigDecimal drawAmount = bondLoanBill.getBigDecimal("drawamount");
                DynamicObject currency = bondLoanBill.getDynamicObject("currency");
                QFilter[] repaymentFilters = new QFilter[]{new QFilter("loans.e_loanbill", "=", (Object)loanId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
                DynamicObjectCollection repaymentDsCol = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)String.join((CharSequence)",", "id", "loans.e_repayamount", "isbuyback"), (QFilter[])repaymentFilters, (String)"confirmtime desc");
                HashSet<Long> extRepaymentIdSet = new HashSet<Long>(repaymentDsCol.size());
                boolean bl2 = isBuyBack = repaymentDsCol.stream().filter(e -> e.getBoolean("isbuyback")).count() > 0L;
                if (isBuyBack) {
                    DynamicObject repaymentDs;
                    Iterator iterator = repaymentDsCol.iterator();
                    while (iterator.hasNext() && !(repaymentDs = (DynamicObject)iterator.next()).getBoolean("isbuyback")) {
                        extRepaymentIdSet.add(repaymentDs.getLong("id"));
                    }
                }
                if (EmptyUtil.isEmpty((BigDecimal)(remainInvestAmount = drawAmount.subtract(sumRepayAmount = repaymentDsCol.stream().filter(k -> isBuyBack && !extRepaymentIdSet.contains(k.getLong("id"))).map(v -> v.getBigDecimal("loans.e_repayamount")).reduce(BigDecimal.ZERO, BigDecimal::add))))) continue;
                BigDecimal sumAvaInvestAmt = investorEntryCol.stream().map(v -> v.getBigDecimal("e_avalinvestamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumAmount = Constants.ZERO;
                for (int i = 0; i < investorEntryCol.size(); ++i) {
                    BigDecimal returnAmount;
                    DynamicObject investorEntry = (DynamicObject)investorEntryCol.get(i);
                    String investorType = investorEntry.getString("e_investortype");
                    Long investorId = investorEntry.getLong("e_investorid");
                    returnLoanBean = new GuaranteeUseReturnBean();
                    returnLoanBean.setBizBillId(loanId);
                    returnLoanBean.setReturnBillId(retBillId);
                    returnLoanBean.setReturnBillType(billType);
                    returnLoanBean.setCreditorId(investorType + investorId);
                    if (remainInvestAmount.compareTo(sumAvaInvestAmt) == 0 && i == investorEntryCol.size() - 1) {
                        returnAmount = repayAmt.subtract(sumAmount);
                    } else {
                        returnAmount = repayAmt.multiply(investorEntry.getBigDecimal("e_avalinvestamt")).divide(remainInvestAmount, EmptyUtil.isEmpty((DynamicObject)currency) ? 6 : currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        sumAmount = sumAmount.add(returnAmount);
                    }
                    returnLoanBean.setReturnAmount(returnAmount);
                    returnList.add(returnLoanBean);
                }
            }
        }
        GuaranteeUseHelper.returnGuaranteeUse(returnList);
    }

    public static void cancelReturnGuaranteeUse(DynamicObject[] repayBills) {
        ArrayList<GuaranteeUseReturnBean> returnGuList = new ArrayList<GuaranteeUseReturnBean>(repayBills.length);
        for (DynamicObject repayBill : repayBills) {
            Long lgId = repayBill.getLong("id");
            String billType = repayBill.getDataEntityType().getName();
            GuaranteeUseReturnBean returnBean = new GuaranteeUseReturnBean();
            returnBean.setReturnBillId(lgId);
            returnBean.setReturnBillType(billType);
            returnGuList.add(returnBean);
        }
        GuaranteeUseHelper.cancelReturnGuaranteeUse(returnGuList);
    }

    public static void setSlBankRepayDefaultEntrys(DynamicObject repaymentBill, String loanAmountField, String slAmountField) {
        if (!LoanTypeEnum.isBanksLoan(repaymentBill.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection repayLoanEntrys = repaymentBill.getDynamicObjectCollection("loans");
        Map<Long, Pair<BigDecimal, BigDecimal>> loanRepayMap = repayLoanEntrys.stream().collect(Collectors.toMap(o -> o.getDynamicObject("e_loanbill").getLong("id"), o -> Pair.of((Object)o.getBigDecimal("e_repayableamount"), (Object)o.getBigDecimal(loanAmountField)), (v1, v2) -> v2));
        List<DynamicObject> slBankEntrys = repaymentBill.getDynamicObjectCollection("slentryentity").stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_bank"))).collect(Collectors.toList());
        int currencyPresion = BusinessHelper.getCurrencyPresion(repaymentBill.getDynamicObject("loancurrency"));
        RepaymentbillHelper.setSlBankRepayEntrys(slBankEntrys, loanRepayMap, slAmountField, true, currencyPresion);
    }

    public static void setSlBankRepayEntrys(List<DynamicObject> slBankEntrys, Map<Long, Pair<BigDecimal, BigDecimal>> loanRepayAmountPair, String amtField, boolean isAll, int scale) {
        if (EmptyUtil.isEmpty(slBankEntrys)) {
            return;
        }
        Set<Long> loanBillIds = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).map(o -> o.getDynamicObject("s_loanbillno").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(loanBillIds)) {
            return;
        }
        if (isAll) {
            DataSet repaySlBankDs = RepaymentbillHelper.getRepaySlBankDs(loanBillIds);
            Map<String, BigDecimal> repayedMap = RepaymentbillHelper.getRepaySlBanks(repaySlBankDs, true);
            Map<String, BigDecimal> repayMap = RepaymentbillHelper.getRepaySlBanks(repaySlBankDs, false);
            for (DynamicObject slBankEntry : slBankEntrys) {
                DynamicObject bank;
                DynamicObject loanBill = slBankEntry.getDynamicObject("s_loanbillno");
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{loanBill, bank = slBankEntry.getDynamicObject("s_bank")})) continue;
                String key = loanBill.getString("id") + bank.getString("id");
                BigDecimal loanAmount = slBankEntry.getBigDecimal("s_loanamount");
                BigDecimal notRepayAmount = loanAmount.subtract(repayedMap.getOrDefault(key, BigDecimal.ZERO));
                slBankEntry.set("s_notrepayamount", (Object)(notRepayAmount.compareTo(BigDecimal.ZERO) > 0 ? notRepayAmount : BigDecimal.ZERO));
                BigDecimal canRepayAmount = loanAmount.subtract(repayMap.getOrDefault(key, BigDecimal.ZERO));
                slBankEntry.set("s_canrepayamount", (Object)(canRepayAmount.compareTo(BigDecimal.ZERO) > 0 ? canRepayAmount : BigDecimal.ZERO));
            }
        }
        for (Map.Entry<Long, Pair<BigDecimal, BigDecimal>> loanRepayAmount : loanRepayAmountPair.entrySet()) {
            List<DynamicObject> loanList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == ((Long)loanRepayAmount.getKey()).longValue()).collect(Collectors.toList());
            RepaymentbillHelper.setSlbaneRepayAmount(loanList, (BigDecimal)loanRepayAmount.getValue().getRight(), amtField, scale);
        }
    }

    private static void setSlbaneRepayAmount(List<DynamicObject> loanList, BigDecimal repayAmount, String amtField, int scale) {
        BigDecimal sumSlRepayAmount = BigDecimal.ZERO;
        BigDecimal totalCanRepayamount = loanList.stream().map(o -> o.getBigDecimal("s_canrepayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (EmptyUtil.isEmpty((BigDecimal)totalCanRepayamount)) {
            return;
        }
        for (DynamicObject loan : loanList) {
            BigDecimal slRepayAmount = loan.getBigDecimal("s_canrepayamount").multiply(repayAmount).divide(totalCanRepayamount, scale, RoundingMode.HALF_UP);
            sumSlRepayAmount = sumSlRepayAmount.add(slRepayAmount);
            loan.set(amtField, (Object)slRepayAmount);
        }
        BigDecimal amount = repayAmount.subtract(sumSlRepayAmount);
        DynamicObject mbEntry = loanList.stream().filter(o -> SlBankRoleEnum.MB.getValue().equals(o.getString("s_bankrole"))).findFirst().orElse(null);
        if (mbEntry != null && EmptyUtil.isNoEmpty((BigDecimal)amount)) {
            BigDecimal canRepayAmount = mbEntry.getBigDecimal("s_canrepayamount");
            BigDecimal srepayAmount = mbEntry.getBigDecimal(amtField).add(amount);
            BigDecimal loanAmount = mbEntry.getBigDecimal("s_loanamount");
            if (EmptyUtil.isEmpty((BigDecimal)loanAmount) || "s_repayamount".equals(amtField) && srepayAmount.compareTo(canRepayAmount) > 0) {
                return;
            }
            mbEntry.set(amtField, (Object)(srepayAmount.compareTo(BigDecimal.ZERO) > 0 ? srepayAmount : BigDecimal.ZERO));
        }
    }

    public static Map<String, BigDecimal> getRepaySlBanks(DataSet repaySlBankDs, boolean isConfirm) {
        if (isConfirm) {
            repaySlBankDs = repaySlBankDs.copy().filter("billstatus='C' and confirmstatus='yetconfirm'");
        }
        DataSet repaySlDs = repaySlBankDs.groupBy(new String[]{"loanid", "bankid"}).sum("srepayamount").finish();
        HashMap<String, BigDecimal> repaySlMap = new HashMap<String, BigDecimal>();
        for (Row row : repaySlDs) {
            repaySlMap.put(String.valueOf(row.getLong("loanid")) + row.getLong("bankid"), row.getBigDecimal("srepayamount"));
        }
        return repaySlMap;
    }

    public static DataSet getRepaySlBankDs(Set<Long> loanBillIds) {
        return QueryServiceHelper.queryDataSet((String)"getRepaySlBanks", (String)"cfm_repaymentbill", (String)"billstatus,confirmstatus,slentryentity.s_loanbillno loanid,slentryentity.s_bank bankid,slentryentity.s_repayamount srepayamount", (QFilter[])new QFilter[]{new QFilter("slentryentity.s_loanbillno", "in", loanBillIds).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())}, null);
    }

    public static BigDecimal getAllPayBillAmt(DynamicObject sourceBill, Long payBillId) {
        QFilter filter = new QFilter("entry.e_sourcebillid", "=", sourceBill.get("id")).and("billstatus", "not in", Arrays.asList("G", "F"));
        if (EmptyUtil.isNoEmpty((Long)payBillId)) {
            filter = filter.and("id", "!=", (Object)payBillId);
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.e_actamt", (QFilter[])filter.toArray());
        return payBills.stream().map(p -> p.getBigDecimal("entry.e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getTotalAmt(DynamicObject repayBill) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
            totalAmt = totalAmt.add(entry.getBigDecimal("e_repayamount"));
            if (!entry.getBoolean("e_ispayinst")) continue;
            totalAmt = totalAmt.add(entry.getBigDecimal("e_actintamt"));
        }
        return totalAmt;
    }

    public static Set<Long> getLoanBillIds(List<DynamicObject> repayBills) {
        HashSet<Long> loanBillIds = new HashSet<Long>(10);
        for (DynamicObject repayBill : repayBills) {
            loanBillIds.addAll(repayBill.getDynamicObjectCollection("loans").stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("e_loanbill"))).map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toSet()));
        }
        return loanBillIds;
    }
}

