/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class RateAdjustBillRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Boolean> getAuditDateLargeCreateTime(List<DynamicObject> loanBills) {
        HashMap hashMap;
        HashMap map = new HashMap(loanBills.size());
        Map<Long, List<DynamicObject>> contractMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        QFilter adjustFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("loancontractbill", "in", contractMap.keySet()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryRateAdjustBillMaxAuditDate", (String)"cfm_rateadjustbill", (String)"loancontractbill,auditdate", (QFilter[])adjustFilter.toArray(), null);
        DataSet dsAuditDate = dataSet.groupBy(new String[]{"loancontractbill"}).max("auditdate").finish();
        try {
            HashMap<Long, Date> auditDateMap = new HashMap<Long, Date>(8);
            for (Row row : dsAuditDate) {
                auditDateMap.put(row.getLong("loancontractbill"), row.getDate("auditdate"));
            }
            for (Map.Entry<Long, List<DynamicObject>> entry : contractMap.entrySet()) {
                Long contractId = entry.getKey();
                List<DynamicObject> loanBillList = entry.getValue();
                Date auditDate = (Date)auditDateMap.get(contractId);
                if (auditDate == null) {
                    loanBillList.forEach(d -> map.put(d.getLong("id"), false));
                    continue;
                }
                loanBillList.forEach(d -> map.put(d.getLong("id"), auditDate.after(d.getDate("createtime"))));
            }
            hashMap = map;
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAuditDate});
            throw throwable;
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAuditDate});
        return hashMap;
    }

    public static Map<Long, DynamicObject> getRateAdjustBillByContractIds(List<Long> contractIds) {
        QFilter adjustFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        adjustFilter.and(new QFilter("loancontractbill", "in", contractIds));
        adjustFilter.and(new QFilter("isadjusttofloat", "=", (Object)true));
        String selects = "id, loancontractbill, afterrefrate.number, afterratesign, afterratefloatpoint, adjusteffectdate, rateadjustdate, entry.ladjusteffectdate";
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cfm_rateadjustbill", (String)selects, (QFilter[])new QFilter[]{adjustFilter});
        return colls.stream().collect(Collectors.toMap(d -> d.getLong("loancontractbill"), Function.identity(), (d1, d2) -> d1));
    }
}

