/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.repository.bean.BillAmountDTO;
import kd.tmc.cfm.common.repository.bean.RepayBillAmountDTO;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillRepository {
    private static final String LOANS_ENTRY_FILEDS = "loans.id,loans.e_loanbill,loans.e_repayamount,loans.e_convertrepayamt,loans.e_actintamt,loans.e_convertactintamt,loans.e_calintamt,loans.e_ispayinst";
    private static final String REPAYMENT_BILL_FIELDS = "id,accountbank,bizdate,description,modifytime,auditor,auditdate,loancontractbill,loans.id,loans.e_loanbill,loans.e_repayamount,loans.e_convertrepayamt,loans.e_actintamt,loans.e_convertactintamt,loans.e_calintamt,loans.e_ispayinst";
    private static final String REPAYMENT_AMOUNT_FIELDS = "id,amount,lockpayamt,needpayamt,needpayamt,loans.id,loans.e_loanbill,loans.e_repayamount,loans.e_convertrepayamt,loans.e_actintamt,loans.e_convertactintamt,loans.e_calintamt,loans.e_ispayinst";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Date> queryLastRepayDate(Collection<Long> loanBillIds) {
        HashMap<Long, Date> hashMap;
        HashMap<Long, Date> map = new HashMap<Long, Date>(loanBillIds.size());
        QFilter qFilter = RepaymentBillRepository.getLoanBillAuditFilter(loanBillIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryLastRepayDate", (String)"cfm_repaymentbill", (String)"loans.e_loanbill,bizdate", (QFilter[])qFilter.toArray(), null);
        DataSet dsMaxBizDate = dataSet.groupBy(new String[]{"loans.e_loanbill"}).max("bizdate").finish();
        try {
            for (Row row : dsMaxBizDate) {
                map.put(row.getLong("loans.e_loanbill"), row.getDate("bizdate"));
            }
            hashMap = map;
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsMaxBizDate});
            throw throwable;
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsMaxBizDate});
        return hashMap;
    }

    public static DynamicObject loadSingle(Object repaymentId, String selectProps) {
        return TmcDataServiceHelper.loadSingle((Object)repaymentId, (String)"cfm_repaymentbill", (String)selectProps);
    }

    public static DynamicObjectCollection queryRepaymentByLoanBillId(Long loanBillId) {
        return RepaymentBillRepository.queryRepaymentByLoanBillIds(Collections.singletonList(loanBillId), null);
    }

    public static Map<Long, List<DynamicObject>> getRepaymentByLoanBillIds(Collection<Long> loanBillIds, String selectProps) {
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)selectProps, (QFilter[])new QFilter("loans.e_loanbill", "in", loanBillIds).toArray());
        return colls.stream().collect(Collectors.groupingBy(r -> r.getLong("loans.e_loanbill")));
    }

    public static Map<Long, List<DynamicObject>> queryRepaymentByLoanBillIds(Collection<Long> loanBillIds) {
        DynamicObjectCollection colls = RepaymentBillRepository.queryRepaymentByLoanBillIds(loanBillIds, null);
        Map<Long, List<DynamicObject>> map = colls.stream().collect(Collectors.groupingBy(r -> r.getLong("loans.e_loanbill")));
        loanBillIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyList()));
        return map;
    }

    private static QFilter getLoanBillAuditFilter(Collection<Long> loanBillIds) {
        return new QFilter("loans.e_loanbill", "in", loanBillIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
    }

    private static DynamicObjectCollection queryRepaymentByLoanBillIds(Collection<Long> loanBillIds, String selectFields, Date endDate) {
        QFilter filter = RepaymentBillRepository.getLoanBillAuditFilter(loanBillIds);
        if (endDate != null) {
            filter.and("bizdate", "<=", (Object)endDate);
        }
        return QueryServiceHelper.query((String)"cfm_repaymentbill", (String)selectFields, (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryRepaymentByLoanBillIds(Collection<Long> loanBillIds, Date endDate) {
        return RepaymentBillRepository.queryRepaymentByLoanBillIds(loanBillIds, REPAYMENT_BILL_FIELDS, endDate);
    }

    public static Map<Long, RepayBillAmountDTO> getRepayBillAmount(Collection<Long> repaymentIds) {
        HashMap<Long, RepayBillAmountDTO> amountMap = new HashMap<Long, RepayBillAmountDTO>(repaymentIds.size());
        QFilter qFilter = new QFilter("id", "in", repaymentIds);
        DynamicObjectCollection repayBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)REPAYMENT_AMOUNT_FIELDS, (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> repayBillMap = repayBills.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : repayBillMap.entrySet()) {
            Long repayBillId = entry.getKey();
            List<DynamicObject> loanBillEntrys = entry.getValue();
            DynamicObject repayBill = loanBillEntrys.get(0);
            RepayBillAmountDTO amountDTO = new RepayBillAmountDTO();
            amountDTO.setRepayId(repayBillId).setAmount(repayBill.getBigDecimal("amount")).setLockpayamt(repayBill.getBigDecimal("lockpayamt")).setNeedpayamt(repayBill.getBigDecimal("needpayamt")).setTotalamt(repayBill.getBigDecimal("totalamt"));
            for (DynamicObject loanBillEntry : loanBillEntrys) {
                RepayBillAmountDTO.LoanEntry loanEntry = new RepayBillAmountDTO.LoanEntry();
                loanEntry.setEntryId(loanBillEntry.getLong("id")).setLoanId(loanBillEntry.getLong("loans.e_loanbill")).setRepayAmount(loanBillEntry.getBigDecimal("loans.e_repayamount")).setConvertRepayAmt(loanBillEntry.getBigDecimal("loans.e_convertrepayamt")).setCalIntAmt(loanBillEntry.getBigDecimal("loans.e_calintamt")).setActIntAmt(loanBillEntry.getBigDecimal("loans.e_actintamt")).setConvertActIntAmt(loanBillEntry.getBigDecimal("loans.e_convertactintamt"));
                amountDTO.addLoanEntry(loanEntry);
            }
            amountMap.put(repayBillId, amountDTO);
        }
        return amountMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, BillAmountDTO> getRepayAmountByLoanBillIds(Collection<Long> loanBillIds) {
        HashMap<Long, BillAmountDTO> hashMap;
        HashMap<Long, BillAmountDTO> map = new HashMap<Long, BillAmountDTO>(loanBillIds.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryRepayAmountByLoanBillIds", (String)"cfm_repaymentbill", (String)LOANS_ENTRY_FILEDS, (QFilter[])RepaymentBillRepository.getLoanBillAuditFilter(loanBillIds).toArray(), null);
        DataSet dsAmount = dataSet.groupBy(new String[]{"loans.e_loanbill"}).sum("loans.e_repayamount").sum("loans.e_convertrepayamt").finish();
        try {
            for (Row row : dsAmount) {
                map.put(row.getLong("loans.e_loanbill"), BillAmountDTO.build(row.getBigDecimal("loans.e_repayamount"), row.getBigDecimal("loans.e_convertrepayamt")));
            }
            loanBillIds.forEach(l -> map.putIfAbsent((Long)l, new BillAmountDTO()));
            hashMap = map;
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAmount});
            throw throwable;
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAmount});
        return hashMap;
    }

    public static BigDecimal getRepayAmountByLoanBillId(Long loanBillId) {
        DynamicObjectCollection repayBills = RepaymentBillRepository.queryRepaymentByLoanBillIds(Collections.singletonList(loanBillId), "loans.e_convertrepayamt", null);
        return repayBills.stream().map(o -> o.getBigDecimal("loans.e_convertrepayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static QFilter getContractBillAuditFilter(Collection<Long> contractIds) {
        return new QFilter("loancontractbill", "in", contractIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
    }

    public static Map<Long, List<DynamicObject>> getRepaymentByContractBillIds(Collection<Long> contractIds) {
        DynamicObjectCollection colls = RepaymentBillRepository.queryRepaymentByContractIds(contractIds);
        Map<Long, List<DynamicObject>> map = colls.stream().collect(Collectors.groupingBy(r -> r.getLong("loancontractbill")));
        contractIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyList()));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, BillAmountDTO> getRepayAmountByContractBillIds(Collection<Long> contractIds) {
        HashMap<Long, BillAmountDTO> hashMap;
        HashMap<Long, BillAmountDTO> map = new HashMap<Long, BillAmountDTO>(contractIds.size());
        String selectFields = "loancontractbill,loans.e_repayamount,loans.e_convertrepayamt";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryRepayAmountByContractBillIds", (String)"cfm_repaymentbill", (String)selectFields, (QFilter[])RepaymentBillRepository.getContractBillAuditFilter(contractIds).toArray(), null);
        DataSet dsAmount = dataSet.groupBy(new String[]{"loancontractbill"}).sum("loans.e_repayamount").sum("loans.e_convertrepayamt").finish();
        try {
            for (Row row : dsAmount) {
                map.put(row.getLong("loancontractbill"), BillAmountDTO.build(row.getBigDecimal("loans.e_repayamount"), row.getBigDecimal("loans.e_convertrepayamt")));
            }
            contractIds.forEach(l -> map.putIfAbsent((Long)l, new BillAmountDTO()));
            hashMap = map;
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAmount});
            throw throwable;
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataSet, dsAmount});
        return hashMap;
    }

    public static DynamicObjectCollection queryRepaymentByContractIds(Collection<Long> contractIds) {
        return QueryServiceHelper.query((String)"cfm_repaymentbill", (String)REPAYMENT_BILL_FIELDS, (QFilter[])RepaymentBillRepository.getContractBillAuditFilter(contractIds).toArray());
    }

    public static Map<Long, BigDecimal> getRepayAmountByContractIds(Collection<Long> contractIds) {
        DynamicObjectCollection repaymentBills = RepaymentBillRepository.queryRepaymentByContractIds(contractIds);
        Map<Long, BigDecimal> map = repaymentBills.stream().collect(Collectors.groupingBy(i -> i.getLong("loancontractbill"), Collectors.mapping(d -> d.getBigDecimal("loans.e_convertrepayamt"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        contractIds.forEach(d -> map.putIfAbsent((Long)d, BigDecimal.ZERO));
        return map;
    }

    public static BigDecimal getLockInAmout(Long loanBillId) {
        QFilter sourceIdFilter = new QFilter("loans.e_loanbill", "=", (Object)loanBillId);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection dyColl = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"loans.e_repayamount", (QFilter[])new QFilter[]{sourceIdFilter, billStatusFilter});
        return dyColl.stream().map(o -> o.getBigDecimal("loans.e_repayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static Map<Long, BigDecimal> getLockInAmout(Collection<Long> loanBillIds) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "in", loanBillIds).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection dyColl = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"loans.e_loanbill,loans.e_repayamount", (QFilter[])qFilter.toArray());
        Map<Long, BigDecimal> repayAmountMap = dyColl.stream().collect(Collectors.groupingBy(d -> d.getLong("loans.e_loanbill"), Collectors.mapping(d -> d.getBigDecimal("loans.e_repayamount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        loanBillIds.forEach(d -> repayAmountMap.putIfAbsent((Long)d, BigDecimal.ZERO));
        return repayAmountMap;
    }

    public static DynamicObject getAutoRepaymentBillByLoanBillId(Object loanBillId, String dataSource) {
        String entity = DataSourceEnum.isIfm(dataSource) ? "ifm_repaymentbill" : "cfm_repaymentbill";
        QFilter qFilter = new QFilter("loans.e_loanbill", "=", loanBillId).and("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()).and("auto", "=", (Object)true).and("datasource", "=", (Object)dataSource);
        return TmcDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])qFilter.toArray());
    }

    public static Object[] queryRepaymentBillIdByRepayApply(Object repayApplyId) {
        QFilter applyFilter = new QFilter("repayapplyf7", "=", repayApplyId);
        DynamicObjectCollection repayBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id", (QFilter[])applyFilter.toArray());
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)repayBills) ? repayBills.stream().map(d -> d.get("id")).toArray() : null;
    }

    public static DynamicObjectCollection getOnWayRepaymentBillByLoanIds(Collection<Long> loanBillIds) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "in", loanBillIds).and(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())));
        return QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"loans.e_loanbill.number", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject queryOnWayRepayByLoanId(Long loanBillId) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "=", (Object)loanBillId).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())));
        return QueryServiceHelper.queryOne((String)"cfm_repaymentbill", (String)"id,billno", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getAfterChgRepaymentBill(Long loanBillId, Date modifyTime) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime);
        return QueryServiceHelper.queryOne((String)"cfm_repaymentbill", (String)"billno", (QFilter[])qFilter.toArray());
    }

    public static Map<Long, List<DynamicObject>> getOnSubmitRepaymentBillByLoanIds(Collection<Long> loanBillIds) {
        QFilter repayIngQfilter = new QFilter("loans.e_loanbill", "in", loanBillIds).and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()).and("datasource", "!=", (Object)DataSourceEnum.FL.getValue());
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"loans.e_loanbill,billno,bizdate", (QFilter[])repayIngQfilter.toArray());
        return colls.stream().collect(Collectors.groupingBy(d -> d.getLong("loans.e_loanbill")));
    }

    public static Map<Long, String> getRepayBillByFilter(Set<Long> repayBillIds) {
        QFilter qFilter = new QFilter("id", "in", repayBillIds).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id, billno", (QFilter[])qFilter.toArray());
        return colls.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getString("billno")));
    }
}

