/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.resource;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.CfmBondResource;
import kd.tmc.cfm.common.resource.CfmNewBizResource;
import kd.tmc.cfm.common.resource.CimBizResource;
import kd.tmc.cfm.common.resource.FlBizResource;
import kd.tmc.cfm.common.resource.IfmBizResource;

public class BizResourceFactory {
    private static final List<String> CIM_BILL_LIST = new ArrayList<String>(10);
    private static final List<String> IFM_BILL_LIST = new ArrayList<String>(10);
    private static final List<String> BOND_BILL_LIST = new ArrayList<String>(10);
    private static final List<String> FL_BILL_LIST = new ArrayList<String>(10);

    public AbstractBizResource getBizResource(String dataSource) {
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            return new CimBizResource();
        }
        if (DataSourceEnum.BOND.getValue().equals(dataSource)) {
            return new CfmBondResource();
        }
        if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
            return new IfmBizResource();
        }
        if (DataSourceEnum.FL.getValue().equals(dataSource)) {
            return new FlBizResource();
        }
        return new CfmNewBizResource();
    }

    public AbstractBizResource getBizResourceByFormId(String formId) {
        if (CIM_BILL_LIST.contains(formId)) {
            return new CimBizResource();
        }
        if (BOND_BILL_LIST.contains(formId)) {
            return new CfmBondResource();
        }
        if (IFM_BILL_LIST.contains(formId)) {
            return new IfmBizResource();
        }
        if (FL_BILL_LIST.contains(formId)) {
            return new FlBizResource();
        }
        return new CfmNewBizResource();
    }

    static {
        CIM_BILL_LIST.add("cim_invest_loanbill");
        IFM_BILL_LIST.add("ifm_loanbill");
        BOND_BILL_LIST.add("cfm_loanbill_bond");
        FL_BILL_LIST.add("fl_receiptbill");
    }
}

