/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.bean.RepayPlanInfo;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UpdateRepayPlanService {
    public List<RepayPlanInfo> updateRepayPlan(List<RepayPlanInfo> repayPlans, List<RepayPlanInfo> repayBills) {
        TreeMap<Date, RepayPlanInfo> repayPlanMap = new TreeMap<Date, RepayPlanInfo>(repayPlans.stream().collect(Collectors.toMap(RepayPlanInfo::getRepayDate, r -> r, (r1, r2) -> r2)));
        for (RepayPlanInfo repayBill : repayBills) {
            BigDecimal repayAmount;
            Date repayDate = repayBill.getRepayDate();
            BigDecimal leftRepayAmount = repayAmount = repayBill.getRepayAmount();
            BigDecimal leftPlanAmount = repayAmount.negate();
            boolean isClearLeftPlanAmount = false;
            ArrayList<RepayPlanInfo> repayPlanList = new ArrayList<RepayPlanInfo>(repayPlanMap.values());
            int size = repayPlanList.size();
            block5: for (int i = 0; i < size; ++i) {
                boolean isLastPlan;
                RepayPlanInfo repayPlan = (RepayPlanInfo)repayPlanList.get(i);
                boolean bl = isLastPlan = i == size - 1;
                if (repayPlan.repayed()) {
                    if (repayPlan.getRepayDate().compareTo(repayDate) != 0) continue;
                    BigDecimal amount = repayAmount.add(repayPlan.getRepayAmount());
                    repayBill.setRepayAmount(amount).setUnRepayAmount(BigDecimal.ZERO).setRepayedAmount(amount);
                    continue;
                }
                Date planDate = repayPlan.getRepayDate();
                BigDecimal planAmount = repayPlan.getUnRepayAmount();
                leftRepayAmount = leftRepayAmount.subtract(planAmount);
                if (!isClearLeftPlanAmount) {
                    leftPlanAmount = leftPlanAmount.add(planAmount);
                }
                switch (planDate.compareTo(repayDate)) {
                    case -1: {
                        if (isLastPlan) {
                            if (repayPlan.getRepayedAmount().compareTo(BigDecimal.ZERO) > 0) {
                                repayPlan.setRepayAmount(repayPlan.getRepayedAmount()).setUnRepayAmount(BigDecimal.ZERO);
                            } else {
                                repayPlanMap.remove(planDate);
                            }
                            if (this.hasLeftPlanAmount(leftPlanAmount)) {
                                repayBill.setRepayAmount(leftPlanAmount.add(repayAmount)).setUnRepayAmount(leftPlanAmount);
                            }
                            repayPlanMap.put(repayDate, repayBill);
                            continue block5;
                        }
                        this.addRepayBill(repayPlanMap, repayBill, planDate);
                        continue block5;
                    }
                    case 0: {
                        if (leftRepayAmount.compareTo(BigDecimal.ZERO) < 0) {
                            leftRepayAmount = BigDecimal.ZERO;
                        }
                        if (!isLastPlan) continue block5;
                        BigDecimal repayedAmount = repayPlan.getRepayedAmount().add(repayAmount);
                        BigDecimal repayPlanAmount = repayedAmount.add(leftPlanAmount);
                        repayBill.setRepayAmount(repayPlanAmount).setRepayedAmount(repayedAmount).setUnRepayAmount(repayPlanAmount.subtract(repayedAmount));
                        repayPlanMap.put(repayDate, repayBill);
                        continue block5;
                    }
                    default: {
                        this.addRepayBill(repayPlanMap, repayBill, null);
                        if (isClearLeftPlanAmount) continue block5;
                        if (leftPlanAmount.compareTo(BigDecimal.ZERO) > 0) {
                            repayPlanMap.put(planDate, repayPlan.setRepayAmount(leftPlanAmount).setUnRepayAmount(leftPlanAmount));
                            isClearLeftPlanAmount = true;
                            leftPlanAmount = BigDecimal.ZERO;
                            continue block5;
                        }
                        repayPlanMap.remove(planDate);
                    }
                }
            }
        }
        return new ArrayList<RepayPlanInfo>(repayPlanMap.values());
    }

    public void updateLoanBillRepayPlanList(DynamicObject loanBill, DynamicObjectCollection repaymentBills) {
        DynamicObjectCollection repayPlanColls = loanBill.getDynamicObjectCollection("repayplan_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)repayPlanColls)) {
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)repaymentBills)) {
            for (DynamicObject repayPlan : repayPlanColls) {
                repayPlan.set("repaystate", (Object)0);
                repayPlan.set("exdrawamount", (Object)repayPlan.getBigDecimal("erepayamount").add(repayPlan.getBigDecimal("enotrepayamount")));
                repayPlan.set("erepayamount", (Object)BigDecimal.ZERO);
                repayPlan.set("enotrepayamount", (Object)repayPlan.getBigDecimal("exdrawamount"));
            }
            return;
        }
        TreeMap<Date, DynamicObject> repaymentBillMap = this.getRepayPlanMap(repaymentBills, "bizdate", "loans.e_repayamount");
        ArrayList<RepayPlanInfo> repayBillInfos = new ArrayList<RepayPlanInfo>(repaymentBillMap.size());
        for (DynamicObject repayBill : repaymentBillMap.values()) {
            BigDecimal repayAmount = repayBill.getBigDecimal("loans.e_repayamount");
            repayBillInfos.add(RepayPlanInfo.build(repayBill.getDate("bizdate"), repayAmount));
        }
        TreeMap<Date, DynamicObject> repayPlanMap = this.getRepayPlanMap(repayPlanColls, "exrepaymentdate", "exdrawamount");
        List<RepayPlanInfo> repayPlanInfos = new ArrayList<RepayPlanInfo>(repayPlanMap.size());
        for (DynamicObject repayBill : repayPlanMap.values()) {
            BigDecimal repayAmount = repayBill.getBigDecimal("exdrawamount");
            RepayPlanInfo repayPlanInfo = RepayPlanInfo.build(repayBill.getDate("exrepaymentdate"), repayAmount, repayAmount);
            if (repayPlanInfo.repayed()) continue;
            repayPlanInfos.add(repayPlanInfo);
        }
        repayPlanColls.clear();
        long currUserId = loanBill.getDynamicObject("creator").getLong("id");
        Date currentTime = DateUtils.getCurrentTime();
        repayPlanInfos = this.updateRepayPlan(repayPlanInfos, repayBillInfos);
        for (int i = 0; i < repayPlanInfos.size(); ++i) {
            RepayPlanInfo planBean = repayPlanInfos.get(i);
            Date repayDate = planBean.getRepayDate();
            DynamicObject repayPlan = repayPlanColls.addNew();
            repayPlan.set("seq", (Object)(i + 1));
            Integer status = planBean.getStatus();
            DynamicObject repayAccount = loanBill.getDynamicObject("accountbank");
            String desc = null;
            DynamicObject repayBill = repaymentBillMap.get(repayDate);
            DynamicObject repayPlanObj = repayPlanMap.get(repayDate);
            if (Integer.valueOf(1).equals(status) && repayBill != null) {
                repayAccount = TmcDataServiceHelper.newDynamicObject((String)"bd_accountbanks");
                repayAccount.set("id", (Object)repayBill.getLong("accountbank"));
                currentTime = repayBill.getDate("auditdate");
                desc = repayBill.getString("description");
            } else if (repayPlanObj != null) {
                repayAccount = repayPlanObj.getDynamicObject("repayaccount");
                desc = repayPlanObj.getString("repaymentdesc");
                currentTime = DateUtils.getCurrentTime();
            }
            repayPlan.set("exrepaymentdate", (Object)repayDate);
            repayPlan.set("exdrawamount", (Object)planBean.getRepayAmount());
            repayPlan.set("erepayamount", (Object)planBean.getRepayAmount().subtract(planBean.getUnRepayAmount()));
            repayPlan.set("enotrepayamount", (Object)planBean.getUnRepayAmount());
            repayPlan.set("repayaccount", (Object)repayAccount);
            repayPlan.set("repaymentmodifier", (Object)currUserId);
            repayPlan.set("repaymentmodifytime", (Object)currentTime);
            repayPlan.set("repaystate", (Object)status);
            repayPlan.set("repaymentdesc", (Object)desc);
        }
    }

    private TreeMap<Date, DynamicObject> getRepayPlanMap(DynamicObjectCollection repayPlanColls, String dateProp, String amountProp) {
        TreeMap<Date, DynamicObject> repayPlanBillMap = new TreeMap<Date, DynamicObject>();
        Map<Date, List<DynamicObject>> repayPlanMap = repayPlanColls.stream().collect(Collectors.groupingBy(r -> r.getDate(dateProp)));
        for (Map.Entry<Date, List<DynamicObject>> entry : repayPlanMap.entrySet()) {
            Date repayDate = entry.getKey();
            BigDecimal repayAmount = BigDecimal.ZERO;
            List<DynamicObject> repyaBills = entry.getValue();
            for (DynamicObject repayBill : repyaBills) {
                repayAmount = repayAmount.add(repayBill.getBigDecimal(amountProp));
            }
            DynamicObject lastRepayPlan = repyaBills.get(repyaBills.size() - 1);
            lastRepayPlan.set(amountProp, (Object)repayAmount);
            repayPlanBillMap.put(repayDate, lastRepayPlan);
        }
        return repayPlanBillMap;
    }

    private boolean hasLeftPlanAmount(BigDecimal leftPlanAmount) {
        return leftPlanAmount.compareTo(BigDecimal.ZERO) > 0;
    }

    private void addRepayBill(TreeMap<Date, RepayPlanInfo> repayPlanMap, RepayPlanInfo repayBill, Date planDate) {
        if (planDate != null) {
            repayPlanMap.remove(planDate);
        }
        repayBill.setRepayedAmount(repayBill.getRepayAmount());
        repayBill.setUnRepayAmount(BigDecimal.ZERO);
        repayPlanMap.put(repayBill.getRepayDate(), repayBill);
    }
}

