/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.calcint;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.bean.BatchInterestCalcRequest;
import kd.tmc.cfm.common.bean.CalcInterestSegmRequest;
import kd.tmc.cfm.common.bean.InterestCalcParam;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillCalcNormalIntHandle;
import kd.tmc.cfm.common.service.calcint.LoanBillCalcSofrIntHandle;
import kd.tmc.cfm.common.service.calcint.LoanBillRateHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillRepaymentPlanHelper;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillCalcIntService {
    private static final Log logger = LogFactory.getLog(LoanBillCalcIntService.class);
    private LoanBillCalcNormalIntHandle calcNormalIntHandle = new LoanBillCalcNormalIntHandle();
    private LoanBillCalcSofrIntHandle calcSofrIntHandle = new LoanBillCalcSofrIntHandle();

    public <T> Map<Long, T> batchCalcLoanBillInt(BatchInterestCalcRequest request) {
        List<InterestCalcRequest> requests = request.getRequests();
        HashMap<Long, IntBillExtInfo> map = new HashMap<Long, IntBillExtInfo>();
        if (EmptyUtil.isEmpty(requests)) {
            return map;
        }
        List<Long> loanBillIds = requests.stream().map(r -> r.getLoanBill().getLong("id")).collect(Collectors.toList());
        Map<Long, List<PlanCallResult>> repayListMap = LoanBillRepaymentPlanHelper.getAllRepayListMap(loanBillIds);
        for (InterestCalcRequest calcRequest : requests) {
            DynamicObject loanBill = calcRequest.getLoanBill();
            long loanBillId = loanBill.getLong("id");
            calcRequest.setRepayList(repayListMap.get(loanBillId));
            try {
                IntBillExtInfo intBillInfo = RepaymentWayEnum.isDebx((String)loanBill.getString("repaymentway")) ? this.calcIntForDebx(calcRequest) : this.callLoanBillInt(calcRequest);
                if (intBillInfo == null || !EmptyUtil.isNoEmpty((BigDecimal)intBillInfo.getAmount())) continue;
                map.put(loanBillId, intBillInfo);
            }
            catch (Exception e) {
                if (request.isSkipException()) {
                    logger.error("batchCalcLoanBillInt error, loanBillId = " + loanBillId, (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        return map;
    }

    public <T> Map<Long, T> batchCallInt(List<Long> loanBillIds, Date beginDate, Date endDate, boolean isPreInt) {
        HashMap<Long, T> intBillMap = new HashMap<Long, T>();
        List<DynamicObject> loanBills = InterestCalcHelper.getLoanBills(loanBillIds);
        if (loanBills.isEmpty()) {
            return intBillMap;
        }
        ArrayList<InterestCalcRequest> requests = new ArrayList<InterestCalcRequest>(loanBills.size());
        for (DynamicObject loanBill : loanBills) {
            requests.add(InterestCalcRequest.build(loanBill, beginDate, endDate, isPreInt).setSkipRateCheck(true));
        }
        logger.info("LoanBillCalcIntService batchCallInt requests:{}", (Object)((Object)requests).toString());
        Map<Long, T> intBillExtMap = this.batchCalcLoanBillInt(new BatchInterestCalcRequest(requests).setSkipException(true));
        intBillMap.putAll(intBillExtMap);
        return intBillMap;
    }

    private IntBillExtInfo calcIntForDebx(InterestCalcRequest calcRequest) {
        IntBillExtInfo intBill = null;
        InterestCalcParam param = this.getInterestCalcParam(calcRequest);
        List<PlanCallResult> repayList = calcRequest.getRepayList();
        DynamicObject loanBill = calcRequest.getLoanBill();
        List<PlanCallResult> repayPlanList = LoanBillRepaymentPlanHelper.getRepayPlanList(loanBill);
        for (PlanCallResult repayInfo : repayList) {
            Date repayDate = repayInfo.getBizDate();
            int size = repayPlanList.size();
            for (int i = 0; i < size; ++i) {
                if (!repayDate.equals(repayPlanList.get(i).getBizDate())) continue;
                param.setPeriod(i + 1).setRepayPlanList(repayPlanList);
                IntBillExtInfo extInfo = this.callLoanBillInt(loanBill, param);
                if (extInfo == null) continue;
                if (intBill == null) {
                    intBill = extInfo;
                    continue;
                }
                intBill.setAmount(intBill.getAmount().add(extInfo.getAmount()));
            }
        }
        return intBill;
    }

    private IntBillExtInfo callLoanBillInt(DynamicObject loanBill, InterestCalcParam calcParam) {
        return this.callLoanBillInt(loanBill, calcParam, false);
    }

    public IntBillExtInfo callLoanBillInt(DynamicObject loanBill, InterestCalcParam calcParam, boolean isPlan) {
        int tempScale = this.getLoanBillScale(loanBill);
        calcParam.setScale(tempScale);
        if (!loanBill.getBoolean("issofrrate")) {
            return this.calcNormalIntHandle.callLoanInt(loanBill, calcParam);
        }
        calcParam.setScale(10);
        IntBillExtInfo intBillExtInfo = this.calcSofrIntHandle.callLoanInt(loanBill, calcParam);
        if (!isPlan && EmptyUtil.isNoEmpty((Object)intBillExtInfo)) {
            intBillExtInfo.setAmount(this.setScale(intBillExtInfo.getAmount(), tempScale));
            intBillExtInfo.setBenchmarkInt(this.setScale(intBillExtInfo.getBenchmarkInt(), tempScale));
            intBillExtInfo.setFloatInt(this.setScale(intBillExtInfo.getFloatInt(), tempScale));
        }
        return intBillExtInfo;
    }

    private BigDecimal setScale(BigDecimal amount, int scale) {
        return amount != null ? amount.setScale(scale, RoundingMode.HALF_UP) : amount;
    }

    public int getLoanBillScale(DynamicObject loanBill) {
        int tempScale;
        DynamicObject currency = loanBill.getDynamicObject("currency");
        try {
            tempScale = currency.getInt("amtprecision");
        }
        catch (Exception e) {
            currency = TmcDataServiceHelper.loadSingleFromCache((Object)currency.getLong("id"), (String)"bd_currency", (String)"amtprecision");
            tempScale = currency.getInt("amtprecision");
        }
        return tempScale;
    }

    public IntBillExtInfo callLoanBillInt(InterestCalcRequest request) {
        logger.info("callLoanBillInt request: {}", (Object)request.toString());
        return this.callLoanBillInt(request.getLoanBill(), this.getInterestCalcParam(request));
    }

    private InterestCalcParam getInterestCalcParam(InterestCalcRequest request) {
        DynamicObject loanBill = request.getLoanBill();
        IntHTRuleEnum intHTRule = this.getIntHTRule(loanBill);
        Date beginDate = this.getBeginIntDate(loanBill, request.getBeginDate());
        BigDecimal principle = loanBill.getBigDecimal("drawamount");
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)loanBill.getString("repaymentway"));
        long loanBillId = loanBill.getLong("id");
        List<PlanCallResult> repayList = request.getRepayList() == null ? LoanBillRepaymentPlanHelper.getAllRepayList(loanBillId) : request.getRepayList();
        List<RateExtInfo> rateList = LoanBillRateHelper.getRateList(loanBill);
        return InterestCalcParam.build(repayList, rateList, beginDate, request.getEndDate(), principle, 1, repayWay, intHTRule, request.isPreInt()).setCalcOverInt(request.isCalcOverInt());
    }

    private IntHTRuleEnum getIntHTRule(DynamicObject loanBill) {
        DynamicObject factory = loanBill.getDynamicObject("productfactory");
        return EmptyUtil.isNoEmpty((DynamicObject)factory) ? IntHTRuleEnum.valueOf((String)factory.getString("intheadtailrule")) : IntHTRuleEnum.headnotail;
    }

    private Date getBeginIntDate(DynamicObject loanBill, Date beginDate) {
        Date startIntDate = loanBill.getDate("startintdate");
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            return startIntDate;
        }
        return beginDate.compareTo(startIntDate) < 0 ? startIntDate : beginDate;
    }

    public IntBillExtInfo callInt(Long loanBillid, Date endDate, BigDecimal repayAmt) {
        DynamicObject loanBill = InterestCalcHelper.getLoanBill(loanBillid);
        return this.callInt(loanBill, endDate, repayAmt);
    }

    public IntBillExtInfo callInt(DynamicObject loanBill, Date endDate, BigDecimal repayAmt) {
        Date beginDate = loanBill.getDate("endinstdate");
        beginDate = EmptyUtil.isEmpty((Object)beginDate) ? loanBill.getDate("startintdate") : DateUtils.getNextDay((Date)beginDate, (int)1);
        return this.callInt(loanBill, beginDate, endDate, repayAmt, false);
    }

    private IntBillExtInfo callInt(DynamicObject loanBill, Date beginDate, Date endDate, BigDecimal principle, boolean isRpt) {
        IntHTRuleEnum intHTRule = this.getIntHTRule(loanBill);
        List<Object> rateList = LoanBillRateHelper.getRateList(loanBill);
        if ((rateList = rateList.stream().filter(r -> r.getRate().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList())).size() == 0 || EmptyUtil.isEmpty((String)loanBill.getString("repaymentway"))) {
            return null;
        }
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)loanBill.getString("repaymentway"));
        List<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(16);
        int period = 0;
        if (isRpt) {
            List<PlanCallResult> repayPlans = LoanBillRepaymentPlanHelper.getAllRepayList(loanBill.getLong("id"));
            for (PlanCallResult rp : repayPlans) {
                if (rp.getBizDate().compareTo(beginDate) < 0 || rp.getBizDate().compareTo(endDate) > 0) continue;
                rp.setPayInt(false);
                repayPlanList.add(rp);
            }
            if (RepaymentWayEnum.debx.getValue().equals(loanBill.getString("repaymentway")) && (period = (repayPlanList = this.initDebxPrinciple(repayPlanList)).size()) == 0) {
                return null;
            }
        }
        InterestCalcParam param = InterestCalcParam.build(repayPlanList, rateList, beginDate, endDate, principle, period, repayWay, intHTRule, false);
        return this.callLoanBillInt(loanBill, param);
    }

    private List<PlanCallResult> initDebxPrinciple(List<PlanCallResult> repayList) {
        for (PlanCallResult repayPlan : repayList) {
            repayPlan.setPrinciple(BigDecimal.ZERO);
        }
        return repayList;
    }

    public IntBillExtInfo callInt(DynamicObject loanBill, Date beginDate, Date endDate, BigDecimal principle) {
        Date startIntDate = loanBill.getDate("startintdate");
        Date expireDate = loanBill.getDate("expiredate");
        Date renewalExpireDate = loanBill.getDate("renewalexpiredate");
        Date clearDate = loanBill.getDate("cleardate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpireDate)) {
            expireDate = renewalExpireDate;
        }
        beginDate = EmptyUtil.isEmpty((Object)beginDate) ? startIntDate : (beginDate.compareTo(startIntDate) >= 0 ? beginDate : startIntDate);
        Date date = endDate = endDate.compareTo(expireDate) >= 0 ? expireDate : endDate;
        if (EmptyUtil.isNoEmpty((Object)clearDate)) {
            endDate = endDate.compareTo(clearDate) >= 0 ? clearDate : endDate;
        }
        return this.callInt(loanBill, beginDate, endDate, principle, true);
    }

    public Map<Long, List<IntBillExtInfo>> batchCalcLoanBillSegmInt(List<CalcInterestSegmRequest> requests) {
        HashMap<Long, List<IntBillExtInfo>> intBillInfoMap = new HashMap<Long, List<IntBillExtInfo>>(requests.size());
        if (EmptyUtil.isEmpty(requests)) {
            return intBillInfoMap;
        }
        List<Long> loanBillIds = requests.stream().map(CalcInterestSegmRequest::getLoanBillId).collect(Collectors.toList());
        List<DynamicObject> loanBills = InterestCalcHelper.getLoanBills(loanBillIds);
        Map<Long, DynamicObject> loanBillMap = loanBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        for (CalcInterestSegmRequest request : requests) {
            List<IntBillExtInfo> intBillInfos = this.calcLoanBillSegmInt(request, loanBillMap.get(request.getLoanBillId()));
            intBillInfoMap.put(request.getLoanBillId(), intBillInfos);
        }
        return intBillInfoMap;
    }

    public List<IntBillExtInfo> calcLoanBillSegmInt(CalcInterestSegmRequest request) {
        DynamicObject loanBill = InterestCalcHelper.getLoanBill(request.getLoanBillId());
        return this.calcLoanBillSegmInt(request, loanBill);
    }

    private List<IntBillExtInfo> calcLoanBillSegmInt(CalcInterestSegmRequest request, DynamicObject loanBill) {
        List<CalcInterestSegmRequest.DateParam> dateParams = request.getDateParams();
        ArrayList<IntBillExtInfo> intBillInfos = new ArrayList<IntBillExtInfo>(dateParams.size());
        dateParams.sort(Comparator.comparing(CalcInterestSegmRequest.DateParam::getBeginDate));
        for (CalcInterestSegmRequest.DateParam dateParam : dateParams) {
            InterestCalcRequest calcRequest = InterestCalcRequest.build(loanBill, dateParam.getBeginDate(), dateParam.getEndDate());
            IntBillExtInfo intBillInfo = this.callLoanBillInt(calcRequest);
            if (intBillInfo == null) continue;
            intBillInfos.add(intBillInfo);
        }
        return intBillInfos;
    }
}

