/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.calcint;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.bean.InterestCalcParam;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillRateHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntPrincipleRuleEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.RateExtInfo;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;

public class LoanBillCalcNormalIntHandle {
    private static final Log logger = LogFactory.getLog(LoanBillCalcNormalIntHandle.class);

    public IntBillExtInfo callLoanInt(DynamicObject loanBill, InterestCalcParam calcParam) {
        IntBillExtInfo narmalInt;
        Date endDate = calcParam.getEndDate();
        Date beginDate = calcParam.getBeginDate();
        Date expireDate = loanBill.getDate("expiredate");
        Date callDate = endDate.after(expireDate) ? expireDate : endDate;
        boolean isNoFixedTerm = loanBill.getBoolean("isnofixedterm");
        if (isNoFixedTerm) {
            callDate = endDate;
        }
        InterestCalcParam narmalParam = calcParam.clone();
        IntBillExtInfo intBill = narmalInt = this.calcLoanBillInt(loanBill, narmalParam.setEndDate(callDate));
        if (!isNoFixedTerm) {
            IntBillExtInfo extendInt;
            if (EmptyUtil.isNoEmpty((Object)narmalInt)) {
                beginDate = DateUtils.getNextDay((Date)narmalInt.getEndDate(), (int)1);
            }
            if (EmptyUtil.isNoEmpty((Object)(extendInt = this.calcLoanBillExtendInt(loanBill, calcParam.clone(), beginDate)))) {
                beginDate = DateUtils.getNextDay((Date)extendInt.getEndDate(), (int)1);
            }
            IntBillExtInfo overInt = null;
            if (calcParam.isCalcOverInt()) {
                overInt = this.calcLoanBillOverInt(loanBill, calcParam.clone(), beginDate);
            }
            intBill = this.mergeIntBillInfo(intBill, extendInt);
            intBill = this.mergeIntBillInfo(intBill, overInt);
        }
        if (EmptyUtil.isNoEmpty((Object)intBill)) {
            this.setCallIntDate((IntBillInfo)intBill);
        }
        return intBill;
    }

    private IntBillExtInfo calcLoanBillExtendInt(DynamicObject loanBill, InterestCalcParam calcParam, Date beginDate) {
        IntBillExtInfo extendInt = null;
        Date extendDate = loanBill.getDate("renewalexpiredate");
        Date expireDate = loanBill.getDate("expiredate");
        Date endDate = calcParam.getEndDate();
        if (EmptyUtil.isNoEmpty((Object)extendDate) && endDate.after(expireDate)) {
            calcParam.setBeginDate(beginDate);
            calcParam.setEndDate(extendDate.after(endDate) ? endDate : extendDate);
            extendInt = this.calcLoanBillInt(loanBill, calcParam);
            if (null != extendInt && EmptyUtil.isNoEmpty((Object)extendInt.getDetails())) {
                extendInt.getDetails().forEach(e -> e.setIntType(InterTypeEnum.extend));
                extendInt.getExtDetails().forEach(e -> e.setIntType(InterTypeEnum.extend));
            }
        }
        return extendInt;
    }

    private IntBillExtInfo calcLoanBillOverInt(DynamicObject loanBill, InterestCalcParam calcParam, Date beginDate) {
        Date expireDate;
        IntBillExtInfo overInt = null;
        Date extendDate = loanBill.getDate("renewalexpiredate");
        Date date = expireDate = extendDate != null ? extendDate : loanBill.getDate("expiredate");
        if (calcParam.getEndDate().after(expireDate)) {
            if (beginDate == null || beginDate.compareTo(expireDate) < 0) {
                beginDate = expireDate;
            }
            calcParam.setBeginDate(beginDate);
            List<RateExtInfo> rateList = calcParam.getRateList();
            RateExtInfo overRateInfo = LoanBillRateHelper.getOverRate(loanBill, rateList);
            if (overRateInfo != null) {
                rateList.clear();
                rateList.add(overRateInfo);
                calcParam.setRateList(rateList);
            }
            if (null != (overInt = this.calcLoanBillInt(loanBill, calcParam)) && EmptyUtil.isNoEmpty((Object)overInt.getDetails())) {
                overInt.getDetails().forEach(e -> e.setIntType(InterTypeEnum.overdue));
                overInt.getExtDetails().forEach(e -> e.setIntType(InterTypeEnum.overdue));
            }
        }
        return overInt;
    }

    private IntBillExtInfo mergeIntBillInfo(IntBillExtInfo intBill, IntBillExtInfo extendInt) {
        if (EmptyUtil.isEmpty((Object)intBill)) {
            intBill = extendInt;
        } else if (EmptyUtil.isNoEmpty((Object)extendInt) && EmptyUtil.isNoEmpty((BigDecimal)extendInt.getAmount())) {
            intBill.setAmount(intBill.getAmount().add(extendInt.getAmount()));
            intBill.setFloatInt(intBill.getFloatInt().add(extendInt.getFloatInt()));
            intBill.setBenchmarkInt(intBill.getBenchmarkInt().add(extendInt.getBenchmarkInt()));
            intBill.getDetails().addAll(extendInt.getDetails());
            intBill.getExtDetails().addAll(extendInt.getExtDetails());
        }
        return intBill;
    }

    private void setCallIntDate(IntBillInfo intBill) {
        List detailList = intBill.getDetails();
        IntBillDetailInfo detail = detailList.stream().min(Comparator.comparing(IntBillDetailInfo::getBeginDate)).orElse(null);
        if (EmptyUtil.isNoEmpty((Object)detail)) {
            intBill.setBeginDate(detail.getBeginDate());
        }
        if (EmptyUtil.isNoEmpty((Object)(detail = (IntBillDetailInfo)detailList.stream().max(Comparator.comparing(IntBillDetailInfo::getEndDate)).orElse(null)))) {
            intBill.setEndDate(detail.getEndDate());
        }
    }

    private IntBillExtInfo calcLoanBillInt(DynamicObject loanBill, InterestCalcParam param) {
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(param.getRepayPlanList());
        BizBillInfo bizBill = this.getBizBill(loanBill, param);
        request.setBizBill(bizBill);
        List<RateExtInfo> rateList = param.getRateList();
        request.setRateList(RateExtInfo.convertRateInfo(rateList));
        request.setPreInt(param.isPreInt());
        logger.info("calcLoanBillInt verifyInput request: {}:\n" + SerializationUtils.toJsonString((Object)request));
        this.verifyInput(request);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return null;
        }
        IntBillExtInfo billExtInfo = IntBillExtInfo.clone((IntBillInfo)intBillInfo);
        if (intBillInfo.getDetails() == null) {
            return billExtInfo;
        }
        this.updateFloatInt(loanBill, billExtInfo, param);
        return billExtInfo;
    }

    private void updateFloatInt(DynamicObject loanBill, IntBillExtInfo billExtInfo, InterestCalcParam param) {
        List extDetails = billExtInfo.getExtDetails();
        if (EmptyUtil.isEmpty((Collection)extDetails)) {
            return;
        }
        BigDecimal floatPoint = LoanBillRateHelper.getFloatRate(loanBill);
        if (EmptyUtil.isEmpty((BigDecimal)floatPoint)) {
            billExtInfo.setFloatInt(BigDecimal.ZERO);
            billExtInfo.setBenchmarkInt(billExtInfo.getAmount());
            for (IntBillDetailExtInfo detail : extDetails) {
                detail.setBenchmarkInt(detail.getAmount());
                detail.setFloatInt(BigDecimal.ZERO);
            }
            return;
        }
        BasisEnum basis = BasisEnum.getEnum((String)loanBill.getString("basis"));
        basis = basis == null ? BasisEnum.Actual_365 : basis;
        boolean isSofr = LoanBillHelper.isSofr(loanBill);
        TreeMap<Date, RateExtInfo> rateMap = new TreeMap<Date, RateExtInfo>(param.getRateList().stream().collect(Collectors.toMap(RateInfo::getEffectiveDate, r -> r, (r1, r2) -> r1)));
        for (IntBillDetailExtInfo detail : extDetails) {
            BigDecimal rate = detail.getRate();
            BigDecimal amount = detail.getAmount();
            BigDecimal floatRate = floatPoint;
            Map.Entry<Date, RateExtInfo> entry = rateMap.floorEntry(detail.getBeginDate());
            if (entry != null) {
                floatRate = entry.getValue().getFloatRate();
            }
            BigDecimal floatInt = isSofr ? this.getSofrFloatInt(floatRate, basis, detail, param.getScale()) : (EmptyUtil.isNoEmpty((BigDecimal)rate) ? amount.multiply(floatRate.divide(rate, 20, RoundingMode.HALF_UP)) : BigDecimal.ZERO);
            detail.setFloatRate(floatRate);
            floatInt = floatInt.setScale((int)param.getScale(), RoundingMode.HALF_UP);
            detail.setFloatInt(floatInt);
            BigDecimal normalInt = amount.subtract(floatInt);
            detail.setBenchmarkInt(normalInt.setScale((int)param.getScale(), RoundingMode.HALF_UP));
        }
        BigDecimal floatInt = extDetails.stream().map(IntBillDetailExtInfo::getFloatInt).reduce(BigDecimal.ZERO, BigDecimal::add);
        billExtInfo.setFloatInt(floatInt.setScale((int)param.getScale(), RoundingMode.HALF_UP));
        BigDecimal normalInt = extDetails.stream().map(IntBillDetailExtInfo::getBenchmarkInt).reduce(BigDecimal.ZERO, BigDecimal::add);
        billExtInfo.setBenchmarkInt(normalInt.setScale((int)param.getScale(), RoundingMode.HALF_UP));
    }

    private BigDecimal getSofrFloatInt(BigDecimal floatRate, BasisEnum basis, IntBillDetailExtInfo detail, int scale) {
        if (EmptyUtil.isNoEmpty((BigDecimal)floatRate)) {
            CalcIntInfo calcIntInfo = CalcIntInfo.build((Date)detail.getBeginDate(), (Date)detail.getEndDate(), (BigDecimal)detail.getPrinciple(), (BigDecimal)floatRate, (BasisEnum)basis);
            return calcIntInfo.callTotalInt(scale, 4);
        }
        return BigDecimal.ZERO;
    }

    private void verifyInput(IntCalRequest request) {
        Date beginDate = request.getBizBill().getBeginDate();
        Date minRateDate = request.getRateList().stream().map(RateInfo::getEffectiveDate).min(Comparator.comparing(Date::getTime)).orElse(null);
        if (minRateDate == null || minRateDate.compareTo(beginDate) > 0) {
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u5229\u606f\u8ba1\u7b97\u5f00\u59cb\u65e5\u5fc5\u987b\u8981\u6709\u53ef\u7528\u5229\u7387\u3002", (String)"InterestCalcHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0])});
        }
    }

    private BizBillInfo getBizBill(DynamicObject loanBill, InterestCalcParam param) {
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(param.getPrinciple());
        bizBill.setBeginDate(param.getBeginDate());
        bizBill.setEndDate(param.getEndDate());
        DynamicObject stagePlan = loanBill.getDynamicObject("stageplan");
        if (EmptyUtil.isNoEmpty((DynamicObject)stagePlan)) {
            bizBill.setRepaySchemeId(stagePlan.getLong("id"));
        }
        bizBill.setRepayWay(param.getRepayWay());
        BasisEnum basis = BasisEnum.getEnum((String)loanBill.getString("basis"));
        bizBill.setBasis(basis == null ? BasisEnum.Actual_365 : basis);
        bizBill.setScale(Integer.valueOf(loanBill.getDynamicObject("currency").getInt("amtprecision")));
        bizBill.setCurrencyId(loanBill.getDynamicObject("currency").getLong("id"));
        bizBill.setPeriod(param.getPeriod());
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            bizBill.setPrincipleRule(IntPrincipleRuleEnum.valueOf((String)productFactory.getString("intcapitalrule")));
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
        }
        bizBill.setIntCalMethod(this.getIntCalMethod(loanBill));
        bizBill.setHtRule(param.getIntHTRule());
        bizBill.setLastTotalInt(param.getLastTotalInt());
        bizBill.setScale(param.getScale());
        bizBill.setStartIntDate(loanBill.getDate("startintdate"));
        return bizBill;
    }

    private IntCalMethodEnum getIntCalMethod(DynamicObject loanBill) {
        IntCalMethodEnum result;
        String loanType = loanBill.getString("loantype");
        IntCalMethodEnum intCalMethodEnum = result = !LoanTypeEnum.isBond(loanType) ? IntCalMethodEnum.totalcallint : IntCalMethodEnum.onecallint;
        if (!LoanTypeEnum.isBond(loanType) && EmptyUtil.isNoEmpty((String)loanBill.getString("intcalmethod"))) {
            result = IntCalMethodEnum.valueOf((String)loanBill.getString("intcalmethod"));
        }
        return result;
    }
}

