/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.calcint;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.bean.InterestCalcParam;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillCalcNormalIntHandle;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;

public class LoanBillCalcSofrIntHandle {
    private static final LoanBillCalcNormalIntHandle calcIntHandle = new LoanBillCalcNormalIntHandle();

    public IntBillExtInfo callLoanInt(DynamicObject loanBill, InterestCalcParam calcParam) {
        IntBillExtInfo intBillExt = calcIntHandle.callLoanInt(loanBill, calcParam);
        if (intBillExt == null) {
            return null;
        }
        this.updateComfirmDate(loanBill, intBillExt.getExtDetails());
        return intBillExt;
    }

    private void updateComfirmDate(DynamicObject loanBill, List<IntBillDetailExtInfo> extDetails) {
        DynamicObjectCollection workCalendars = loanBill.getDynamicObjectCollection("workcalendar");
        if (workCalendars == null) {
            return;
        }
        Map<Date, Boolean> workCalendarMap = this.getWorkCalendarMap(extDetails, workCalendars);
        int rateResetDays = CfmBillCommonHelper.getSofrDiffDays(loanBill);
        int size = extDetails.size();
        for (int i = 0; i < size; ++i) {
            IntBillDetailExtInfo detail = extDetails.get(i);
            detail.setObserveOffsetDay(1);
            detail.setBeginConfirmDate(CfmRateAdjustHelper.getConfirmDateByRateRestDays(workCalendarMap, rateResetDays, detail.getBeginDate()));
            Date endDate = DateUtils.getNextDay((Date)detail.getEndDate(), (int)1);
            detail.setEndConfirmDate(CfmRateAdjustHelper.getConfirmDateByRateRestDays(workCalendarMap, rateResetDays, endDate));
        }
    }

    public Map<Date, Boolean> getWorkCalendarMap(List<IntBillDetailExtInfo> extDetails, DynamicObjectCollection workCalendars) {
        Date maxEndDate = extDetails.stream().map(IntBillDetailInfo::getEndDate).max(Date::compareTo).get();
        Date minBeginDate = extDetails.stream().map(IntBillDetailInfo::getEndDate).min(Date::compareTo).get();
        return CfmRateAdjustHelper.getWorkCalendarMap(workCalendars, minBeginDate, maxEndDate);
    }
}

