/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.calcint;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.bean.InterestCalcParam;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.enums.InschemeEnum;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillCalcIntService;
import kd.tmc.cfm.common.service.calcint.LoanBillRateHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillRepaymentPlanHelper;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RateCycleWayEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateExtInfo;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.model.interest.WorkCalendarAdjustParam;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.factory.PlanCallStragetyFactory;
import org.apache.commons.lang3.tuple.Pair;

public class LoanBillIntPlanService {
    private static final LoanBillCalcIntService loanBillCalcIntService = new LoanBillCalcIntService();

    public Pair<BigDecimal, List<IntBillExtInfo>> callIntPlan(DynamicObject loanBill) {
        boolean isPayOff;
        Date beginDate = this.getIntBeginDate(loanBill);
        Date endDate = loanBill.getDate("expiredate");
        Date extendDate = loanBill.getDate("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)extendDate)) {
            endDate = extendDate;
        }
        boolean bl = isPayOff = loanBill.getBigDecimal("notrepayamount").compareTo(BigDecimal.ZERO) <= 0;
        if (!RepaymentWayEnum.isHbfx((String)loanBill.getString("repaymentway")) && isPayOff) {
            Date lastPayDate = loanBill.getDate("lastrepaydate");
            Date lastIntDate = loanBill.getDate("endinstdate");
            if (lastPayDate != null && (lastIntDate == null || lastPayDate.compareTo(lastIntDate) > 0)) {
                InterestCalcRequest request = InterestCalcRequest.build(loanBill, beginDate, lastPayDate, false);
                request.setRepayList(LoanBillRepaymentPlanHelper.getAllRepayList(loanBill.getLong("id"), beginDate));
                IntBillExtInfo intBillExt = InterestCalcHelper.callInt(request);
                return Pair.of((Object)BigDecimal.ZERO, intBillExt != null ? Collections.singletonList(intBillExt) : Collections.emptyList());
            }
            return Pair.of((Object)BigDecimal.ZERO, Collections.emptyList());
        }
        DynamicObject intSchema = loanBill.getDynamicObject("interestsettledplan");
        if (intSchema != null && InschemeEnum.isCustom(intSchema.getString("intereststpd"))) {
            return Pair.of((Object)BigDecimal.ZERO, Collections.emptyList());
        }
        List<PlanCallResult> intPlanList = this.callIntPlan(loanBill, endDate);
        return this.genIntPlan(loanBill, intPlanList, beginDate);
    }

    public Pair<BigDecimal, List<IntBillExtInfo>> callIntPlanByHand(DynamicObject loanBill, List<PlanCallResult> intPlanList) {
        Date beginDate = this.getIntBeginDate(loanBill);
        return this.genIntPlan(loanBill, intPlanList, beginDate);
    }

    private Date getIntBeginDate(DynamicObject loanBill) {
        Date beginDate = loanBill.getDate("startintdate");
        Date lastIntDate = loanBill.getDate("endinstdate");
        if (EmptyUtil.isNoEmpty((Object)lastIntDate)) {
            beginDate = DateUtils.getNextDay((Date)lastIntDate, (int)1);
        }
        return beginDate;
    }

    private Pair<BigDecimal, List<IntBillExtInfo>> genIntPlan(DynamicObject loanBill, List<PlanCallResult> intPlanList, Date startDate) {
        ArrayList<IntBillExtInfo> list = new ArrayList<IntBillExtInfo>(10);
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)loanBill.getString("repaymentway"));
        IntHTRuleEnum htRuleEnum = this.getIntHTRule(loanBill);
        BigDecimal principle = loanBill.getBigDecimal("drawamount");
        List<RateExtInfo> rateList = LoanBillRateHelper.getRateList(loanBill);
        List<PlanCallResult> repayPlanList = LoanBillRepaymentPlanHelper.getAllRepayPlanList(loanBill);
        boolean isDebx = RepaymentWayEnum.isDebx((String)loanBill.getString("repaymentway"));
        if (isDebx) {
            this.initDebxPrinciple(repayPlanList);
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        intPlanList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        int size = intPlanList.size();
        for (int index = 0; index < size; ++index) {
            BigDecimal amount;
            Date beginDate = startDate;
            PlanCallResult intPlan = intPlanList.get(index);
            Date endDate = intPlan.getBizDate();
            InterestCalcParam calcParam = InterestCalcParam.build(repayPlanList, rateList, beginDate, endDate, principle, index + 1, repayWay, htRuleEnum, false).setLastTotalInt(BigDecimal.ZERO);
            IntBillExtInfo intBillExt = loanBillCalcIntService.callLoanBillInt(loanBill, calcParam, true);
            if (null == intBillExt) continue;
            List details = intBillExt.getExtDetails();
            if (endDate.compareTo(intBillExt.getBizDate()) != 0) {
                intBillExt.setBizDate(endDate);
            }
            if (isDebx && EmptyUtil.isNoEmpty((Object)details)) {
                repayPlanList.get(index).setPrinciple(((IntBillDetailExtInfo)details.get(0)).getPrinciple());
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)(amount = intBillExt.getAmount()))) {
                list.add(intBillExt);
                totalAmt = totalAmt.add(amount);
            }
            if (!intPlan.getBizDate().after(startDate)) continue;
            int addDays = htRuleEnum == IntHTRuleEnum.noheadnotail || htRuleEnum == IntHTRuleEnum.noheadtail ? 0 : 1;
            startDate = DateUtils.getNextDay((Date)intBillExt.getEndDate(), (int)addDays);
        }
        int loanBillScale = loanBillCalcIntService.getLoanBillScale(loanBill);
        return Pair.of((Object)totalAmt.setScale(loanBillScale, RoundingMode.HALF_UP), list);
    }

    private List<PlanCallResult> initDebxPrinciple(List<PlanCallResult> repayList) {
        for (PlanCallResult repayPlan : repayList) {
            repayPlan.setPrinciple(BigDecimal.ZERO);
        }
        return repayList;
    }

    private IntHTRuleEnum getIntHTRule(DynamicObject loanBill) {
        DynamicObject factory = loanBill.getDynamicObject("productfactory");
        IntHTRuleEnum intHTRule = IntHTRuleEnum.headnotail;
        if (EmptyUtil.isNoEmpty((DynamicObject)factory)) {
            intHTRule = IntHTRuleEnum.valueOf((String)factory.getString("intheadtailrule"));
        }
        return intHTRule;
    }

    private List<PlanCallResult> callIntPlan(DynamicObject loanBill, Date endDate) {
        boolean isFixCycleAdjust;
        List<PlanCallResult> repayPlanList = LoanBillRepaymentPlanHelper.getAllRepayPlanList(loanBill);
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)loanBill.getString("repaymentway"));
        SettleIntModeEnum settleMode = SettleIntModeEnum.valueOf((String)loanBill.getString("settleintmode"));
        RepayPlanCallRequest request = new RepayPlanCallRequest();
        request.setBeginDate(loanBill.getDate("startintdate")).setEndDate(endDate).setRepayWay(repayWay).setBalanceList(repayPlanList).setSettleIntMode(settleMode);
        RepaySchemeInfo schemeInfo = this.trans2RepaySchemeInfo(loanBill);
        request.setSchemeInfo(schemeInfo);
        WorkCalendarAdjustParam adjustParam = LoanBillHelper.buildWorkCalendarAdjustParam(loanBill, "payintadjustrule");
        boolean bl = isFixCycleAdjust = schemeInfo != null && RepaySchemeEnum.isToCycle((String)schemeInfo.getRepayScheme().getValue()) && RateCycleWayEnum.FixCycle == adjustParam.getRateCycleWay();
        if (isFixCycleAdjust) {
            request.setWorkCalendarAdjustParam(adjustParam);
        }
        List<PlanCallResult> callResults = PlanCallStragetyFactory.createIntPlanCallStragety().createPlan(request);
        if (!isFixCycleAdjust) {
            callResults = this.updatePlanListByAdjustRule(callResults, adjustParam);
        }
        return callResults;
    }

    public List<PlanCallResult> updatePlanListByAdjustRule(List<PlanCallResult> callResults, WorkCalendarAdjustParam adjustParam) {
        if (adjustParam == null || !adjustParam.isCanAdjust()) {
            return callResults;
        }
        AdjustMethodEnum adjustMethod = adjustParam.getAdjustMethod();
        Map<Date, PlanCallResult> datePlanMap = callResults.stream().collect(Collectors.toMap(PlanCallResult::getBizDate, r -> r, (r1, r2) -> r1));
        for (PlanCallResult callResult : callResults) {
            Date adjustBizDate;
            Date bizDate = callResult.getBizDate();
            if (bizDate.compareTo(adjustBizDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)adjustParam.getWorkCalendars(), (Date)bizDate, (AdjustMethodEnum)adjustMethod)) == 0) continue;
            datePlanMap.remove(bizDate);
            callResult.setBizDate(adjustBizDate);
            datePlanMap.put(adjustBizDate, callResult);
        }
        ArrayList<PlanCallResult> planList = new ArrayList<PlanCallResult>(datePlanMap.values());
        planList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        return planList;
    }

    private RepaySchemeInfo trans2RepaySchemeInfo(DynamicObject loanBill) {
        DynamicObject intSchema = loanBill.getDynamicObject("interestsettledplan");
        if (intSchema == null) {
            return null;
        }
        DynamicObject schemeObj = TmcDataServiceHelper.loadSingleFromCache((Object)intSchema.getLong("id"), (String)"cfm_inscheme");
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        schemeInfo.setRepayScheme(RepaySchemeEnum.getByValue((String)schemeObj.getString("intereststpd")));
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)schemeObj.getString("intereststmh")));
        String day = schemeObj.getString("intereststday");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        schemeInfo.setOffetDay(Integer.valueOf(schemeObj.getInt("offetday")));
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(schemeObj.getBoolean("drawmonthsettle")));
        return schemeInfo;
    }
}

