/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.repository.LoanContractBillRepository;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillContractWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        Map<Long, List<DynamicObject>> loanBillMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        ArrayList<DynamicObject> contractBills = new ArrayList<DynamicObject>(loanBillMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : loanBillMap.entrySet()) {
            contractBills.add(entry.getValue().get(0).getDynamicObject("loancontractbill"));
        }
        this.batchWriteBackContractBill(contractBills);
        Map<Long, DynamicObject> contractBillMap = contractBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        for (Map.Entry<Long, List<DynamicObject>> entry : loanBillMap.entrySet()) {
            DynamicObject contractBill = contractBillMap.get(entry.getKey());
            for (DynamicObject loanBill : entry.getValue()) {
                this.writerContractDrawPlan(contractBill, loanBill);
            }
        }
    }

    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.logger.info("\u53cd\u5199\u5408\u540c\u91d1\u989d\u548c\u8fd8\u6b3e\u8ba1\u5212, param:{}", (Object)param);
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    private void batchWriteBackContractBill(Collection<DynamicObject> contractBills) {
        if (EmptyUtil.isEmpty(contractBills)) {
            return;
        }
        Map<Long, DynamicObject> contractBillMap = contractBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        Map<Long, ContractBillAmountSumDTO> contractMap = LoanContractBillRepository.getContractBillAmountSum(contractBillMap, null);
        for (DynamicObject contractBill : contractBills) {
            long contractId = contractBill.getLong("id");
            ContractBillAmountSumDTO sumDTO = contractMap.get(contractId);
            contractBill.set("drawamount", (Object)sumDTO.getDrawedAmt());
            contractBill.set("notdrawamount", (Object)sumDTO.getUnDrawAmt());
            contractBill.set("notpayinterestamount", (Object)sumDTO.getCalIntAmt());
            contractBill.set("notrepayamount", (Object)sumDTO.getNotRepayAmt());
            if (sumDTO.getDrawedAmt().compareTo(BigDecimal.ZERO) > 0) {
                contractBill.set("contractstatus", (Object)LoanContractStatusEnum.EXECUTING.getValue());
                continue;
            }
            contractBill.set("contractstatus", (Object)LoanContractStatusEnum.REGISTERED.getValue());
        }
    }

    private void writerContractDrawPlan(DynamicObject contractBill, DynamicObject loanBill) {
        DynamicObjectCollection drawPlanEntry = contractBill.getDynamicObjectCollection("drawdownplan_entry");
        if (drawPlanEntry.isEmpty()) {
            return;
        }
        String drawState = ConfirmStatusEnum.isYetconfirm(loanBill.getString("confirmstatus")) ? "1" : "0";
        Date bizDate = loanBill.getDate("bizdate");
        BigDecimal drawAmount = loanBill.getBigDecimal("drawamount");
        boolean isUpdate = false;
        for (DynamicObject drawPlan : drawPlanEntry) {
            if (bizDate.compareTo(drawPlan.getDate("e_plandrawdate")) != 0 || drawAmount.compareTo(drawPlan.getBigDecimal("e_plandrawamt")) != 0) continue;
            drawPlan.set("e_drawstate", (Object)drawState);
            drawPlan.set("e_drawacctbank", DataSourceEnum.isInvest(loanBill.getString("datasource")) ? loanBill.get("loaneracctbank") : loanBill.get("accountbank"));
            isUpdate = true;
            break;
        }
        if (!isUpdate) {
            this.generateDrawPlan(contractBill);
        }
    }

    private void generateDrawPlan(DynamicObject contractBill) {
        DynamicObject[] loanBills;
        DynamicObjectCollection drawPlanEntry = contractBill.getDynamicObjectCollection("drawdownplan_entry");
        int seq = 1;
        this.getUnExecutedPlanEntry(drawPlanEntry, seq);
        seq = drawPlanEntry.size() + 1;
        for (DynamicObject loanObj : loanBills = LoanBillRepository.getLoanBillByContractId(contractBill.getLong("id"))) {
            LoanBillContractWriteService.createDrawPlanEntry(drawPlanEntry.addNew(), loanObj, seq++);
        }
        drawPlanEntry.sort(Comparator.comparing(o -> o.getDate("e_plandrawdate")));
        for (int i = 0; i <= drawPlanEntry.size() - 1; ++i) {
            ((DynamicObject)drawPlanEntry.get(i)).set("seq", (Object)(i + 1));
        }
    }

    private DynamicObjectCollection getUnExecutedPlanEntry(DynamicObjectCollection drawPlanEntry, int seq) {
        DynamicObjectCollection newPlanEntry = TmcDataServiceHelper.newDynamicObject((String)"cfm_loancontractbill").getDynamicObjectCollection("drawdownplan_entry");
        for (DynamicObject drawPlan : drawPlanEntry) {
            if (!"0".equals(drawPlan.getString("e_drawstate"))) continue;
            newPlanEntry.add((Object)drawPlan);
            ++seq;
        }
        drawPlanEntry.clear();
        drawPlanEntry.addAll((Collection)newPlanEntry);
        return drawPlanEntry;
    }

    private static void createDrawPlanEntry(DynamicObject planEntry, DynamicObject loanBill, int seq) {
        planEntry.set("seq", (Object)seq);
        planEntry.set("e_plandrawdate", (Object)loanBill.getDate("bizdate"));
        planEntry.set("e_plandrawamt", (Object)loanBill.getBigDecimal("drawamount"));
        planEntry.set("e_drawstate", (Object)"1");
        planEntry.set("e_drawacctbank", DataSourceEnum.isInvest(loanBill.getString("datasource")) ? loanBill.get("loaneracctbank") : loanBill.get("accountbank"));
        planEntry.set("e_drawmodifier", (Object)RequestContext.get().getCurrUserId());
        planEntry.set("e_drawmodifytime", (Object)DateUtils.getCurrentTime());
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        LoanWBTypeEnum loanWBType = param.getLoanWBType();
        return LoanWBTypeEnum.UPDATECONTRACT == loanWBType || LoanWBTypeEnum.UPDATEAMOUNT == loanWBType;
    }
}

