/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanBillIntPlanWriteService
extends AbstractLoanBillWriteService {
    private static final Log logger = LogFactory.getLog(LoanBillIntPlanWriteService.class);

    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        List<Long> loanBillIds = loanBills.stream().map(l -> l.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> interestBillMap = InterestBillRepository.loadComfirmInterestBills(loanBillIds, Boolean.FALSE, Boolean.TRUE);
        List<DynamicObject> handLoanBills = loanBills.stream().filter(l -> l.getBoolean("handinstplan")).collect(Collectors.toList());
        List<DynamicObject> autoLoanBills = loanBills.stream().filter(l -> !l.getBoolean("handinstplan") && !LoanTypeEnum.isFinLease(l.getString("loantype")) && !this.isIntPlanEmpty((DynamicObject)l)).collect(Collectors.toList());
        this.doWriteByHand(handLoanBills, interestBillMap);
        this.doWriteByAuto(autoLoanBills, interestBillMap, param.getLoanWBType());
        this.doWriteLoanContractBill(loanBills);
    }

    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        if (param.isReSaveLoan()) {
            return true;
        }
        if (!LoanWBTypeEnum.isNotPreInterest(param.getLoanWBType())) {
            return false;
        }
        if (this.isFreeRate(loanBill)) {
            return false;
        }
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        return EmptyUtil.isEmpty((DynamicObject)productFactory) || productFactory.getBoolean("iscallint");
    }

    private void doWriteByHand(List<DynamicObject> loanBills, Map<Long, List<DynamicObject>> interestBillMap) {
        for (DynamicObject loanBill : loanBills) {
            List<DynamicObject> interestBills = interestBillMap.get(loanBill.getLong("id"));
            this.updateIntPlanByHand(loanBill, interestBills);
            this.updateLoanBillIntAmt(loanBill, interestBills);
        }
    }

    private void updateLoanBillIntAmt(DynamicObject loanBill, List<DynamicObject> interestBills) {
        DynamicObjectCollection intPlans = loanBill.getDynamicObjectCollection("interest_entry");
        BigDecimal totalIntPlanAmts = intPlans.stream().map(o -> o.getBigDecimal("interestcalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payedIntAmt = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty(interestBills)) {
            payedIntAmt = interestBills.stream().map(o -> o.getBigDecimal("convertintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal afterTotalIntPlanAmts = totalIntPlanAmts.subtract(payedIntAmt);
        loanBill.set("calculaterateamount", (Object)afterTotalIntPlanAmts);
        loanBill.set("payinterestamount", (Object)payedIntAmt);
    }

    private void doWriteLoanContractBill(List<DynamicObject> loanBills) {
        Map<Long, List<DynamicObject>> contractMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        Map<Long, ContractBillAmountSumDTO> intPlanMap = LoanBillRepository.getLoanIntPlanAmountByContractId(contractMap.keySet(), this.getBillIds(loanBills));
        for (Map.Entry<Long, List<DynamicObject>> entry : contractMap.entrySet()) {
            ContractBillAmountSumDTO amountSumDTO = intPlanMap.get(entry.getKey());
            List<DynamicObject> loanBillList = entry.getValue();
            ContractBillAmountSumDTO intAmtSum = this.getLoanBillIntAmt(loanBillList);
            amountSumDTO.setPayedIntAmt(amountSumDTO.getPayedIntAmt().add(intAmtSum.getPayedIntAmt()));
            amountSumDTO.setUnpayIntAmt(amountSumDTO.getUnpayIntAmt().add(intAmtSum.getUnpayIntAmt()));
            for (DynamicObject loanBill : loanBillList) {
                DynamicObject contractBill = this.getContractBill(loanBill);
                contractBill.set("payinterestamount", (Object)amountSumDTO.getPayedIntAmt());
                contractBill.set("notpayinterestamount", (Object)amountSumDTO.getUnpayIntAmt());
            }
        }
    }

    private ContractBillAmountSumDTO getLoanBillIntAmt(List<DynamicObject> loanBills) {
        ContractBillAmountSumDTO statAmtInfo = new ContractBillAmountSumDTO();
        for (DynamicObject loanBill : loanBills) {
            BigDecimal payedIntAmt = BigDecimal.ZERO;
            BigDecimal unpayIntAmt = BigDecimal.ZERO;
            BigDecimal convertRate = LoanBillHelper.getConvertRate(loanBill);
            DynamicObjectCollection interestEntrys = loanBill.getDynamicObjectCollection("interest_entry");
            for (DynamicObject intPlan : interestEntrys) {
                BigDecimal intAmt = intPlan.getBigDecimal("interestcalamount");
                if (RepayStateEnum.isPayed(intPlan.getString("intstate"))) {
                    payedIntAmt = payedIntAmt.add(intAmt);
                    continue;
                }
                unpayIntAmt = unpayIntAmt.add(intAmt);
            }
            payedIntAmt = payedIntAmt.multiply(convertRate);
            unpayIntAmt = unpayIntAmt.multiply(convertRate);
            statAmtInfo.setPayedIntAmt(statAmtInfo.getPayedIntAmt().add(payedIntAmt));
            statAmtInfo.setUnpayIntAmt(statAmtInfo.getUnpayIntAmt().add(unpayIntAmt));
        }
        return statAmtInfo;
    }

    private void doWriteByAuto(List<DynamicObject> loanBills, Map<Long, List<DynamicObject>> interestBillMap, LoanWBTypeEnum loanWBTypeEnum) {
        for (DynamicObject loanBill : loanBills) {
            String repayWay = loanBill.getString("repaymentway");
            Pair<BigDecimal, List<IntBillExtInfo>> intBills = InterestCalcHelper.callIntPlan(loanBill);
            if (LoanWBTypeEnum.REPAYPLAN == loanWBTypeEnum && RepaymentWayEnum.isDebx((String)repayWay)) {
                this.DEBXRepayPlanWriteBack(loanBill, (List)intBills.getValue());
            }
            this.loanBillWriteBack(intBills, loanBill, interestBillMap, Boolean.TRUE);
        }
    }

    private void DEBXRepayPlanWriteBack(DynamicObject loanBill, List<IntBillExtInfo> intBills) {
        for (DynamicObject repayPlan : loanBill.getDynamicObjectCollection("repayplan_entry")) {
            for (IntBillInfo intBillInfo : intBills) {
                if (!intBillInfo.getBizDate().equals(repayPlan.getDate("exrepaymentdate"))) continue;
                BigDecimal principle = ((IntBillDetailInfo)intBillInfo.getDetails().get(0)).getPrinciple();
                repayPlan.set("exdrawamount", (Object)principle);
                repayPlan.set("enotrepayamount", (Object)principle);
            }
        }
    }

    public void loanBillWriteBack(Pair<BigDecimal, List<IntBillExtInfo>> interestCals, DynamicObject loanBill, boolean isUpdateCalInstAmt) {
        List<Long> loanBillIds = Collections.singletonList(loanBill.getLong("id"));
        Map<Long, List<DynamicObject>> payedIntBillMap = InterestBillRepository.loadComfirmInterestBills(loanBillIds, Boolean.FALSE, Boolean.TRUE);
        this.loanBillWriteBack(interestCals, loanBill, payedIntBillMap, isUpdateCalInstAmt);
    }

    private void loanBillWriteBack(Pair<BigDecimal, List<IntBillExtInfo>> interestCals, DynamicObject loanBill, Map<Long, List<DynamicObject>> payedIntBillMap, boolean isUpdateCalInstAmt) {
        DynamicObjectCollection interestEntryDC = loanBill.getDynamicObjectCollection("interest_entry");
        Map<Date, DynamicObject> intDateEntryDMap = interestEntryDC.stream().collect(Collectors.toMap(i -> i.getDate("interesdate"), i -> i, (i1, i2) -> i1));
        intDateEntryDMap.values().forEach(e -> e.set("intstate", (Object)0));
        interestEntryDC.clear();
        this.addIntBillEntryByPayedIntBill(loanBill, interestEntryDC, intDateEntryDMap, payedIntBillMap);
        this.addIntBillEntryByCalculate((List)interestCals.getValue(), loanBill, intDateEntryDMap);
        this.updateIntPlansReq(interestEntryDC);
        if (isUpdateCalInstAmt) {
            this.updateLoanBillIntAmt(loanBill, payedIntBillMap.get(loanBill.getLong("id")));
        }
    }

    private void addIntBillEntryByPayedIntBill(DynamicObject loanBill, DynamicObjectCollection interestEntryDC, Map<Date, DynamicObject> intDateEntryDMap, Map<Long, List<DynamicObject>> payedIntBillMap) {
        List<DynamicObject> payedIntBills = payedIntBillMap.get(loanBill.getLong("id"));
        logger.info("\u63d0\u6b3e\u5355[{}]\u5df2\u4ed8\u5229\u606f\u8bb0\u5f55\u6570:{}", (Object)loanBill.getString("billno"), (Object)payedIntBills.size());
        if (EmptyUtil.isEmpty(payedIntBills)) {
            return;
        }
        int size = payedIntBills.size() - 1;
        for (int i = 0; i <= size; ++i) {
            DynamicObject payedIntBill = payedIntBills.get(i);
            DynamicObject intEntry = this.addLoanBillIntPlanByPayedInt(loanBill, interestEntryDC, payedIntBill, i + 1);
            intDateEntryDMap.put(intEntry.getDate("interesdate"), intEntry);
        }
    }

    private void addIntBillEntryByCalculate(List<IntBillExtInfo> intBills, DynamicObject loanBill, Map<Date, DynamicObject> intDateEntryDMap) {
        DynamicObjectCollection interestEntryDC = loanBill.getDynamicObjectCollection("interest_entry");
        DynamicObject accountBank = loanBill.getDynamicObject("accountbank");
        String intWay = this.getIntWay(loanBill);
        boolean isYkx = LoanBillHelper.isYkx(loanBill);
        int startSeq = this.isHkfx(loanBill) ? 1 : interestEntryDC.size() + 1;
        intBills.sort(Comparator.comparing(IntBillInfo::getBeginDate));
        int size = intBills.size();
        for (int i = 0; i < size; ++i) {
            IntBillExtInfo intBill = intBills.get(i);
            Date interestDate = intBill.getBizDate();
            DynamicObject exsitEntry = intDateEntryDMap.get(interestDate);
            if (exsitEntry != null && exsitEntry.getInt("intstate") == 1) continue;
            Date beginDate = intBill.getBeginDate();
            if (isYkx) {
                if (interestEntryDC.isEmpty()) {
                    interestDate = loanBill.getDate("bizdate");
                    intWay = InterestbillctgEnum.PREPAYINT.getValue();
                } else {
                    Date intDate = ((DynamicObject)interestEntryDC.get(interestEntryDC.size() - 1)).getDate("interesdate");
                    if (beginDate.equals(intDate)) continue;
                }
            }
            List details = intBill.getExtDetails();
            DynamicObject interestEntryDO = interestEntryDC.addNew();
            BigDecimal interestAmount = intBill.getAmount();
            int seq = startSeq + i;
            interestEntryDO.set("seq", (Object)seq);
            interestEntryDO.set("interestseq", (Object)seq);
            interestEntryDO.set("interesdate", (Object)interestDate);
            interestEntryDO.set("interestcalamount", (Object)interestAmount);
            interestEntryDO.set("intway", (Object)intWay);
            interestEntryDO.set("intstartdate", (Object)beginDate);
            interestEntryDO.set("intenddate", (Object)intBill.getEndDate());
            interestEntryDO.set("intstate", (Object)0);
            DynamicObject intAccount = exsitEntry != null ? (exsitEntry.getDynamicObject("intaccount") != null ? exsitEntry.getDynamicObject("intaccount") : accountBank) : accountBank;
            interestEntryDO.set("intaccount", (Object)intAccount);
            DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("interest_subentry");
            interestSubEntryDC.clear();
            for (IntBillDetailExtInfo detail : details) {
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("intereststartdate", (Object)detail.getBeginDate());
                interestSubEntryDO.set("interestenddate", (Object)detail.getEndDate());
                interestSubEntryDO.set("interestdate", (Object)detail.getDays());
                interestSubEntryDO.set("interestbalance", (Object)detail.getPrinciple());
                interestSubEntryDO.set("interestrate", (Object)detail.getRate());
                interestSubEntryDO.set("interestdays", (Object)detail.getBasisDay());
                interestSubEntryDO.set("interestamount", (Object)detail.getAmount());
                interestSubEntryDO.set("interestway", (Object)detail.getIntType().getValue());
                interestSubEntryDO.set("floatrate", (Object)detail.getFloatRate());
                interestSubEntryDO.set("benchmarkrate", (Object)detail.getRate().subtract(detail.getFloatRate()));
                interestSubEntryDO.set("floatint", (Object)detail.getFloatInt());
                interestSubEntryDO.set("benchmarkint", (Object)detail.getBenchmarkInt());
                interestSubEntryDO.set("lasttotalint", (Object)detail.getLastTotalInt());
                interestSubEntryDO.set("curtotalint", (Object)detail.getCurTotalInt());
                interestSubEntryDO.set("confirmratedate", (Object)detail.getBeginConfirmDate());
                interestSubEntryDO.set("lookdays", (Object)detail.getConfirmDays());
            }
        }
    }

    private String getIntWay(DynamicObject loanBill) {
        return this.isHkfx(loanBill) ? InterestbillctgEnum.PAYPRINANDINTE.getValue() : InterestbillctgEnum.PAYINTERST.getValue();
    }

    private boolean isHkfx(DynamicObject loanBill) {
        String repayWay = loanBill.getString("repaymentway");
        return RepaymentWayEnum.isHbfx((String)repayWay);
    }

    private void updateIntPlanByHand(DynamicObject loanBill, List<DynamicObject> interestBills) {
        DynamicObjectCollection intPlans = loanBill.getDynamicObjectCollection("interest_entry");
        TreeMap<Date, List<DynamicObject>> interestBillMap = new TreeMap<Date, List<DynamicObject>>(interestBills.stream().collect(Collectors.groupingBy(p -> p.getDate("bizdate"))));
        for (int i = intPlans.size() - 1; i >= 0; --i) {
            DynamicObject intPlan = (DynamicObject)intPlans.get(i);
            if (!"1".equals(intPlan.getString("intstate"))) continue;
            intPlans.remove(i);
        }
        for (DynamicObject interestBill : interestBills) {
            this.addLoanBillIntPlanByPayedInt(loanBill, intPlans, interestBill, 0);
        }
        Date maxPayedIntDate = interestBillMap.isEmpty() ? null : interestBillMap.lastKey();
        for (int i = intPlans.size() - 1; i >= 0; --i) {
            boolean isAfter;
            DynamicObject intPlan = (DynamicObject)intPlans.get(i);
            Date interesDate = intPlan.getDate("interesdate");
            int intState = intPlan.getInt("intstate");
            boolean isPayed = interestBillMap.containsKey(interesDate);
            if (intState == 1 && !isPayed) {
                intPlan.set("intstate", (Object)0);
            }
            boolean bl = isAfter = maxPayedIntDate != null && maxPayedIntDate.compareTo(interesDate) >= 0;
            if (intState != 0 || !isPayed && !isAfter) continue;
            intPlans.remove(i);
        }
        this.updateIntPlansReq(intPlans);
    }

    private DynamicObject addLoanBillIntPlanByPayedInt(DynamicObject loanBill, DynamicObjectCollection interestEntryDC, DynamicObject payedIntBill, int entryReq) {
        DynamicObject intEntry = interestEntryDC.addNew();
        DynamicObjectCollection entrys = payedIntBill.getDynamicObjectCollection("entrys");
        intEntry.set("seq", (Object)entryReq);
        intEntry.set("interestseq", (Object)entryReq);
        intEntry.set("interesdate", (Object)payedIntBill.getDate("bizdate"));
        intEntry.set("interestcalamount", (Object)payedIntBill.getBigDecimal("convertintamt"));
        DynamicObject intAccount = payedIntBill.getDynamicObject("instbankacct");
        intAccount = intAccount == null ? loanBill.getDynamicObject("accountbank") : intAccount;
        intEntry.set("intaccount", (Object)intAccount);
        intEntry.set("intstartdate", (Object)payedIntBill.getDate("startinstdate"));
        intEntry.set("intenddate", (Object)payedIntBill.getDate("endinstdate"));
        intEntry.set("intway", (Object)payedIntBill.getString("instbillctg"));
        intEntry.set("intstate", (Object)1);
        DynamicObjectCollection interestSubEntryDC = intEntry.getDynamicObjectCollection("interest_subentry");
        interestSubEntryDC.clear();
        int req = 0;
        for (DynamicObject entry : entrys) {
            DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
            interestSubEntryDO.set("seq", (Object)(++req));
            interestSubEntryDO.set("intereststartdate", (Object)entry.getDate("inststartdate"));
            interestSubEntryDO.set("interestenddate", (Object)entry.getDate("instenddate"));
            interestSubEntryDO.set("interestdate", (Object)entry.getInt("instdays"));
            interestSubEntryDO.set("interestbalance", (Object)entry.getBigDecimal("instprincipalamt"));
            interestSubEntryDO.set("interestrate", (Object)entry.getBigDecimal("rate"));
            interestSubEntryDO.set("interestdays", (Object)entry.getInt("ratetrandays"));
            interestSubEntryDO.set("interestamount", (Object)entry.getBigDecimal("instamt"));
            interestSubEntryDO.set("interestway", (Object)entry.getString("instctg"));
            interestSubEntryDO.set("floatint", (Object)entry.getBigDecimal("floatint"));
            interestSubEntryDO.set("floatrate", (Object)entry.getBigDecimal("floatrate"));
            interestSubEntryDO.set("lasttotalint", (Object)entry.getBigDecimal("lasttotalint"));
            interestSubEntryDO.set("curtotalint", (Object)entry.getBigDecimal("curtotalint"));
            interestSubEntryDO.set("confirmratedate", (Object)entry.getDate("confirmratedate"));
            interestSubEntryDO.set("lookdays", (Object)entry.getInt("lookdays"));
        }
        return intEntry;
    }

    private void updateIntPlansReq(DynamicObjectCollection intPlans) {
        intPlans.sort((i1, i2) -> {
            int compare = i1.getDate("interesdate").compareTo(i2.getDate("interesdate"));
            if (compare == 0) {
                compare = i2.getString("intstate").compareTo(i1.getString("intstate"));
            }
            return compare;
        });
        int size = intPlans.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject intPlan = (DynamicObject)intPlans.get(i);
            intPlan.set("seq", (Object)(i + 1));
            intPlan.set("interestseq", (Object)(i + 1));
        }
    }

    private boolean isIntPlanEmpty(DynamicObject loanBill) {
        boolean isBond = LoanTypeEnum.isBond(loanBill.getString("loantype"));
        boolean isSave = BillStatusEnum.isSave((String)loanBill.getString("billstatus"));
        boolean isGdpljx = SettleIntModeEnum.isGdpljx((String)loanBill.getString("settleintmode"));
        boolean isEmpty = EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject("interestsettledplan"));
        return isBond && isSave && isGdpljx && isEmpty;
    }
}

