/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillRateAdjustWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        this.logger.info("\u66f4\u65b0\u6c47\u7387\u91cd\u7f6e\u5217\u8868, param: {}", (Object)param);
        CfmRateAdjustHelper.updateRateAdjustList(loanBills, param.getLoanWBType(), param.isFromSch());
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        boolean isCallInt;
        if (param.isReSaveLoan()) {
            return true;
        }
        LoanWBTypeEnum loanWbType = param.getLoanWBType();
        if (!LoanWBTypeEnum.isNotPreInterest(loanWbType)) {
            return false;
        }
        if (this.isFreeRate(loanBill)) {
            return false;
        }
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        boolean bl = isCallInt = EmptyUtil.isEmpty((DynamicObject)productFactory) || productFactory.getBoolean("iscallint");
        if (!isCallInt) {
            return false;
        }
        boolean isAfterIntAudit = LoanWBTypeEnum.INTEREST == loanWbType && RateAdjustStyleEnum.isAfterint(loanBill.getString("rateadjuststyle"));
        boolean isNoFixedTerm = loanBill.getBoolean("isnofixedterm") && (LoanWBTypeEnum.REPAYMENT == loanWbType || LoanWBTypeEnum.INTEREST == loanWbType);
        return LoanWBTypeEnum.isWriteRepayPlan(loanWbType) || LoanWBTypeEnum.EXTEND == loanWbType || isAfterIntAudit || isNoFixedTerm;
    }
}

