/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillRepayBillWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        Map<Long, List<DynamicObject>> contractMap = loanBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        Map<Long, List<DynamicObject>> contractRepayBillMap = RepaymentBillRepository.getRepaymentByContractBillIds(contractMap.keySet());
        Map<Long, BigDecimal> drawAmountMap = LoanBillRepository.queryDrawAmountByContractIds(contractMap.keySet());
        for (Map.Entry<Long, List<DynamicObject>> entry : contractMap.entrySet()) {
            Long contractId = entry.getKey();
            List<DynamicObject> contractRepayBills = contractRepayBillMap.get(contractId);
            List<DynamicObject> loanBillList = contractMap.get(contractId);
            DynamicObject contractBill = this.getContractBill(loanBillList.get(0));
            Map<Long, List<DynamicObject>> loanBillRepaymentMap = contractRepayBills.stream().collect(Collectors.groupingBy(d -> d.getLong("loans.e_loanbill")));
            for (DynamicObject loanBill : loanBillList) {
                long loanBillId = loanBill.getLong("id");
                List<DynamicObject> repayBills = loanBillRepaymentMap.get(loanBillId);
                this.updateLoanBillInfo(loanBill, repayBills);
                LoanBillRepayPlanHelper.updateLoanBillRepayPlanList(loanBill, repayBills);
            }
            BigDecimal yetLoanAmt = drawAmountMap.get(contractId);
            BigDecimal yetRepayAmt = contractRepayBills.stream().map(o -> o.getBigDecimal("loans.e_convertrepayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.updateContractBillAmount(contractBill, yetLoanAmt, yetRepayAmt);
        }
    }

    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.logger.info("\u8fd8\u6b3e\u5355\u786e\u8ba4\u3001\u53d6\u6d88\u786e\u8ba4, param:{} ", (Object)param);
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        return param.isReSaveLoan() || LoanWBTypeEnum.isWriteRepayAmt(param.getLoanWBType());
    }

    private void updateLoanBillInfo(DynamicObject loanBill, List<DynamicObject> repayBillList) {
        BigDecimal repayAmount = BigDecimal.ZERO;
        Date lastRepayDate = null;
        BigDecimal lastPayIntAmt = BigDecimal.ZERO;
        boolean lastIsPayInst = false;
        if (EmptyUtil.isNoEmpty(repayBillList)) {
            repayBillList.sort(Comparator.comparing(b -> ((DynamicObject)b).getDate("bizdate")).thenComparing(c -> ((DynamicObject)c).getDate("modifytime")));
            DynamicObject lastRepayBill = repayBillList.get(repayBillList.size() - 1);
            lastPayIntAmt = lastRepayBill.getBigDecimal("loans.e_actintamt");
            lastIsPayInst = lastRepayBill.getBoolean("loans.e_ispayinst");
            lastRepayDate = lastRepayBill.getDate("bizdate");
            repayAmount = repayBillList.stream().map(o -> o.getBigDecimal("loans.e_repayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal notRepayAmount = loanBill.getBigDecimal("drawamount").subtract(repayAmount);
        loanBill.set("repayamount", (Object)repayAmount);
        loanBill.set("notrepayamount", (Object)notRepayAmount);
        loanBill.set("lastrepaydate", lastRepayDate);
        if (notRepayAmount.compareTo(BigDecimal.ZERO) == 0) {
            loanBill.set("cleardate", (Object)lastRepayDate);
            if (lastIsPayInst && EmptyUtil.isNoEmpty((BigDecimal)lastPayIntAmt)) {
                loanBill.set("endinstdate", (Object)DateUtils.getLastDay((Date)lastRepayDate, (int)1));
            }
        } else {
            loanBill.set("cleardate", null);
        }
        this.logger.info("loanBillId:{},notRepayAmount:{}", loanBill.getPkValue(), (Object)notRepayAmount);
    }

    private void updateContractBillAmount(DynamicObject contractBill, BigDecimal yetLoanAmt, BigDecimal yetRepayAmt) {
        contractBill.set("repayamount", (Object)yetRepayAmt);
        contractBill.set("notrepayamount", (Object)yetLoanAmt.subtract(yetRepayAmt));
        if (contractBill.getBoolean("iscycleloan")) {
            BigDecimal amount = contractBill.getBigDecimal("amount");
            BigDecimal drawAmount = contractBill.getBigDecimal("drawamount");
            contractBill.set("notdrawamount", (Object)amount.subtract(drawAmount).add(yetRepayAmt));
        }
    }
}

