/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.cfm.extpoint.preinst.IPreIntBillBatchSecondDevFields;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BatchIntBillBotpHelper {
    public static void doPush(String appId, DynamicObject batchPreIntBill) {
        DynamicObjectCollection batchPreIntEntrys = batchPreIntBill.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>(batchPreIntEntrys.size());
        entryList.addAll((Collection<DynamicObject>)batchPreIntEntrys);
        BatchIntBillBotpHelper.doPushByPreIntEntry(appId, batchPreIntBill, entryList, "submit");
    }

    public static void doAudit(DynamicObject batchPreIntBill) {
        DynamicObjectCollection batchPreIntEntrys = batchPreIntBill.getDynamicObjectCollection("entry");
        if (CollectionUtils.isEmpty((Collection)batchPreIntEntrys)) {
            return;
        }
        String loanType = batchPreIntBill.getString("loantype");
        String datasource = batchPreIntBill.getString("datasource");
        Date businessDate = batchPreIntBill.getDate("businessdate");
        Pair botpPairObj = BatchIntBillHelper.getPreIntBotpPair((String)loanType, (String)datasource);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (DynamicObject batchPreIntEntry : batchPreIntEntrys) {
            DynamicObject preInterestBill = TmcDataServiceHelper.loadSingle((Object)batchPreIntEntry.getLong("intbillid"), (String)((String)botpPairObj.getRight()));
            preInterestBill.set("businessdate", (Object)businessDate);
            preInterestBill.set("actpreinstamt", (Object)batchPreIntEntry.getBigDecimal("actualinstamt"));
            preInterestBill.set("nowriteoffamt", (Object)batchPreIntEntry.getBigDecimal("actualinstamt"));
            TmcOperateServiceHelper.execOperate((String)"audit", (String)((String)botpPairObj.getRight()), (DynamicObject[])new DynamicObject[]{preInterestBill}, (OperateOption)operateOption, (boolean)true);
        }
    }

    public static void doPushByPreIntEntry(String appId, DynamicObject batchPreIntBill, List<DynamicObject> batchPreIntEntrys) {
        BatchIntBillBotpHelper.doPushByPreIntEntry(appId, batchPreIntBill, batchPreIntEntrys, "push");
    }

    public static void doPushByPreIntEntry(String appId, DynamicObject batchPreIntBill, List<DynamicObject> batchPreIntEntrys, String opType) {
        if (CollectionUtils.isEmpty(batchPreIntEntrys)) {
            return;
        }
        String loanType = batchPreIntBill.getString("loantype");
        String datasource = batchPreIntBill.getString("datasource");
        Pair botpPairObj = BatchIntBillHelper.getPreIntBotpPair((String)loanType, (String)datasource);
        String entityName = (String)botpPairObj.getLeft();
        ArrayList loanBills = new ArrayList();
        boolean isDeposit = StringUtils.equals((CharSequence)"cim_deposit", (CharSequence)entityName);
        batchPreIntEntrys.stream().forEach(v -> {
            DynamicObject loan = TmcDataServiceHelper.newDynamicObject((String)entityName);
            loan.set("id", (Object)v.getLong("loanbillid"));
            loanBills.add(loan);
        });
        ArrayList intBillIds = new ArrayList(batchPreIntEntrys.size());
        Map<Object, DynamicObject> loanBillsMap = loanBills.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        List ids = loanBills.stream().map(Dyn -> Dyn.getPkValue().toString()).collect(Collectors.toList());
        Map LimitMap = MutexServiceHelper.batchRequest(ids, (String)entityName, (String)"submit");
        List lockIds = LimitMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        try {
            String lockErrorBillNos = batchPreIntEntrys.stream().filter(b -> Boolean.FALSE.equals(LimitMap.get(b.getString("loanbillid")))).map(b -> b.getString("loannum")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u9884\u63d0\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BatchIntBillBotpHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]), lockErrorBillNos));
            }
            for (DynamicObject batchPreIntEntry : batchPreIntEntrys) {
                BatchIntBillBotpHelper.pushEntryLoanBill(appId, batchPreIntBill, (Pair<String, String>)botpPairObj, isDeposit, loanBillsMap, batchPreIntEntry, opType, intBillIds);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9884\u63d0\u5355\u5931\u8d25:%s\u3002", (String)"BatchIntBillBotpHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (!lockIds.isEmpty()) {
                MutexServiceHelper.batchRelease(lockIds, (String)entityName, (String)"submit");
            }
        }
        BatchIntBillBotpHelper.checkFail(intBillIds, batchPreIntBill, batchPreIntEntrys);
    }

    private static void pushEntryLoanBill(String appId, DynamicObject batchPreIntBill, Pair<String, String> botpPairObj, boolean isDeposit, Map<Object, DynamicObject> loanBillsMap, DynamicObject batchPreIntEntry, String opType, List intBillIds) {
        DynamicObject loanBill = loanBillsMap.get(batchPreIntEntry.get("loanbillid"));
        String loanType = batchPreIntBill.getString("loantype");
        String datasource = batchPreIntBill.getString("datasource");
        String billno = batchPreIntBill.getString("billno");
        Date preintDate = batchPreIntBill.getDate("preintdate");
        Date businessDate = batchPreIntBill.getDate("businessdate");
        DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)loanBill, (String)((String)botpPairObj.getRight()));
        DynamicObject targetBill = targetBills[0];
        BatchIntBillBotpHelper.dealPreIntBillBatchAuditSecondDev(batchPreIntBill, batchPreIntEntry, targetBill);
        targetBill.getDynamicObjectCollection("entrys").clear();
        targetBill.set("businessdate", (Object)businessDate);
        targetBill.set("operatetype", (Object)batchPreIntBill.getString("operateType"));
        targetBill.set("prestartdate", (Object)batchPreIntEntry.getDate("startdate"));
        targetBill.set("prestenddate", (Object)preintDate);
        targetBill.set("bizdate", (Object)batchPreIntEntry.getDate("enddate"));
        targetBill.set("predictpreinstamt", (Object)batchPreIntEntry.getBigDecimal("interestamt"));
        targetBill.set("actpreinstamt", (Object)batchPreIntEntry.getBigDecimal("actualinstamt"));
        targetBill.set("creator", batchPreIntBill.get("creator"));
        targetBill.set("confirmstatus", (Object)ConfirmStatusEnum.REGISTRYING.getValue());
        targetBill.set("auto", (Object)batchPreIntBill.getBoolean("isauto"));
        if (!isDeposit && DataSourceEnum.isIfm((String)datasource)) {
            targetBill.set("batchno", (Object)billno);
            targetBill.set("settlecenter", (Object)batchPreIntBill.getDynamicObject("settlecenter"));
        }
        if (LoanTypeEnum.isDeposit((String)loanType)) {
            targetBill.set("datasource", (Object)DataSourceEnum.CIM.getValue());
            BatchIntBillBotpHelper.setTargetBillEntry(targetBill, batchPreIntEntry.getString("intdetail_tag"));
        }
        if (targetBill.containsProperty("calcoverint") && batchPreIntEntry.containsProperty("calcoverint")) {
            targetBill.set("calcoverint", (Object)batchPreIntEntry.getString("calcoverint"));
        }
        BatchIntBillBotpHelper.doSubmitPreIntBill(appId, batchPreIntEntry, targetBills, opType, intBillIds);
    }

    private static void dealPreIntBillBatchAuditSecondDev(DynamicObject batchIntBill, DynamicObject loanBillEntry, DynamicObject targetIntBill) {
        PluginProxy pluginProxy = PluginProxy.create(IPreIntBillBatchSecondDevFields.class, (String)"kd.sdk.tmc.cfm.extpoint.preinst.IPreIntBillBatchSecondDevFields");
        pluginProxy.callReplace(proxy -> {
            proxy.preIntBillBatchSecondDevFields(batchIntBill, loanBillEntry, targetIntBill);
            return new Object();
        });
    }

    private static void doSubmitPreIntBill(String appId, DynamicObject batchPreIntEntry, DynamicObject[] targetBills, String opType, List<Object> intBillIds) {
        if (EmptyUtil.isEmpty((Object[])targetBills)) {
            return;
        }
        String entityName = targetBills[0].getDataEntityType().getName();
        OperationResult result = null;
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        operateOption.setVariableValue("appid", appId);
        try {
            String intDetailNum = batchPreIntEntry.getString("intdetailnum");
            if (EmptyUtil.isNoEmpty((String)intDetailNum) && BatchIntBillHelper.isDepostPreInt((String)entityName)) {
                result = BatchIntBillBotpHelper.getSubmitResult(intDetailNum, entityName);
            }
            if (result == null) {
                result = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (DynamicObject[])targetBills, (OperateOption)operateOption);
            }
        }
        catch (Exception e) {
            batchPreIntEntry.set("status", (Object)"fail");
            batchPreIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u9884\u63d0\u5229\u606f\u5355\u751f\u6210\u5931\u8d25\uff1a%s", (String)"BatchIntBillBotpHelper_0", (String)"tmc-cfm-common", (Object[])new Object[0]), e.getMessage().length() > 60 ? e.getMessage().substring(0, 60) : e.getMessage()));
        }
        try {
            if (result == null) {
                return;
            }
            Object intBillId = result.getSuccessPkIds().toArray()[0];
            if (EmptyUtil.isNoEmpty((Object)result.getBillNos())) {
                batchPreIntEntry.set("intdetailnum", result.getBillNos().values().toArray()[0]);
                batchPreIntEntry.set("intbillid", intBillId);
                intBillIds.add(intBillId);
            }
            if (!"submit".equals(opType)) {
                TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (Object[])new Object[]{intBillId}, (OperateOption)operateOption);
            }
            batchPreIntEntry.set("intcomment", (Object)"");
            batchPreIntEntry.set("status", (Object)"success");
        }
        catch (Exception e) {
            batchPreIntEntry.set("status", (Object)"fail");
            batchPreIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u9884\u63d0\u5229\u606f\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"BatchIntBillBotpHelper_1", (String)"tmc-cfm-common", (Object[])new Object[0]), e.getMessage().length() > 60 ? e.getMessage().substring(0, 60) : e.getMessage()));
        }
    }

    private static OperationResult getSubmitResult(String intDetailNum, String entityName) {
        QFilter qFilter = new QFilter("billno", "=", (Object)intDetailNum);
        DynamicObjectCollection preIntDepoitBills = QueryServiceHelper.query((String)entityName, (String)"id,billno,billstatus", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)preIntDepoitBills)) {
            return null;
        }
        DynamicObject preIntDepoitBill = (DynamicObject)preIntDepoitBills.get(0);
        String billstatus = preIntDepoitBill.getString("billstatus");
        String billNo = preIntDepoitBill.getString("billno");
        if (BillStatus.B.name().equals(billstatus)) {
            OperationResult result = new OperationResult();
            result.setSuccess(true);
            HashMap<Object, String> billNos = new HashMap<Object, String>(1);
            Object pkValue = preIntDepoitBill.get("id");
            billNos.put(pkValue, billNo);
            result.setBillNos(billNos);
            ArrayList<Object> pkIds = new ArrayList<Object>(1);
            pkIds.add(pkValue);
            result.setSuccessPkIds(pkIds);
            return result;
        }
        return null;
    }

    private static void checkFail(List intBillIds, DynamicObject batchIntBill, List<DynamicObject> batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intcomment", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)batchIntBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{batchIntBill}, (OperateOption)OperateOption.create(), (boolean)true);
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"BatchIntBillBotpHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
    }

    private static void setTargetBillEntry(DynamicObject targetBill, String detailTagInfo) {
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)detailTagInfo, IntBillInfo.class);
        DynamicObjectCollection entryCol = targetBill.getDynamicObjectCollection("entrys");
        entryCol.clear();
        List details = intBillInfo.getDetails();
        for (IntBillDetailInfo detailInfo : details) {
            DynamicObject newEntry = entryCol.addNew();
            newEntry.set("inststartdate", (Object)detailInfo.getBeginDate());
            newEntry.set("instenddate", (Object)detailInfo.getEndDate());
            newEntry.set("instdays", (Object)detailInfo.getDays());
            newEntry.set("instprincipalamt", (Object)detailInfo.getPrinciple());
            newEntry.set("rate", (Object)detailInfo.getRate());
            newEntry.set("ratetrandays", (Object)detailInfo.getBasisDay());
            newEntry.set("instamt", (Object)detailInfo.getAmount());
        }
    }

    private static List<DynamicObject> getDepositBill(String entityName, List<Long> loanBillIds) {
        List noticeBillIds;
        ArrayList<DynamicObject> allDepositBill = new ArrayList<DynamicObject>();
        DynamicObjectCollection depositCols = QueryServiceHelper.query((String)entityName, (String)"id,investvarieties.investtype investtype", (QFilter[])new QFilter[]{new QFilter("id", "in", loanBillIds)});
        List fixedBillIds = depositCols.stream().filter(r -> InvestTypeEnum.isFixed((String)r.getString("investtype"))).map(r -> r.getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(fixedBillIds)) {
            DynamicObject[] fixedDeposit = TmcDataServiceHelper.load((Object[])fixedBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            allDepositBill.addAll(Arrays.asList(fixedDeposit));
        }
        if (EmptyUtil.isNoEmpty(noticeBillIds = depositCols.stream().filter(r -> InvestTypeEnum.isNotice((String)r.getString("investtype"))).map(r -> r.getLong("id")).collect(Collectors.toList()))) {
            DynamicObject[] noticeDeposit = TmcDataServiceHelper.load((Object[])noticeBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_noticedeposit"));
            allDepositBill.addAll(Arrays.asList(noticeDeposit));
        }
        return allDepositBill;
    }
}

