/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.BillTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillApplyHelper {
    public static final List<String> MODIFIABLE_HEAD_PROPS = new ArrayList<String>(8);

    public static void updateLoanBill(DynamicObject[] dataEntities, boolean isConfirm) {
        ArrayList<DynamicObject> loanBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject applyBill : dataEntities) {
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(applyBill.getString("creditortype")) && !isConfirm) {
                applyBill.set("bizstatus", (Object)ApplyBusinessStatusEnum.HANDING.getValue());
                applyBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
                applyBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
                continue;
            }
            String entityName = "cfm_loanbill";
            if ("cim_apply_loanbill".equals(applyBill.getDataEntityType().getName())) {
                entityName = "cim_invest_loanbill";
            }
            DynamicObject loanBill = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "=", applyBill.get("loanbillno"))});
            LoanBillApplyHelper.saveHistory(loanBill, applyBill);
            for (String prop : MODIFIABLE_HEAD_PROPS) {
                loanBill.set(prop, applyBill.get(prop));
            }
            LoanBillApplyHelper.updateRepayPlan(loanBill, applyBill);
            LoanBillApplyHelper.updateInterestPlan(loanBill, applyBill);
            applyBill.set("bizstatus", (Object)ApplyBusinessStatusEnum.HANDED.getValue());
            applyBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
            applyBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            loanBillList.add(loanBill);
            LoanBillApplyHelper.addAttachment(applyBill);
        }
        SaveServiceHelper.save((DynamicObject[])loanBillList.toArray(new DynamicObject[0]));
    }

    private static void addAttachment(DynamicObject changeBill) {
        long loanBillId = changeBill.getLong("loanbill.id");
        String changeEntity = changeBill.getDynamicObjectType().getName();
        String loanEntity = "cim_apply_loanbill".equals(changeEntity) ? "cim_invest_loanbill" : "cfm_loanbill";
        TmcAttachmentHelper.setAttachments((DynamicObject)changeBill, (String)loanEntity, (Long)loanBillId, (String)"attachmentpanel", (String)"attachmentpanel");
        String oppositeEntity = TmcAttachmentHelper.getOppositeEntity((DynamicObject)changeBill, (String)changeBill.getDynamicObjectType().getName());
        if (EmptyUtil.isNoEmpty((String)oppositeEntity) && !oppositeEntity.equals(loanEntity)) {
            TmcAttachmentHelper.setAttachments((DynamicObject)changeBill, (String)oppositeEntity, (Long)loanBillId, (String)"attachmentpanel", (String)"attachmentpanel");
        }
    }

    public static void loanWriteBack(DynamicObject[] dataEntities, boolean isConfirm) {
        for (DynamicObject applyBill : dataEntities) {
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(applyBill.getString("creditortype")) && !isConfirm) continue;
            DynamicObject loanBill = BusinessDataServiceHelper.loadSingle((String)"cfm_loanbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", applyBill.get("loanbillno"))});
            Long loanBillId = loanBill.getLong("id");
            LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.build((long)loanBillId, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN).setReSaveLoan(false).setFromIsc(false).setFromSch(false), (DynamicObject)loanBill);
        }
    }

    public static void saveHistory(DynamicObject loanBill, DynamicObject applyBill) {
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)applyBill.getPkValue()), (String)applyBill.getDataEntityType().getName(), (String)applyBill.getString("billno"), (String)"", (String)loanBill.getString("billno"), (DynamicObject)loanBill);
    }

    public static void writeBackLoanBill(DynamicObject[] dataEntities, boolean isConfirm) {
        ArrayList<DynamicObject> loanBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject applyBill : dataEntities) {
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(applyBill.getString("creditortype")) && !isConfirm) {
                applyBill.set("bizstatus", (Object)ApplyBusinessStatusEnum.HANDING.getValue());
                applyBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
                continue;
            }
            DynamicObject loanBillF7 = applyBill.getDynamicObject("loanbill");
            String changeEntity = applyBill.getDynamicObjectType().getName();
            String entityName = "cfm_loanbill";
            if ("cim_apply_loanbill".equals(applyBill.getDataEntityType().getName())) {
                entityName = "cim_invest_loanbill";
            }
            DynamicObject historyBill = BillChangeHistoryHelper.genDelChangeHistory((Long)loanBillF7.getLong("id"), (String)entityName);
            String loanEntity = "cim_apply_loanbill".equals(changeEntity) ? "cim_invest_loanbill" : "cfm_loanbill";
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillF7.getLong("id"), (String)loanEntity);
            LoanBillApplyHelper.revertLastVersion(historyBill, loanBill);
            applyBill.set("bizstatus", (Object)ApplyBusinessStatusEnum.APPLY.getValue());
            loanBillList.add(loanBill);
            LoanBillApplyHelper.deleteAttachment(changeEntity, applyBill, loanEntity, loanBill);
        }
        SaveServiceHelper.save((DynamicObject[])loanBillList.toArray(new DynamicObject[0]));
    }

    private static void revertLastVersion(DynamicObject historyBill, DynamicObject loanBill) {
        for (String prop : MODIFIABLE_HEAD_PROPS) {
            loanBill.set(prop, historyBill.get(prop));
        }
        LoanBillApplyHelper.updateRepayPlan(loanBill, historyBill);
        LoanBillApplyHelper.updateInterestPlan(loanBill, historyBill);
    }

    private static void updateRepayPlan(DynamicObject loanBill, DynamicObject historyBill) {
        DynamicObjectCollection repayEntry_loan = loanBill.getDynamicObjectCollection("repayplan_entry");
        repayEntry_loan.clear();
        DynamicObjectCollection repayEntry_apply = historyBill.getDynamicObjectCollection("repayplan_entry");
        int index = 0;
        for (DynamicObject repayEntry : repayEntry_apply) {
            DynamicObject newRepayPlan = repayEntry_loan.addNew();
            newRepayPlan.set("seq", (Object)index++);
            newRepayPlan.set("exrepaymentdate", repayEntry.get("exrepaymentdate"));
            newRepayPlan.set("exdrawamount", repayEntry.get("exdrawamount"));
            newRepayPlan.set("erepayamount", repayEntry.get("erepayamount"));
            newRepayPlan.set("enotrepayamount", repayEntry.get("enotrepayamount"));
            newRepayPlan.set("repaystate", repayEntry.get("repaystate"));
            newRepayPlan.set("repaymentdesc", repayEntry.get("repaymentdesc"));
            newRepayPlan.set("repayaccount", repayEntry.get("repayaccount"));
            newRepayPlan.set("repaymentmodifier", repayEntry.get("repaymentmodifier"));
            newRepayPlan.set("repaymentmodifytime", repayEntry.get("repaymentmodifytime"));
        }
    }

    private static void updateInterestPlan(DynamicObject loanBill, DynamicObject historyBill) {
        DynamicObjectCollection interestEntry_loan = loanBill.getDynamicObjectCollection("interest_entry");
        interestEntry_loan.clear();
        DynamicObjectCollection interestEntry_apply = historyBill.getDynamicObjectCollection("interest_entry");
        int index = 0;
        for (DynamicObject interestEntry : interestEntry_apply) {
            DynamicObject newInterestPlan = interestEntry_loan.addNew();
            newInterestPlan.set("seq", (Object)index++);
            newInterestPlan.set("intway", interestEntry.get("intway"));
            newInterestPlan.set("interestseq", interestEntry.get("interestseq"));
            newInterestPlan.set("intstartdate", interestEntry.get("intstartdate"));
            newInterestPlan.set("intenddate", interestEntry.get("intenddate"));
            newInterestPlan.set("interesdate", interestEntry.get("interesdate"));
            newInterestPlan.set("interestcalamount", interestEntry.get("interestcalamount"));
            newInterestPlan.set("intstate", interestEntry.get("intstate"));
            newInterestPlan.set("instdescription", interestEntry.get("instdescription"));
            newInterestPlan.set("intaccount", interestEntry.get("intaccount"));
        }
    }

    private static void deleteAttachment(String changeEntity, DynamicObject applyBill, String loanEntity, DynamicObject loanBill) {
        TmcAttachmentHelper.deleteAttachment((String)changeEntity, (Object)applyBill.getPkValue(), (String)loanEntity, (Object)loanBill.getPkValue());
        if (CreditorTypeEnum.isInnerUnit((String)applyBill.getString("creditortype"))) {
            String oppositeEntity = "cim_invest_loanbill".equals(loanEntity) ? "cfm_loanbill" : "cim_invest_loanbill";
            TmcAttachmentHelper.deleteAttachment((String)changeEntity, (Object)applyBill.getPkValue(), (String)oppositeEntity, (Object)loanBill.getPkValue());
        }
    }

    public static DynamicObject queryApplyLoanBill(Long loanBillId) {
        return QueryServiceHelper.queryOne((String)"cfm_apply_loanbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbill", "=", (Object)loanBillId)});
    }

    public static DynamicObject queryOnWayApplyById(Long loanBillId, Long applyBillId) {
        DynamicObject onWayApply = QueryServiceHelper.queryOne((String)"cfm_apply_loanbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbill", "=", (Object)loanBillId).and(new QFilter("bizstatus", "!=", (Object)ApplyBusinessStatusEnum.HANDED.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()))).and("id", "!=", (Object)applyBillId)});
        return onWayApply;
    }

    public static DynamicObject queryOnWayApply(Long loanBillId) {
        DynamicObject onWayApply = QueryServiceHelper.queryOne((String)"cfm_apply_loanbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbill", "=", (Object)loanBillId).and(new QFilter("bizstatus", "!=", (Object)ApplyBusinessStatusEnum.HANDED.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())))});
        return onWayApply;
    }

    public static DynamicObjectCollection queryOnWayApply(Set<String> loanBillNo) {
        DynamicObjectCollection onWayApplys = QueryServiceHelper.query((String)"cfm_apply_loanbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbillno", "in", loanBillNo).and(new QFilter("bizstatus", "!=", (Object)ApplyBusinessStatusEnum.HANDED.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())))});
        return onWayApplys;
    }

    public static DynamicObjectCollection queryOnWayApplyByIds(Collection<Long> loanBillIds) {
        DynamicObjectCollection onWayApplys = QueryServiceHelper.query((String)"cfm_apply_loanbill", (String)"id, billno, loanbill", (QFilter[])new QFilter[]{new QFilter("loanbill", "in", loanBillIds).and(new QFilter("bizstatus", "!=", (Object)ApplyBusinessStatusEnum.HANDED.getValue()).or(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())))});
        return onWayApplys;
    }

    public static DynamicObject queryOnWayPayIntBatch(Long loanBillId) {
        DynamicObject onWayPayIntBatch = QueryServiceHelper.queryOne((String)"cfm_intbill_batch_loan", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.loanbillid", "=", (Object)loanBillId).and("biztype", "=", (Object)BillTypeEnum.LOAN.getValue()).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())});
        return onWayPayIntBatch;
    }

    public static DynamicObject queryOnWayPayInt(Long loanBillId) {
        DynamicObject onWayPayInt = QueryServiceHelper.queryOne((String)"cfm_interestbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanBillId).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())))});
        return onWayPayInt;
    }

    public static DynamicObject queryOnWayPreIntBatch(Long loanBillId) {
        DynamicObject onWayPreIntBatch = QueryServiceHelper.queryOne((String)"cfm_intbill_batch_pre", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.loanbillid", "=", (Object)loanBillId).and(new QFilter("biztype", "=", (Object)BillTypeEnum.PREINT.getValue())).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()))});
        return onWayPreIntBatch;
    }

    public static DynamicObject queryOnWayPreInt(Long loanBillId) {
        DynamicObject onWayPreInt = QueryServiceHelper.queryOne((String)"cfm_preinterestbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanBillId).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())))});
        return onWayPreInt;
    }

    public static DynamicObject queryOnWayRepay(Long loanBillId) {
        return RepaymentBillRepository.queryOnWayRepayByLoanId((Long)loanBillId);
    }

    public static DynamicObject queryOnWayAdjust(Long loanBillId) {
        DynamicObject onWayAdjust = QueryServiceHelper.queryOne((String)"cfm_rateadjustbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.ldrawbill", "=", (Object)loanBillId).and("entry.lisadjust", "=", (Object)true).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())});
        return onWayAdjust;
    }

    public static DynamicObject queryOnWayExtend(Long loanBillId) {
        DynamicObject onWayExtend = QueryServiceHelper.queryOne((String)"cfm_contractextendbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbilllist.drawbillid", "=", (Object)loanBillId).and("loanbilllist.isrenewal", "=", (Object)true).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or(new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())))});
        return onWayExtend;
    }

    public static DynamicObject queryAfterChgPayIntBatch(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPayIntBatch = QueryServiceHelper.queryOne((String)"cfm_intbill_batch_loan", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.loanbillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime).and("biztype", "=", (Object)BillTypeEnum.LOAN.getValue())});
        return afterChgPayIntBatch;
    }

    public static DynamicObject queryAfterChgPayInt(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPayInt = QueryServiceHelper.queryOne((String)"cfm_interestbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime)});
        return afterChgPayInt;
    }

    public static DynamicObject queryAfterChgPreIntBatch(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPreIntBatch = QueryServiceHelper.queryOne((String)"cfm_intbill_batch_pre", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.loanbillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime).and(new QFilter("biztype", "=", (Object)BillTypeEnum.PREINT.getValue()))});
        return afterChgPreIntBatch;
    }

    public static DynamicObject queryAfterChgPreInt(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPreInt = QueryServiceHelper.queryOne((String)"cfm_preinterestbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime)});
        return afterChgPreInt;
    }

    public static DynamicObject queryAfterChgAdjust(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgAdjust = QueryServiceHelper.queryOne((String)"cfm_rateadjustbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.ldrawbill", "=", (Object)loanBillId).and("entry.lisadjust", "=", (Object)true).and("createtime", ">=", (Object)modifyTime)});
        return afterChgAdjust;
    }

    public static DynamicObject queryAfterChgExtend(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgExtend = QueryServiceHelper.queryOne((String)"cfm_contractextendbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbilllist.drawbillid", "=", (Object)loanBillId).and("loanbilllist.isrenewal", "=", (Object)true).and("createtime", ">=", (Object)modifyTime)});
        return afterChgExtend;
    }

    static {
        MODIFIABLE_HEAD_PROPS.add("term");
        MODIFIABLE_HEAD_PROPS.add("startintdate");
        MODIFIABLE_HEAD_PROPS.add("expiredate");
        MODIFIABLE_HEAD_PROPS.add("handinstplan");
    }
}

