/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.mq;

import java.io.Serializable;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.tmc.cfm.business.mq.MQTypeEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class MQParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CFM_LOANBILL_QUEUE = "kd.tmc.cfm.loanbill";
    private static final Log logger = LogFactory.getLog(MQParam.class);
    private String type;
    private Object param;

    public String getType() {
        return this.type;
    }

    public MQParam setType(String type) {
        this.type = type;
        return this;
    }

    public Object getParam() {
        return this.param;
    }

    public MQParam setParam(Object param) {
        this.param = param;
        return this;
    }

    public static MQParam build(MQTypeEnum type, Object param) {
        return new MQParam().setType(type.getType()).setParam(param);
    }

    public boolean sendMessage() {
        return this.sendMessage(CFM_LOANBILL_QUEUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(String queue) {
        MessagePublisher pub = null;
        String message = SerializationUtils.toJsonString((Object)this);
        try {
            pub = MQFactory.get().createSimplePublisher("tmc", queue);
            pub.publishInDbTranscation(DBRouteConst.TMC.getRouteKey(), (Object)this);
            logger.info("send mq message success, queue: {}, message: {}", (Object)queue, (Object)message);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(String.format("send mq message error, queue:%s, param:%s", queue, message), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(pub);
        }
    }

    private void close(MessagePublisher pub) {
        try {
            if (pub != null) {
                pub.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

