/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.BizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplyAuditSynSchemeService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isneedscheme");
        selector.add("entrys");
        selector.add("e_scheme");
        selector.add("e_isselect");
        selector.add("e_reson");
        selector.add("finproduct");
        selector.add("loantype");
        selector.add("creditortype");
        selector.add("creditor");
        selector.add("textcreditor");
        selector.add("startdate");
        selector.add("term");
        selector.add("enddate");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("guarantee");
        selector.add("repaymentway");
        selector.add("interestsettledplan");
        selector.add("ratetype");
        selector.add("ratecyclesign");
        selector.add("ratecycle");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("currency");
        selector.add("amount");
        selector.add("floatingratio");
        selector.add("iscycleloan");
        selector.add("compcost");
        selector.add("compcostrate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList schemeIds = new ArrayList();
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            schemeIds.addAll(entrys.stream().map(v -> v.getDynamicObject("e_scheme").getPkValue()).collect(Collectors.toList()));
        }
        Object[] loanSchemes = TmcDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_financingscheme"));
        Map<Object, DynamicObject> shcemesMap = Arrays.stream(loanSchemes).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        HashMap<Object, String> selectSchemeMap = new HashMap<Object, String>(dataEntities.length);
        for (DynamicObject loanApply : dataEntities) {
            DynamicObject selectEntry;
            boolean isNeedScheme = loanApply.getBoolean("isneedscheme");
            if (!isNeedScheme || EmptyUtil.isEmpty((DynamicObject)(selectEntry = loanApply.getDynamicObjectCollection("entrys").stream().filter(v -> v.getBoolean("e_isselect")).findFirst().orElseGet(() -> null)))) continue;
            DynamicObject selectScheme = shcemesMap.get(selectEntry.getDynamicObject("e_scheme").getPkValue());
            this.syncSchemeInfo(loanApply, selectScheme);
            selectSchemeMap.put(selectScheme.getPkValue(), selectEntry.getString("e_reson"));
        }
        if (EmptyUtil.isNoEmpty((Object[])loanSchemes)) {
            this.syncSchemeStatus((DynamicObject[])loanSchemes, selectSchemeMap);
            SaveServiceHelper.save((DynamicObject[])loanSchemes);
        }
    }

    private void syncSchemeInfo(DynamicObject loanApply, DynamicObject loanScheme) {
        loanApply.set("finproduct", loanScheme.get("finproduct"));
        loanApply.set("loantype", loanScheme.get("fintype"));
        loanApply.set("creditortype", loanScheme.get("creditortype"));
        loanApply.set("creditor", loanScheme.get("creditor"));
        loanApply.set("textcreditor", loanScheme.get("textcreditor"));
        loanApply.set("startdate", loanScheme.get("startdate"));
        loanApply.set("term", loanScheme.get("term"));
        loanApply.set("enddate", loanScheme.get("enddate"));
        loanApply.set("interesttype", loanScheme.get("interesttype"));
        loanApply.set("interestrate", loanScheme.get("interestrate"));
        loanApply.set("guarantee", loanScheme.get("guaranteeway"));
        loanApply.set("repaymentway", loanScheme.get("repaymentway"));
        loanApply.set("interestsettledplan", loanScheme.get("settlescheme"));
        loanApply.set("ratetype", loanScheme.get("referrate"));
        loanApply.set("ratecyclesign", loanScheme.get("ratecyclesign"));
        loanApply.set("ratecycle", loanScheme.get("ratecycle"));
        loanApply.set("ratesign", loanScheme.get("ratesign"));
        loanApply.set("ratefloatpoint", loanScheme.get("ratefloatpoint"));
        loanApply.set("currency", loanScheme.get("currency"));
        loanApply.set("amount", loanScheme.get("amount"));
        loanApply.set("floatingratio", loanScheme.get("floatingratio"));
        loanApply.set("iscycleloan", (Object)loanScheme.getBoolean("iscycleloan"));
        loanApply.set("compcost", loanScheme.get("compcost"));
        loanApply.set("compcostrate", loanScheme.get("compcostrate"));
    }

    private void syncSchemeStatus(DynamicObject[] loanSchemes, Map<Object, String> selectSchemeMap) {
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject loanScheme : loanSchemes) {
            loanScheme.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            loanScheme.set("auditor", (Object)userId);
            if (selectSchemeMap.containsKey(loanScheme.getPkValue())) {
                loanScheme.set("opinion", (Object)selectSchemeMap.get(loanScheme.getPkValue()));
                loanScheme.set("bizstatus", (Object)BizStatusEnum.ACCEPT.getValue());
                continue;
            }
            loanScheme.set("bizstatus", (Object)BizStatusEnum.ABANDONED.getValue());
        }
    }
}

