/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplyGenerateContractService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("company");
        selector.add("creditortype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashSet<Long> cfmContractIds = new HashSet<Long>(4);
        HashSet<Long> investContractIds = new HashSet<Long>(4);
        Set orgIds = Arrays.stream(dataEntities).map(o -> o.getDynamicObject("company").getLong("id")).collect(Collectors.toSet());
        Map<String, Object> cfm009S = LoanApplyGenerateContractService.getSystemParamsByOrgIds(TmcAppEnum.CFM.getId(), new ArrayList<Long>(orgIds), "cfm009");
        this.fileterContractType(dataEntities, cfm009S, cfmContractIds, investContractIds);
        this.generateContract(cfmContractIds, "cfm_loancontractbill");
        this.generateContract(investContractIds, "cim_invest_contract");
    }

    private void generateContract(Set<Long> contractIds, String tagBillNumber) {
        Object[] contractBills;
        if (EmptyUtil.isNoEmpty(contractIds) && EmptyUtil.isNoEmpty((Object[])(contractBills = TmcBotpHelper.batchPush((Object[])contractIds.toArray(new Long[0]), (String)"cfm_loan_apply", (String)tagBillNumber)))) {
            try {
                TmcOperateServiceHelper.execOperate((String)"save", (String)"cfm_loancontractbill", (DynamicObject[])contractBills, (OperateOption)OperateOption.create(), (boolean)Boolean.TRUE);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7\u4e0b\u63a8\u5408\u540c\u5931\u8d25:%s\u3002", (String)"LoanApplyGenerateContractService_1", (String)"tmc-cfm-business", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void fileterContractType(DynamicObject[] loanApplyBills, Map<String, Object> cfm009s, Set<Long> cfmContractIds, Set<Long> investContractIds) {
        for (DynamicObject loanApplyBill : loanApplyBills) {
            String creditorType = loanApplyBill.getString("creditortype");
            Long id = loanApplyBill.getLong("id");
            Long orgId = loanApplyBill.getDynamicObject("company").getLong("id");
            String cfm009 = (String)cfm009s.get(String.valueOf(orgId));
            if (CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType) && "B".equals(cfm009)) {
                investContractIds.add(id);
                continue;
            }
            cfmContractIds.add(id);
        }
    }

    private static Map<String, Object> getSystemParamsByOrgIds(String appId, List<Long> orgIds, String key) {
        Map params = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)new AppParam(appId, "08", null, Long.valueOf(0L)), orgIds);
        HashMap<String, Object> result = new HashMap<String, Object>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            Map paramData = (Map)entry.getValue();
            Object data = paramData == null ? null : (Object)paramData.get(key);
            result.put((String)entry.getKey(), data);
        }
        return result;
    }
}

