/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.apply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.LoanApplyHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("creditor");
        lst.add("creditortype");
        lst.add("startdate");
        lst.add("ratesign");
        lst.add("ratefloatpoint");
        lst.add("interestrate");
        lst.add("floatingratio");
        lst.add("repaymentway");
        lst.add("creditlimit");
        lst.add("interestsettledplan");
        lst.add("interesttype");
        lst.add("enddate");
        lst.add("textcreditor");
        return lst;
    }

    public void process(DynamicObject[] dataEntity) throws KDException {
        List loanApplysIds = Arrays.stream(dataEntity).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] loanApplysFromDB = TmcDataServiceHelper.load((Object[])loanApplysIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loan_apply"));
        Map<Object, DynamicObject> loanApplysFromDBIndex = Arrays.stream(loanApplysFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        for (DynamicObject data : dataEntity) {
            DynamicObject usedcreditlimit;
            String status = data.getString("billstatus");
            this.clearVal(data);
            Date startDate = data.getDate("startdate");
            Date endDate = data.getDate("enddate");
            if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)endDate)) {
                String term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
                data.set("term", (Object)term);
            }
            DynamicObject creditlimit = data.getDynamicObject("creditlimit");
            DynamicObject loanApplyFromDB = loanApplysFromDBIndex.get(data.getPkValue());
            DynamicObject dynamicObject = usedcreditlimit = loanApplyFromDB != null ? loanApplyFromDB.getDynamicObject("creditlimit") : null;
            if (usedcreditlimit != null && creditlimit == null) {
                CreditLimitHelper.deleteCreditUse((Long)data.getLong("id"), (String)data.getDataEntityType().getName());
            }
            data.set("creditor", (Object)LoanApplyHelper.getCreditorId((DynamicObject)data));
            if (!BillStatusEnum.SUBMIT.getValue().equals(status)) continue;
            if (EmptyUtil.isNoEmpty((DynamicObject)creditlimit) && EmptyUtil.isEmpty((DynamicObject)usedcreditlimit)) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, null, (boolean)true, (Date)data.getDate("startdate"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)creditlimit) && EmptyUtil.isNoEmpty((DynamicObject)usedcreditlimit)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)loanApplyFromDB, null, (boolean)true);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, null, (boolean)true, (Date)data.getDate("startdate"));
            }
            if (!EmptyUtil.isEmpty((DynamicObject)creditlimit) || !EmptyUtil.isNoEmpty((DynamicObject)usedcreditlimit)) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)loanApplyFromDB, null, (boolean)true);
        }
    }

    private void clearVal(DynamicObject data) {
        String interestType = data.getString("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            data.set("ratecyclesign", (Object)"");
            data.set("ratecycle", (Object)0);
            data.set("ratetype", null);
            data.set("ratesign", (Object)"");
            data.set("ratefloatpoint", (Object)0);
        }
        if (data.getBigDecimal("interestrate").compareTo(BigDecimal.ZERO) == 0) {
            data.set("floatingratio", (Object)0);
        }
        String repayWay = data.getString("repaymentway");
        if (!(RepaymentWayEnum.bqhbdqhx.getValue().equals(repayWay) || RepaymentWayEnum.dqhbdqhx.getValue().equals(repayWay) || RepaymentWayEnum.zdyhk.getValue().equals(repayWay))) {
            data.set("interestsettledplan", null);
        }
    }
}

