/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.apply;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.BizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySchemeSaveOrSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("creditor");
        selector.add("creditordatatype");
        selector.add("billno");
        selector.add("isneedscheme");
        selector.add("c_number");
        selector.add("finproduct");
        selector.add("loantype");
        selector.add("creditortype");
        selector.add("creditor");
        selector.add("textcreditor");
        selector.add("startdate");
        selector.add("term");
        selector.add("enddate");
        selector.add("guarantee");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("ratecyclesign");
        selector.add("ratecycle");
        selector.add("ratetype");
        selector.add("repaymentway");
        selector.add("interestsettledplan");
        selector.add("creditlimit");
        selector.add("seq");
        selector.add("e_scheme");
        selector.add("e_isselect");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.clearLoanInfo(dataEntities);
        DynamicObject loanApply = dataEntities[0];
        if (this.doValidate(loanApply)) {
            this.deleteOldScheme(loanApply);
            List<DynamicObject> schemeList = this.saveAndUpdateScheme(loanApply);
            this.updateSchemeEntry(loanApply, schemeList);
        }
    }

    private boolean doValidate(DynamicObject loanApply) {
        DynamicObjectCollection schemeCardEntry = loanApply.getDynamicObjectCollection("entry");
        boolean isNeedScheme = loanApply.getBoolean("isneedscheme");
        if (!isNeedScheme) {
            loanApply.getDynamicObjectCollection("entrys").clear();
            DeleteServiceHelper.delete((String)"cfm_financingscheme", (QFilter[])new QFilter[]{new QFilter("loanapply", "=", loanApply.getPkValue())});
            return false;
        }
        String submitByCard = this.getOperationVariable().getOrDefault("submit_by_card", "");
        return EmptyUtil.isNoEmpty((String)submitByCard) && !CollectionUtils.isEmpty((Collection)schemeCardEntry);
    }

    private void deleteOldScheme(DynamicObject loanApply) {
        DynamicObjectCollection schemeCardEntry = loanApply.getDynamicObjectCollection("entry");
        DynamicObjectCollection loanApplysFromDB = QueryServiceHelper.query((String)EntityMetadataCache.getDataEntityType((String)"cfm_loan_apply").getName(), (String)"id,isneedscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", loanApply.getPkValue())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanApplysFromDB) && ((DynamicObject)loanApplysFromDB.get(0)).getBoolean("isneedscheme")) {
            List schemeNumberList = schemeCardEntry.stream().map(v -> v.getString("c_number")).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)"cfm_financingscheme", (QFilter[])new QFilter[]{new QFilter("loanapply", "=", loanApply.getPkValue()), new QFilter("number", "not in", schemeNumberList)});
        }
    }

    private List<DynamicObject> saveAndUpdateScheme(DynamicObject loanApply) {
        Object[] schemeIds;
        DynamicObjectCollection cardEntry = loanApply.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> waitSaveSchemeList = new ArrayList<DynamicObject>(cardEntry.size());
        List schemeNumbers = cardEntry.stream().map(v -> v.getString("c_number")).collect(Collectors.toList());
        DynamicObjectCollection schemeIdsFromsDB = QueryServiceHelper.query((String)"cfm_financingscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", schemeNumbers)});
        Map schemesFromDBMap = new HashMap(schemeIdsFromsDB.size());
        DynamicObject[] schemeFromsDB = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)schemeIdsFromsDB)) {
            schemeIds = schemeIdsFromsDB.stream().map(d -> d.get("id")).toArray();
            schemeFromsDB = TmcDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_financingscheme"));
            schemesFromDBMap = Arrays.stream(schemeFromsDB).collect(Collectors.toMap(v -> v.getString("number"), v -> v, (o1, o2) -> o1, HashMap::new));
        }
        schemeIds = DB.genLongIds((String)"cfm_financingscheme", (int)cardEntry.size());
        int index = 0;
        for (DynamicObject cardRow : cardEntry) {
            DynamicObject scheme;
            String schemeId = cardRow.getString("c_number");
            DynamicObject schemeFromDB = schemesFromDBMap.getOrDefault(schemeId, null);
            DynamicObject dynamicObject = scheme = null == schemeFromDB ? TmcDataServiceHelper.newDynamicObject((String)"cfm_financingscheme") : schemeFromDB;
            if (null == schemeFromDB) {
                scheme.set("id", (Object)schemeIds[index++]);
                scheme.set("loanapply", loanApply.getPkValue());
                scheme.set("org", loanApply.getDynamicObject("company").getPkValue());
                scheme.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                scheme.set("enable", (Object)"1");
                Timestamp currentTime = DateUtils.getCurrentTime();
                scheme.set("createtime", (Object)currentTime);
                scheme.set("applydate", (Object)currentTime);
                scheme.set("bizstatus", (Object)BizStatusEnum.UNDETERMINED.getValue());
            }
            scheme.set("status", (Object)loanApply.getString("billstatus"));
            this.cloneProps(cardRow, scheme);
            waitSaveSchemeList.add(scheme);
        }
        SaveServiceHelper.save((DynamicObject[])waitSaveSchemeList.toArray(new DynamicObject[0]));
        return waitSaveSchemeList;
    }

    private void updateSchemeEntry(DynamicObject loanApply, List<DynamicObject> schemeList) {
        DynamicObjectCollection entry = loanApply.getDynamicObjectCollection("entrys");
        DynamicObjectCollection schemeCardEntry = loanApply.getDynamicObjectCollection("entry");
        entry.clear();
        String selectScheme = this.getSelectScheme(schemeCardEntry);
        int seq = 0;
        for (DynamicObject scheme : schemeList) {
            DynamicObject addNew = entry.addNew();
            addNew.set("seq", (Object)seq++);
            addNew.set("e_scheme", (Object)scheme);
            addNew.set("e_isselect", (Object)StringUtils.equals((CharSequence)selectScheme, (CharSequence)scheme.getString("number")));
        }
    }

    private void cloneProps(DynamicObject srcObj, DynamicObject targetObj) {
        DynamicObject bodyInfo = (DynamicObject)srcObj.getDynamicObjectCollection("s_entry").get(0);
        DataEntityPropertyCollection props = bodyInfo.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : props) {
            String propName = prop.getName();
            if (!propName.startsWith("s_")) continue;
            String realPropName = propName.replace("s_", "");
            Object object = bodyInfo.get(propName);
            targetObj.set(realPropName, object);
        }
        DynamicObjectCollection entrys = srcObj.getDynamicObjectCollection("c_entry");
        DynamicObjectCollection targetEntrys = targetObj.getDynamicObjectCollection("entry");
        targetEntrys.clear();
        for (DynamicObject entry : entrys) {
            DynamicObject newEntry = targetEntrys.addNew();
            DataEntityPropertyCollection entryProps = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : entryProps) {
                String propName = prop.getName();
                if (!propName.startsWith("e_")) continue;
                newEntry.set(propName, entry.get(propName));
            }
        }
    }

    private void clearLoanInfo(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            if (!data.getBoolean("isneedscheme")) continue;
            data.set("finproduct", null);
            data.set("loantype", null);
            data.set("creditor", null);
            data.set("textcreditor", null);
            data.set("startdate", null);
            data.set("term", null);
            data.set("enddate", null);
            data.set("guarantee", null);
            data.set("interesttype", null);
            data.set("interestrate", null);
            data.set("ratetype", null);
            data.set("repaymentway", null);
            data.set("interestsettledplan", null);
            data.set("floatingratio", null);
        }
    }

    private String getSelectScheme(DynamicObjectCollection schemeCardEntry) {
        if (schemeCardEntry.size() == 1) {
            return ((DynamicObject)schemeCardEntry.get(0)).getString("c_number");
        }
        return schemeCardEntry.stream().filter(v -> v.getBoolean("selecttag")).map(v -> v.getString("c_number")).findFirst().orElse(null);
    }
}

