/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.apply;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("creditor");
        selector.add("textcreditor");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("creditlimit");
        selector.add("entry");
        selector.add("e_scheme");
        selector.add("bizdate");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("term");
        return selector;
    }

    public void process(DynamicObject[] dataEntity) throws KDException {
        for (DynamicObject data : dataEntity) {
            Date startDate = data.getDate("startdate");
            Date endDate = data.getDate("enddate");
            if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)endDate)) {
                String term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
                data.set("term", (Object)term);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) {
                CreditLimitHelper.createCreditUse((DynamicObject)data, (boolean)true);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, null, (boolean)true, (Date)data.getDate("startdate"));
                continue;
            }
            CreditLimitHelper.deleteCreditUse((Long)data.getLong("id"), (String)data.getDataEntityType().getName());
        }
        ArrayList schemeIds = new ArrayList();
        for (DynamicObject loanApply : dataEntity) {
            DynamicObjectCollection entrys = loanApply.getDynamicObjectCollection("entrys");
            schemeIds.addAll(entrys.stream().filter(v -> null != v.getDynamicObject("e_scheme")).map(v -> v.getDynamicObject("e_scheme").getPkValue()).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(schemeIds)) {
            DynamicObject[] schemes;
            for (DynamicObject scheme : schemes = TmcDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_financingscheme"))) {
                scheme.set("status", (Object)BillStatusEnum.SUBMIT.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])schemes);
        }
    }
}

