/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.bond;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.helper.BondInvestorHelper;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("investor_entry");
        sic.add("e_creditlimit");
        sic.add("drawamount");
        sic.add("occupybondlimit");
        sic.add("repayamount");
        sic.add("org");
        sic.add("bizdate");
        sic.add("expiredate");
        sic.add("billno");
        sic.add("finproduct");
        sic.add("condition_entry_er");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            BigDecimal drawAmount = dataEntity.getBigDecimal("drawamount");
            BigDecimal repayAmount = dataEntity.getBigDecimal("repayamount");
            DynamicObject occupyBondLimit = dataEntity.getDynamicObject("occupybondlimit");
            DynamicObjectCollection oldBill = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"id,investor_entry.e_creditlimit", (QFilter[])new QFilter[]{new QFilter("id", "=", dataEntity.getPkValue()), new QFilter("investor_entry.e_creditlimit", "!=", (Object)0)});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)oldBill)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataEntity, null, (boolean)true);
            }
            DynamicObjectCollection investEntrys = dataEntity.getDynamicObjectCollection("investor_entry");
            Set<Long> investLimits = BondInvestorHelper.deleteCreditLimitUse(dataEntity.getLong("id"), investEntrys, "e_creditlimit");
            boolean isInit = "true".equals(this.operationVariable.get("byInit"));
            if (EmptyUtil.isNoEmpty(investLimits)) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)dataEntity, null, (!isInit ? 1 : 0) != 0, (Date)dataEntity.getDate("bizdate"));
            }
            if (occupyBondLimit != null) {
                Object pkValue = occupyBondLimit.getPkValue();
                if (isInit) {
                    BondLimitHelper.changeLimitOnInitSave((DynamicObject)dataEntity, (Object)pkValue, (BigDecimal)drawAmount, (BigDecimal)repayAmount);
                } else {
                    BondLimitHelper.changeLimitOnSave((DynamicObject)dataEntity, (Object)pkValue, (BigDecimal)drawAmount);
                }
            } else {
                BondLimitHelper.deleteOldOccupyLimit((DynamicObject)dataEntity, null);
            }
            DynamicObject finProduct = dataEntity.getDynamicObject("finproduct");
            if (!EmptyUtil.isNoEmpty((DynamicObject)finProduct)) continue;
            boolean isPerpetual = finProduct.getBoolean("perpetualbond");
            Date expireDate = dataEntity.getDate("expiredate");
            if (isPerpetual && EmptyUtil.isEmpty((Object)expireDate)) {
                dataEntity.set("expiredate", (Object)DateUtils.getCommonMaxDate());
            }
            if (isPerpetual) continue;
            dataEntity.set("firstredeemdate", null);
            dataEntity.set("firstredeemterm", null);
        }
    }
}

