/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.bond;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("billno");
        sic.add("investor_entry");
        sic.add("e_creditlimit");
        sic.add("drawamount");
        sic.add("occupybondlimit");
        sic.add("org");
        sic.add("bizdate");
        sic.add("expiredate");
        sic.add("billno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection investEntrys = dataEntity.getDynamicObjectCollection("investor_entry");
            long creditCount = investEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_creditlimit"))).count();
            if (creditCount > 0L) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataEntity, null, (boolean)false);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)dataEntity, null, (boolean)true, (Date)dataEntity.getDate("bizdate"));
            }
            BigDecimal drawAmount = dataEntity.getBigDecimal("drawamount");
            DynamicObject occupyBondLimit = dataEntity.getDynamicObject("occupybondlimit");
            if (occupyBondLimit == null) continue;
            Object pkValue = occupyBondLimit.getPkValue();
            BondLimitHelper.changeLimitOnUnsubmitOrUnAudit((DynamicObject)dataEntity, (Object)pkValue, (BigDecimal)drawAmount);
        }
    }
}

