/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.botprelation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import org.apache.commons.lang3.tuple.Pair;

public class EasBotpRelationService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        return sic;
    }

    public void process(DynamicObject[] bills) throws KDException {
    }

    public void beforeCommit(DynamicObject[] bills) throws KDException {
        if (!"Y".equals(this.operationVariable.get("op_from_isc"))) {
            return;
        }
        String billType = bills[0].getDataEntityType().getName();
        this.handleCfmBill(bills, billType);
        this.handleIfmBill(bills, billType);
        this.handleCimBill(bills, billType);
        this.handleBdimBill(bills, billType);
    }

    private void handleCfmBill(DynamicObject[] bills, String billType) {
        if ("cfm_loanbill".equals(billType)) {
            this.saveCfmRelation(bills, "cfm_loancontractbill", "cfm_loanbill", "ifm_loancontractbill", "ifm_loanbill", "cim_invest_contract", "cim_invest_loanbill");
        }
        if ("cfm_repaymentbill".equals(billType)) {
            this.saveCfmRelation(bills, "cfm_loanbill", "cfm_repaymentbill", "ifm_loanbill", "ifm_repaymentbill", "cim_invest_loanbill", "cim_invest_repaybill");
        }
        if ("cfm_interestbill".equals(billType)) {
            this.saveCfmRelation(bills, "cfm_loanbill", "cfm_interestbill", "ifm_loanbill", "ifm_interestbill", "cim_invest_loanbill", "cim_invest_interestbill");
        }
        if ("cfm_preinterestbill".equals(billType)) {
            this.saveCfmRelation(bills, "cfm_loanbill", "cfm_preinterestbill", "ifm_loanbill", "ifm_preinterestbill", "cim_invest_loanbill", "cim_preinterestbill");
        }
    }

    private void handleCimBill(DynamicObject[] bills, String billType) {
        if ("cim_invest_loanbill".equals(billType)) {
            this.saveCimRelation(bills, "cfm_loancontractbill", "cfm_loanbill", "cim_invest_contract", "cim_invest_loanbill");
        }
        if ("cim_invest_repaybill".equals(billType)) {
            this.saveCimRelation(bills, "cfm_loanbill", "cfm_repaymentbill", "cim_invest_loanbill", "cim_invest_repaybill");
        }
        if ("cim_invest_interestbill".equals(billType)) {
            this.saveCimRelation(bills, "cfm_loanbill", "cfm_interestbill", "cim_invest_loanbill", "cim_invest_interestbill");
        }
        if ("cim_preinterestbill".equals(billType)) {
            this.saveCimRelation(bills, "cfm_loanbill", "cfm_preinterestbill", "cim_invest_loanbill", "cim_preinterestbill");
        }
    }

    private void handleIfmBill(DynamicObject[] bills, String billType) {
        if ("ifm_loanbill".equals(billType)) {
            this.saveIfmRelation(bills, "cfm_loancontractbill", "cfm_loanbill", "ifm_loancontractbill", "ifm_loanbill");
        }
        if ("ifm_repaymentbill".equals(billType)) {
            this.saveIfmRelation(bills, "cfm_loanbill", "cfm_repaymentbill", "ifm_loanbill", "ifm_repaymentbill");
        }
        if ("ifm_interestbill".equals(billType)) {
            this.saveIfmRelation(bills, "cfm_loanbill", "cfm_interestbill", "ifm_loanbill", "ifm_interestbill");
        }
        if ("ifm_preinterestbill".equals(billType)) {
            this.saveIfmRelation(bills, "cfm_loanbill", "cfm_preinterestbill", "ifm_loanbill", "ifm_preinterestbill");
        }
    }

    private void saveCfmRelation(DynamicObject[] bills, String cfm_src, String cfm_tar, String ifm_src, String ifm_tar, String cim_src, String cim_tar) {
        ArrayList<Pair> idPairs = new ArrayList<Pair>(bills.length);
        ArrayList<Pair> idPairsForSc = new ArrayList<Pair>(bills.length);
        ArrayList<Pair> idPairsForIc = new ArrayList<Pair>(bills.length);
        for (DynamicObject bill : bills) {
            if (LoanTypeEnum.isBond((String)bill.getString("loantype"))) continue;
            Long srcBillId = bill.getLong("sourcebillid");
            Long targetBillId = bill.getLong("id");
            idPairs.add(Pair.of((Object)srcBillId, (Object)targetBillId));
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(bill.getString("creditortype"))) {
                idPairsForSc.add(Pair.of((Object)srcBillId, (Object)targetBillId));
                continue;
            }
            if (!CreditorTypeEnum.INNERUNIT.getValue().equals(bill.getString("creditortype"))) continue;
            idPairsForIc.add(Pair.of((Object)srcBillId, (Object)targetBillId));
        }
        if (!idPairs.isEmpty()) {
            TmcBotpHelper.batchSaveRelation((String)cfm_src, (String)cfm_tar, idPairs);
        }
        if (!idPairsForSc.isEmpty()) {
            TmcBotpHelper.batchSaveRelation((String)ifm_src, (String)ifm_tar, idPairsForSc);
        }
        if (!idPairsForIc.isEmpty()) {
            TmcBotpHelper.batchSaveRelation((String)cim_src, (String)cim_tar, idPairsForIc);
        }
    }

    private void saveCimRelation(DynamicObject[] bills, String cfm_src, String cfm_tar, String cim_src, String cim_tar) {
        ArrayList<Pair> idPairs = new ArrayList<Pair>(bills.length);
        ArrayList<Pair> idPairsForIc = new ArrayList<Pair>(bills.length);
        for (DynamicObject bill : bills) {
            Long srcBillId = bill.getLong("sourcebillid");
            Long targetBillId = bill.getLong("id");
            idPairs.add(Pair.of((Object)srcBillId, (Object)targetBillId));
            if (!LenderNatureEnum.INGROUP.getValue().equals(bill.getString("lendernature"))) continue;
            idPairsForIc.add(Pair.of((Object)srcBillId, (Object)targetBillId));
        }
        TmcBotpHelper.batchSaveRelation((String)cim_src, (String)cim_tar, idPairs);
        if (!idPairsForIc.isEmpty()) {
            TmcBotpHelper.batchSaveRelation((String)cfm_src, (String)cfm_tar, idPairsForIc);
        }
    }

    private void saveIfmRelation(DynamicObject[] bills, String cfm_src, String cfm_tar, String ifm_src, String ifm_tar) {
        ArrayList<Pair> idPairs = new ArrayList<Pair>(bills.length);
        for (DynamicObject bill : bills) {
            Long srcBillId = bill.getLong("sourcebillid");
            Long targetBillId = bill.getLong("id");
            idPairs.add(Pair.of((Object)srcBillId, (Object)targetBillId));
        }
        TmcBotpHelper.batchSaveRelation((String)ifm_src, (String)ifm_tar, idPairs);
        TmcBotpHelper.batchSaveRelation((String)cfm_src, (String)cfm_tar, idPairs);
    }

    private void handleBdimBill(DynamicObject[] bills, String billType) {
        Long targetBillId;
        Long srcBillId;
        ArrayList<Pair> idPairs = new ArrayList<Pair>(bills.length);
        if ("cfm_loanbill_bond".equals(billType)) {
            for (DynamicObject bill : bills) {
                srcBillId = bill.getLong("sourcebillid");
                targetBillId = bill.getLong("id");
                idPairs.add(Pair.of((Object)srcBillId, (Object)targetBillId));
            }
            TmcBotpHelper.batchSaveRelation((String)"cfm_loancontract_bo", (String)"cfm_loanbill_bond", idPairs);
        }
        if ("cfm_repaymentbill".equals(billType)) {
            for (DynamicObject bill : bills) {
                if (!LoanTypeEnum.isBond((String)bill.getString("loantype"))) continue;
                srcBillId = bill.getLong("sourcebillid");
                targetBillId = bill.getLong("id");
                idPairs.add(Pair.of((Object)srcBillId, (Object)targetBillId));
            }
            if (idPairs.size() > 0) {
                TmcBotpHelper.batchSaveRelation((String)"cfm_loanbill_bond", (String)"cfm_repaymentbill", idPairs);
            }
        }
        if ("cfm_preinterestbill".equals(billType) || "cfm_interestbill".equals(billType)) {
            for (DynamicObject bill : bills) {
                if (!LoanTypeEnum.isBond((String)bill.getString("loantype"))) continue;
                srcBillId = bill.getLong("sourcebillid");
                targetBillId = bill.getLong("id");
                idPairs.add(Pair.of((Object)srcBillId, (Object)targetBillId));
            }
            if (idPairs.size() > 0) {
                TmcBotpHelper.batchSaveRelation((String)"cfm_loanbill_bond", (String)billType, idPairs);
            }
        }
    }
}

