/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.contractapply;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.ContractApplyHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractApplyAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(8);
        sic.add("loancontractbill");
        sic.add("contractno");
        sic.add("contractname");
        sic.add("accountbank");
        sic.add("loaneracctbank");
        sic.add("guarantee");
        sic.add("region");
        sic.add("confirmdescription");
        sic.add("description");
        sic.add("settleintmode");
        sic.add("bizstatus");
        sic.add("confirmstatus");
        sic.add("creditortype");
        sic.add("stageplan");
        sic.add("interestsettledplan");
        sic.add("repaymentway");
        sic.add("gcontract");
        sic.add("gratio");
        sic.add("gamount");
        sic.add("gcontractamount");
        sic.add("gcontractcurrency");
        sic.add("gexchrate");
        sic.add("gcomment");
        sic.add("gcreditortype");
        sic.add("gcreditor");
        sic.add("gcreditortext");
        sic.add("e_project");
        sic.add("e_projdescription");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> loanContractBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject applyBill : dataEntities) {
            String creditorType = (String)applyBill.get("creditortype");
            if ("cim_contract_apply".equals(applyBill.getDataEntityType().getName()) || "ifm_contract_apply".equals(applyBill.getDataEntityType().getName())) {
                loanContractBillList.add(applyBill);
                continue;
            }
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                applyBill.set("bizstatus", (Object)ApplyBizStatusEnum.HANDING.getValue());
                continue;
            }
            if (CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType)) {
                applyBill.set("bizstatus", (Object)ApplyBizStatusEnum.HANDING.getValue());
                applyBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
                continue;
            }
            loanContractBillList.add(applyBill);
        }
        if (EmptyUtil.isNoEmpty(loanContractBillList)) {
            ContractApplyHelper.updateContractInfo((DynamicObject[])loanContractBillList.toArray(new DynamicObject[loanContractBillList.size()]));
        }
    }
}

