/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.contractapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ContractStatusEnum;
import kd.tmc.cfm.common.helper.ContractApplyHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractApplyUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(4);
        sic.add("loancontractbill");
        sic.add("bizstatus");
        sic.add("confirmstatus");
        sic.add("creditortype");
        sic.add("entry_rentplan");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (!EmptyUtil.isEmpty((String)((String)this.getOperationVariable().get("back")))) {
            this.backProcess(dataEntities);
        } else {
            this.unAuditProcess(dataEntities);
        }
    }

    private void unAuditProcess(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> loanContractBillList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> loanBillList = new ArrayList<DynamicObject>(8);
        for (DynamicObject applyBill : dataEntities) {
            DynamicObject[] loanBills;
            String contractName;
            String entityName;
            String creditorType = applyBill.getString("creditortype");
            if (CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType)) {
                applyBill.set("confirmstatus", (Object)ConfirmStatusEnum.REGISTRYING.getValue());
            }
            DynamicObject loanContractF7 = applyBill.getDynamicObject("loancontractbill");
            switch (entityName = applyBill.getDynamicObjectType().getName()) {
                case "fl_contract_apply": {
                    contractName = "fl_leasecontractbill";
                    break;
                }
                case "cim_contract_apply": {
                    contractName = "cim_invest_contract";
                    break;
                }
                default: {
                    contractName = "cfm_loancontractbill";
                }
            }
            DynamicObject historyBill = BillChangeHistoryHelper.genDelChangeHistory((Long)loanContractF7.getLong("id"), (String)contractName);
            DynamicObject loanContractBill = ContractApplyHelper.queryLoanContractBill((String)contractName, (Object)loanContractF7.getPkValue());
            loanContractBill.set("contractstatus", (Object)ContractStatusEnum.UPDATING.getValue());
            this.copyValue(historyBill, loanContractBill);
            applyBill.set("bizstatus", (Object)ApplyBizStatusEnum.APPLYING.getValue());
            loanContractBillList.add(loanContractBill);
            String loanBillName = entityName.equals("fl_contract_apply") ? "fl_receiptbill" : "cfm_loanbill";
            for (DynamicObject loanBill : loanBills = ContractApplyHelper.queryLoanBills((String)loanBillName, (Object)loanContractF7.getPkValue())) {
                ContractApplyHelper.copyGuaranteeEntry((DynamicObjectCollection)historyBill.getDynamicObjectCollection("entry_gcontract"), (DynamicObject)loanBill);
                loanBillList.add(loanBill);
            }
            this.deleteRelateAttachment(entityName, applyBill, contractName, loanContractBill);
        }
        DynamicObject[] loanContractBills = loanContractBillList.toArray(new DynamicObject[loanContractBillList.size()]);
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])loanContractBills, (String[])new String[0]);
        SaveServiceHelper.save((DynamicObject[])loanContractBills);
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])loanBillList.toArray(new DynamicObject[0]), (String[])new String[0]);
        List idList = loanBillList.stream().filter(o -> BillStatusEnum.SUBMIT.getValue().equals(o.getString("billstatus")) || BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toList());
        GuaranteeUseHelper.confirmGuaranteeUse(idList);
        String payBillName = dataEntities[0].getDynamicObjectType().getName().equals("fl_contract_apply") ? "fl_rentpaybill" : "cfm_repaymentbill";
        Object[] repaymentBills = ContractApplyHelper.queryRepaymentBills((String)payBillName, loanContractBillList.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        if (EmptyUtil.isNoEmpty((Object[])repaymentBills)) {
            RepaymentbillHelper.returnGuaranteeUse((DynamicObject[])repaymentBills);
        }
    }

    private void backProcess(DynamicObject[] dynamicObjects) {
        for (DynamicObject dataEntity : dynamicObjects) {
            dataEntity.set("confirmstatus", (Object)ConfirmStatusEnum.YETRETURN.getValue());
            dataEntity.set("bizstatus", (Object)ApplyBizStatusEnum.RETURNED.getValue());
        }
    }

    private void copyValue(DynamicObject historyBill, DynamicObject loanContractBill) {
        Object targetRow;
        for (String prop : ContractApplyHelper.MODIFIABLE_HEAD_PROPS) {
            loanContractBill.set(prop, historyBill.get(prop));
        }
        loanContractBill.getDynamicObjectCollection("entry_gcontract").clear();
        for (DynamicObject sourceRow : historyBill.getDynamicObjectCollection("entry_gcontract")) {
            targetRow = loanContractBill.getDynamicObjectCollection("entry_gcontract").addNew();
            targetRow.set("gcontract", sourceRow.get("gcontract"));
            targetRow.set("gratio", sourceRow.get("gratio"));
            targetRow.set("gamount", sourceRow.get("gamount"));
            targetRow.set("gcontractamount", sourceRow.get("gcontractamount"));
            targetRow.set("gcontractcurrency", sourceRow.get("gcontractcurrency"));
            targetRow.set("gexchrate", sourceRow.get("gexchrate"));
            targetRow.set("gcomment", sourceRow.get("gcomment"));
        }
        loanContractBill.getDynamicObjectCollection("project_entry").clear();
        for (DynamicObject sourceRow : historyBill.getDynamicObjectCollection("project_entry")) {
            targetRow = loanContractBill.getDynamicObjectCollection("project_entry").addNew();
            targetRow.set("e_project", sourceRow.get("e_project"));
            targetRow.set("e_projdescription", sourceRow.get("e_projdescription"));
        }
        String entityName = loanContractBill.getDynamicObjectType().getName();
        if ("fl_leasecontractbill".equals(entityName)) {
            List<String> headProps = Arrays.asList("term", "enddate");
            for (String string : headProps) {
                loanContractBill.set(string, historyBill.get(string));
            }
            List<String> leaseHoldInfo = Arrays.asList("leaseholdtype", "leaseholdtypeid", "leasehold", "leaseholdid", "assetcount", "unit", "repurchaseamt", "repurchase", "address");
            for (String prop : leaseHoldInfo) {
                loanContractBill.set(prop, historyBill.get(prop));
            }
            List<String> list = Arrays.asList("startinterestrate", "interestrate", "referencerate", "ratesign", "ratefloatpoint");
            for (String prop : list) {
                loanContractBill.set(prop, historyBill.get(prop));
            }
            loanContractBill.getDynamicObjectCollection("entry_rentplan").clear();
            for (DynamicObject sourceRow : historyBill.getDynamicObjectCollection("entry_rentplan")) {
                DynamicObject targetRow2 = loanContractBill.getDynamicObjectCollection("entry_rentplan").addNew();
                targetRow2.set("paydate", sourceRow.get("paydate"));
                targetRow2.set("startrevdate", sourceRow.get("startrevdate"));
                targetRow2.set("endrevdate", sourceRow.get("endrevdate"));
                targetRow2.set("rentamt", sourceRow.get("rentamt"));
                targetRow2.set("principal", sourceRow.get("principal"));
                targetRow2.set("intamt", sourceRow.get("intamt"));
                targetRow2.set("taxrate", sourceRow.get("taxrate"));
                targetRow2.set("taxamt", sourceRow.get("taxamt"));
                targetRow2.set("excludetaxamt", sourceRow.get("excludetaxamt"));
                targetRow2.set("residueamt", sourceRow.get("residueamt"));
                targetRow2.set("payacct", sourceRow.get("payacct"));
                targetRow2.set("executestatus", sourceRow.get("executestatus"));
                targetRow2.set("notes", sourceRow.get("notes"));
            }
        }
    }

    private void deleteRelateAttachment(String entityName, DynamicObject applyBill, String contractName, DynamicObject loanContractBill) {
        TmcAttachmentHelper.deleteAttachment((String)entityName, (Object)applyBill.getPkValue(), (String)contractName, (Object)loanContractBill.getPkValue());
        if ("cim_contract_apply".equals(entityName) && CreditorTypeEnum.isInnerUnit((String)applyBill.getString("creditortype"))) {
            TmcAttachmentHelper.deleteAttachment((String)entityName, (Object)applyBill.getPkValue(), (String)"cfm_loancontractbill", (Object)loanContractBill.getPkValue());
        } else if ("cfm_contract_apply".equals(entityName) && CreditorTypeEnum.isInnerUnit((String)applyBill.getString("creditortype"))) {
            TmcAttachmentHelper.deleteAttachment((String)entityName, (Object)applyBill.getPkValue(), (String)"cim_invest_contract", (Object)loanContractBill.getPkValue());
        }
    }
}

