/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.contractbill;

import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cfm.common.operate.LoanBillOperate;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractAutoDrawService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(ContractAutoDrawService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        String entryName = dataEntities[0].getDynamicObjectType().getName();
        String dataSource = dataEntities[0].getString("datasource");
        Map operationVariable = this.getOperationVariable();
        String status = (String)operationVariable.get("billstatus");
        OperateOption option = OperateOption.create();
        option.setVariableValue("auto", "true");
        option.setVariableValue("billstatus", "save");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"loanbillinitpushandsave", (String)entryName, (DynamicObject[])dataEntities, (OperateOption)option);
        if (!operationResult.isSuccess() && EmptyUtil.isNoEmpty((Object)operationResult.getAllErrorInfo())) {
            OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operationResult.getAllErrorInfo().get(0);
            logger.info("push loanBill save error >> " + operateErrorInfo.getMessage());
        }
        for (Object data : operationResult.getSuccessPkIds()) {
            DynamicObject loanBill;
            if (!"submit".equals(status) && !"audit".equals(status) || EmptyUtil.isEmpty((DynamicObject)(loanBill = LoanBillRepository.getAutoDrawByContractId(data, (String)dataSource)))) continue;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            OperationResult submitResult = LoanBillOperate.submit((DynamicObject[])new DynamicObject[]{loanBill}, (OperateOption)operateOption);
            if (!"audit".equals(status) || !submitResult.isSuccess()) continue;
            LoanBillOperate.audit((DynamicObject[])new DynamicObject[]{loanBill}, (OperateOption)operateOption);
        }
    }
}

