/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.extapplybill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sdk.tmc.cfm.extpoint.extapply.IExtApplyBillSecondDevFields;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExtApplyBillPush2ExtendService
extends AbstractTmcBizOppService {
    private static String[] LOANBILL_PROPS = new String[]{"id", "billno", "currency", "drawamount", "amount", "bizdate", "loanrate", "expiredate", "repayamount", "renewalexpiredate", "notrepayamount"};
    private static Log logger = LogFactory.getLog(ExtApplyBillPush2ExtendService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_loanbill");
        sic.add("amount");
        sic.add("e_repayamount");
        sic.add("loancontractbill");
        sic.add("businessstatus");
        sic.add("bizdate");
        sic.add("renewalexpiredate");
        sic.add("isadjustinterestrate");
        sic.add("referencerate");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustcycletype");
        sic.add("rateadjustcycle");
        sic.add("renewalinterestrate");
        sic.add("protocolno");
        sic.add("currency");
        sic.add("e_lrenewalexpiredate");
        sic.add("e_isrenewal");
        sic.add("e_exrateadjustdate");
        sic.add("creator");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject extApplyBill : dataEntities) {
            this.doPush2ExtendBill(extApplyBill);
        }
    }

    private void doPush2ExtendBill(DynamicObject extApplyBill) {
        extApplyBill.set("businessstatus", (Object)ApplyBusinessStatusEnum.HANDING.getValue());
        DynamicObject contractF7 = extApplyBill.getDynamicObject("loancontractbill");
        DynamicObject[] extBills = TmcBotpHelper.batchPush((Object[])new Object[]{contractF7.getPkValue()}, (String)"cfm_loancontractbill", (String)"cfm_contractextendbill");
        DynamicObject extBill = extBills[0];
        extBill.set("extendapplyf7", (Object)extApplyBill);
        extBill.set("bizdate", (Object)extApplyBill.getDate("bizdate"));
        extBill.set("protocolno", (Object)extApplyBill.getString("protocolno"));
        extBill.set("renewalexpiredate", (Object)extApplyBill.getDate("renewalexpiredate"));
        extBill.set("isadjustinterestrate", (Object)extApplyBill.getBoolean("isadjustinterestrate"));
        extBill.set("creator", (Object)extApplyBill.getDynamicObject("creator"));
        String interestType = contractF7.getString("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            extBill.set("referencerate", (Object)extApplyBill.getDynamicObject("referencerate"));
            extBill.set("ratesign", (Object)extApplyBill.getString("ratesign"));
            extBill.set("ratefloatpoint", (Object)extApplyBill.getBigDecimal("ratefloatpoint"));
            extBill.set("rateadjuststyle", (Object)extApplyBill.getString("rateadjuststyle"));
            extBill.set("rateadjustcycletype", (Object)extApplyBill.getString("rateadjustcycletype"));
            extBill.set("rateadjustcycle", (Object)extApplyBill.getInt("rateadjustcycle"));
        } else {
            extBill.set("renewalinterestrate", (Object)extApplyBill.getBigDecimal("renewalinterestrate"));
        }
        DynamicObjectCollection applyLoans = extApplyBill.getDynamicObjectCollection("loans");
        ArrayList<Long> loanIds = new ArrayList<Long>(10);
        for (DynamicObject loan : applyLoans) {
            DynamicObject loanObj = loan.getDynamicObject("e_loanbill");
            if (EmptyUtil.isEmpty((DynamicObject)loanObj)) {
                throw new KDBizException(CfmBusinessResourceEnum.ExtendApplyBillPush2ExtendService_1.loadKDString());
            }
            loanIds.add(loanObj.getLong("id"));
        }
        DynamicObjectCollection extEntrys = extBill.getDynamicObjectCollection("loanbilllist");
        int seq = 1;
        CharSequence[] selectProperties = LOANBILL_PROPS;
        DynamicObjectCollection loadBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds)});
        Map<Long, DynamicObject> loadIdObjMap = loadBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (DynamicObject applyExtEntry : applyLoans) {
            DynamicObject loanBill = loadIdObjMap.get(applyExtEntry.getDynamicObject("e_loanbill").getLong("id"));
            DynamicObject extEntry = extEntrys.addNew();
            extEntry.set("seq", (Object)seq++);
            extEntry.set("drawbillid", (Object)loanBill.getLong("id"));
            extEntry.set("drawbillno", (Object)loanBill.getString("billno"));
            extEntry.set("drawcurrency", (Object)loanBill.getLong("currency"));
            extEntry.set("ldrawamount", (Object)loanBill.getBigDecimal("drawamount"));
            extEntry.set("loandate", (Object)loanBill.getDate("bizdate"));
            extEntry.set("loanrate", (Object)loanBill.getBigDecimal("loanrate"));
            extEntry.set("expiredate", (Object)loanBill.getDate("expiredate"));
            extEntry.set("repayamount", (Object)loanBill.getBigDecimal("repayamount"));
            extEntry.set("lnotrepayamount", (Object)loanBill.getBigDecimal("notrepayamount"));
            extEntry.set("extendamount", (Object)loanBill.getBigDecimal("notrepayamount"));
            Object expiredateBeforeRenewal = loanBill.get("renewalexpiredate") == null ? loanBill.get("expiredate") : loanBill.get("renewalexpiredate");
            extEntry.set("e_prevrenewalexpiredate", expiredateBeforeRenewal);
            extEntry.set("lrenewalexpiredate", (Object)applyExtEntry.getDate("e_lrenewalexpiredate"));
            extEntry.set("isrenewal", (Object)applyExtEntry.getBoolean("e_isrenewal"));
            extEntry.set("exrateadjustdate", (Object)applyExtEntry.getDate("e_exrateadjustdate"));
        }
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{extApplyBill});
        try {
            OperateOption option = OperateOption.create();
            this.dealExtApplySecondDev(extApplyBill, option);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"cfm_contractextendbill", (DynamicObject[])extBills, (OperateOption)option, (boolean)true);
            if (CfmBillCommonHelper.isSettleCenter((DynamicObject)extApplyBill) || CfmBillCommonHelper.isInnerOrg((DynamicObject)extApplyBill)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("WF", "TRUE");
                TmcOperateServiceHelper.execOperate((String)"submit", (String)"cfm_contractextendbill", (DynamicObject[])extBills, (OperateOption)operateOption);
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"cfm_contractextendbill", (DynamicObject[])extBills, (OperateOption)OperateOption.create());
                extApplyBill.set("businessstatus", (Object)ApplyBusinessStatusEnum.HANDED.getValue());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25:%s", (String)"ExtendApplyBillPush2ExtendService_0", (String)"tmc-cfm-business", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private void dealExtApplySecondDev(DynamicObject extApplyBill, OperateOption option) {
        PluginProxy pluginProxy = PluginProxy.create(IExtApplyBillSecondDevFields.class, (String)"kd.sdk.tmc.cfm.extpoint.extapply.IExtApplyBillSecondDevFields.extApplyBillSecondDevFields");
        List result = pluginProxy.callReplace(proxy -> proxy.extApplyBillSecondDevFields(extApplyBill)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        logger.info(String.format("\u5904\u7406\u7ed3\u679c\u53c2\u6570\uff1a%s", result));
        if (EmptyUtil.isNoEmpty(result) && EmptyUtil.isNoEmpty(result.get(0))) {
            Map fields = (Map)result.get(0);
            option.setVariableValue("SecondDevFieldVal", JSON.toJSONString((Object)fields));
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        Object[] applyids = Arrays.stream(dataEntities).map(o -> o.getLong("id")).toArray();
        DeleteServiceHelper.delete((String)"cfm_contractextendbill", (QFilter[])new QFilter[]{new QFilter("extendapplyf7", "in", (Object)applyids)});
    }
}

